/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.impl.ResourceBundleHelper;
import org.eclipse.e4.tools.services.impl.ResourceBundleTranslationProvider;

public class ProjectOSGiTranslationProvider
extends ResourceBundleTranslationProvider {
    public static final String META_INF_DIRECTORY_NAME = "META-INF";
    public static final String MANIFEST_DEFAULT_PATH = "META-INF/MANIFEST.MF";
    private IProject project;
    private String basename;
    private Locale locale;

    public ProjectOSGiTranslationProvider(IProject project, String locale) {
        super(null);
        this.project = project;
        this.project.getWorkspace().addResourceChangeListener(event -> {
            if (event.getType() == 1) {
                try {
                    event.getDelta().accept(this::visit);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        });
        this.setLocale(locale, (Boolean)false);
        IFile f = this.project.getFile(MANIFEST_DEFAULT_PATH);
        if (f.exists()) {
            this.handleManifestChange(f);
        } else {
            this.basename = "OSGI-INF/l10n/bundle";
        }
    }

    @Inject
    void setLocale(@Named(value="org.eclipse.e4.core.locale") @Named(value="org.eclipse.e4.core.locale") String locale, @Optional Boolean performUpdate) {
        try {
            this.locale = locale == null ? Locale.getDefault() : ResourceBundleHelper.toLocale((String)locale);
        }
        catch (Exception exception) {
            this.locale = Locale.getDefault();
        }
        if (performUpdate == null || performUpdate.booleanValue()) {
            this.updateResourceBundle();
        }
    }

    @Inject
    void setLocale(@Named(value="org.eclipse.e4.core.locale") @Named(value="org.eclipse.e4.core.locale") Locale locale, @Optional Boolean performUpdate) {
        Locale locale2 = this.locale = locale == null ? Locale.getDefault() : locale;
        if (performUpdate == null || performUpdate.booleanValue()) {
            this.updateResourceBundle();
        }
    }

    boolean visit(IResourceDelta delta) {
        String fileBaseName;
        String filename;
        if (delta.getResource() instanceof IWorkspaceRoot) {
            return true;
        }
        if (delta.getResource().equals((Object)this.project)) {
            return true;
        }
        if (delta.getResource().getProjectRelativePath().toString().equals(META_INF_DIRECTORY_NAME)) {
            return true;
        }
        if (delta.getResource().getProjectRelativePath().toString().equals(MANIFEST_DEFAULT_PATH)) {
            this.handleManifestChange((IFile)delta.getResource());
            return false;
        }
        if (delta.getResource() instanceof IFile && (filename = ((IFile)delta.getResource()).getName()).startsWith(fileBaseName = this.basename.substring(this.basename.lastIndexOf("/") + 1, this.basename.length()))) {
            this.updateResourceBundle();
            return false;
        }
        if (delta.getResource().getProjectRelativePath().toString().equals(this.basename)) {
            this.updateResourceBundle();
            return false;
        }
        String[] p = this.basename.split("/");
        int i = 0;
        String path = "";
        do {
            path = String.valueOf(path) + p[i];
            if (delta.getResource().getProjectRelativePath().toString().equals(path)) {
                return true;
            }
            path = String.valueOf(path) + "/";
        } while (++i < p.length);
        return false;
    }

    private void handleManifestChange(IFile file) {
        try {
            if (!file.isAccessible()) {
                return;
            }
            String newValue = ProjectOSGiTranslationProvider.extractBasenameFromManifest(file);
            if (!newValue.equals(this.basename)) {
                this.basename = newValue;
                if (this.basename != null) {
                    this.updateResourceBundle();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String extractBasenameFromManifest(IFile file) throws CoreException, IOException {
        String newValue = "OSGI-INF/l10n/bundle";
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream in = file.getContents();
            try {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(in));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        if (!line.startsWith("Bundle-Localization")) continue;
                        newValue = line.substring("Bundle-Localization".length() + 1).trim();
                        break;
                    }
                }
                if (in == null) return newValue;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return newValue;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected void updateResourceBundle() {
        this.setResourceBundle(ResourceBundleHelper.getEquinoxResourceBundle((String)this.basename, (Locale)this.locale, (ResourceBundle.Control)new ProjectResourceBundleControl(true), (ResourceBundle.Control)new ProjectResourceBundleControl(false)));
    }

    class ProjectResourceBundleControl
    extends ResourceBundle.Control {
        private final boolean useFallback;

        ProjectResourceBundleControl(boolean useFallback) {
            this.useFallback = useFallback;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            PropertyResourceBundle bundle = null;
            if (format.equals("java.properties")) {
                String resourceName = this.toResourceName(bundleName, "properties");
                InputStream stream = null;
                try {
                    stream = AccessController.doPrivileged(() -> this.getResourceAsStream(resourceName));
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                if (stream != null) {
                    try {
                        bundle = new PropertyResourceBundle(stream);
                    }
                    finally {
                        stream.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown format: " + format);
            }
            return bundle;
        }

        protected InputStream getResourceAsStream(String name) {
            IFile f = ProjectOSGiTranslationProvider.this.project.getFile(name);
            try {
                if (f.exists()) {
                    return f.getContents();
                }
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return this.useFallback ? super.getFallbackLocale(baseName, locale) : null;
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            return -1L;
        }
    }
}

