/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.actions.OpenSchemaAction;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.search.FindReferencesAction;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.NewSchemaFileWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ExtensionPointDetails
extends PDEDetails {
    private IPluginExtensionPoint fInput;
    private FormEntry fIdEntry;
    private FormEntry fNameEntry;
    private FormEntry fSchemaEntry;
    private FormText fRichText;
    private String fRichTextData;
    private static final String SCHEMA_RTEXT_DATA = PDEUIMessages.ExtensionPointDetails_schemaLinks;
    private static final String NO_SCHEMA_RTEXT_DATA = PDEUIMessages.ExtensionPointDetails_noSchemaLinks;

    @Override
    public String getContextId() {
        return "plugin-context";
    }

    @Override
    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    @Override
    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    @Override
    public boolean isEditable() {
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        return model != null && model.isEditable();
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 384);
        section.clientVerticalSpacing = 6;
        section.setText(PDEUIMessages.ExtensionPointDetails_title);
        section.setDescription(PDEUIMessages.ExtensionPointDetails_desc);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(770));
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(768));
        this.fIdEntry = new FormEntry(client, toolkit, PDEUIMessages.ExtensionPointDetails_id, null, false);
        this.fIdEntry.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (ExtensionPointDetails.this.fInput != null) {
                    try {
                        ExtensionPointDetails.this.fInput.setId(ExtensionPointDetails.this.fIdEntry.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.fNameEntry = new FormEntry(client, toolkit, PDEUIMessages.ExtensionPointDetails_name, null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (ExtensionPointDetails.this.fInput != null) {
                    try {
                        ExtensionPointDetails.this.fInput.setName(ExtensionPointDetails.this.fNameEntry.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        boolean editable = this.getPage().getModel().isEditable();
        this.fSchemaEntry = new FormEntry(client, toolkit, PDEUIMessages.ExtensionPointDetails_schema, PDEUIMessages.ExtensionPointDetails_browse, editable);
        this.fSchemaEntry.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (ExtensionPointDetails.this.fInput != null) {
                    try {
                        ExtensionPointDetails.this.fInput.setSchema(ExtensionPointDetails.this.fSchemaEntry.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                    ExtensionPointDetails.this.updateRichText();
                }
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                IProject project = ExtensionPointDetails.this.getPage().getPDEEditor().getCommonProject();
                if (ExtensionPointDetails.this.fSchemaEntry.getValue() == null || ExtensionPointDetails.this.fSchemaEntry.getValue().length() == 0) {
                    ExtensionPointDetails.this.generateSchema();
                    return;
                }
                IFile file = project.getFile(ExtensionPointDetails.this.fSchemaEntry.getValue());
                if (file.exists()) {
                    ExtensionPointDetails.this.openSchemaFile(file);
                } else {
                    ExtensionPointDetails.this.generateSchema();
                }
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                Object[] elements;
                IProject project = ExtensionPointDetails.this.getPage().getPDEEditor().getCommonProject();
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(PDEUIMessages.ManifestEditor_ExtensionPointDetails_schemaLocation_title);
                dialog.setMessage(PDEUIMessages.ManifestEditor_ExtensionPointDetails_schemaLocation_desc);
                dialog.setDoubleClickSelects(false);
                dialog.setAllowMultiple(false);
                dialog.addFilter(new ViewerFilter(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public boolean select(Viewer viewer, Object parent, Object element) {
                        if (element instanceof IFile) {
                            String ext = ((IFile)element).getFullPath().getFileExtension();
                            if ("exsd".equals(ext)) return true;
                            if ("mxsd".equals(ext)) return true;
                            return false;
                        }
                        if (!(element instanceof IContainer)) return false;
                        try {
                            IResource[] resources;
                            IResource[] iResourceArray = resources = ((IContainer)element).members();
                            int n = resources.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) {
                                    return false;
                                }
                                IResource resource = iResourceArray[n2];
                                if (this.select(viewer, parent, resource)) {
                                    return true;
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException e) {
                            PDEPlugin.logException(e);
                        }
                        return false;
                    }
                });
                dialog.setValidator(selection -> {
                    IPluginModelBase model = (IPluginModelBase)ExtensionPointDetails.this.getPage().getPDEEditor().getAggregateModel();
                    String pluginName = model.getPluginBase().getId();
                    if (selection == null || selection.length != 1 || !(selection[0] instanceof IFile)) {
                        return new Status(4, pluginName, 4, PDEUIMessages.ManifestEditor_ExtensionPointDetails_validate_errorStatus, null);
                    }
                    IFile file = (IFile)selection[0];
                    String ext = file.getFullPath().getFileExtension();
                    if ("exsd".equals(ext) || "mxsd".equals(ext)) {
                        return new Status(0, pluginName, 0, "", null);
                    }
                    return new Status(4, pluginName, 4, PDEUIMessages.ManifestEditor_ExtensionPointDetails_validate_errorStatus, null);
                });
                dialog.setDoubleClickSelects(true);
                dialog.setStatusLineAboveButtons(true);
                dialog.setInput((Object)project);
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                String filePath = ExtensionPointDetails.this.fSchemaEntry.getValue();
                if (filePath != null && filePath.length() != 0 && project.exists((IPath)new Path(filePath))) {
                    dialog.setInitialSelection((Object)project.getFile((IPath)new Path(filePath)));
                } else {
                    dialog.setInitialSelection(null);
                }
                dialog.create();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.browse_extension_points_schemas");
                if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0) {
                    IResource elem = (IResource)elements[0];
                    ExtensionPointDetails.this.fSchemaEntry.setValue(elem.getProjectRelativePath().toString());
                }
            }
        });
        this.createSpacer(toolkit, client, 2);
        Composite container = toolkit.createComposite(parent, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        container.setLayoutData((Object)new GridData(770));
        this.fRichText = toolkit.createFormText(container, true);
        this.fRichText.setImage("open", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SCHEMA_OBJ));
        this.fRichText.setImage("desc", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DOC_SECTION_OBJ));
        this.fRichText.setImage("search", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PSEARCH_OBJ));
        this.fRichText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IBaseModel model = ExtensionPointDetails.this.getPage().getPDEEditor().getAggregateModel();
                String pointID = null;
                IPluginBase base = ((IPluginModelBase)model).getPluginBase();
                String pluginID = base.getId();
                String schemaVersion = base.getSchemaVersion();
                if (schemaVersion != null && Double.parseDouble(schemaVersion) >= 3.2 && ExtensionPointDetails.this.fInput.getId().indexOf(46) != -1) {
                    pointID = ExtensionPointDetails.this.fInput.getId();
                }
                if (pointID == null) {
                    pointID = String.valueOf(pluginID) + "." + ExtensionPointDetails.this.fInput.getId();
                }
                IPluginExtensionPoint extPoint = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint(pointID);
                if (e.getHref().equals("search")) {
                    new FindReferencesAction(ExtensionPointDetails.this.fInput, pluginID).run();
                } else if (e.getHref().equals("open")) {
                    if (extPoint == null) {
                        IProject project = ExtensionPointDetails.this.getPage().getPDEEditor().getCommonProject();
                        IFile file = project.getFile(ExtensionPointDetails.this.fSchemaEntry.getValue());
                        if (file.exists()) {
                            ExtensionPointDetails.this.openSchemaFile(file);
                        } else {
                            ExtensionPointDetails.this.generateSchema();
                        }
                        return;
                    }
                    OpenSchemaAction action = new OpenSchemaAction();
                    action.setInput(pointID);
                    action.setEnabled(true);
                    action.run();
                } else {
                    if (extPoint == null) {
                        URL url;
                        IProject project = ExtensionPointDetails.this.getPage().getPDEEditor().getCommonProject();
                        IFile file = project.getFile(ExtensionPointDetails.this.fSchemaEntry.getValue());
                        try {
                            url = file.getLocationURI().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            return;
                        }
                        SchemaDescriptor schemaDesc = new SchemaDescriptor(pointID, url);
                        Schema schema = new Schema((ISchemaDescriptor)schemaDesc, url, false);
                        schema.setPluginId(pluginID);
                        schema.setPointId(ExtensionPointDetails.this.fInput.getId());
                        schema.setName(ExtensionPointDetails.this.fNameEntry.getValue());
                        new ShowDescriptionAction((ISchema)schema).run();
                        return;
                    }
                    new ShowDescriptionAction(pointID).run();
                }
            }
        });
        this.fIdEntry.setEditable(this.isEditable());
        this.fNameEntry.setEditable(this.isEditable());
        this.fSchemaEntry.setEditable(this.isEditable());
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.markDetailsPart((Control)section);
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object obj;
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]).equals(this.fInput)) {
            this.refresh();
        }
    }

    private void update() {
        this.fIdEntry.setValue(this.fInput != null && this.fInput.getId() != null ? this.fInput.getId() : "", true);
        this.fNameEntry.setValue(this.fInput != null && this.fInput.getName() != null ? this.fInput.getName() : "", true);
        this.fSchemaEntry.setValue(this.fInput != null && this.fInput.getSchema() != null ? this.fInput.getSchema() : "", true);
        this.updateRichText();
    }

    @Override
    public void cancelEdit() {
        this.fIdEntry.cancelEdit();
        this.fNameEntry.cancelEdit();
        this.fSchemaEntry.cancelEdit();
        this.updateRichText();
        super.cancelEdit();
    }

    private void updateRichText() {
        boolean hasSchema;
        boolean bl = hasSchema = this.fSchemaEntry.getValue().length() > 0;
        if (hasSchema && this.fRichTextData == SCHEMA_RTEXT_DATA) {
            return;
        }
        if (!hasSchema && this.fRichTextData == NO_SCHEMA_RTEXT_DATA) {
            return;
        }
        this.fRichTextData = hasSchema ? SCHEMA_RTEXT_DATA : NO_SCHEMA_RTEXT_DATA;
        this.fRichText.setText(this.fRichTextData, true, false);
        this.getManagedForm().getForm().reflow(true);
    }

    private void openSchemaFile(IFile file) {
        IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(() -> {
            try {
                String editorId = "org.eclipse.pde.ui.schemaEditor";
                ww.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId);
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
            }
        });
    }

    private void generateSchema() {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        BusyIndicator.showWhile((Display)this.getPage().getPartControl().getDisplay(), () -> {
            NewSchemaFileWizard wizard = new NewSchemaFileWizard(project, this.fInput, true);
            WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
            if (dialog.open() == 0) {
                this.update();
            }
        });
    }

    public void selectionChanged(IFormPart masterPart, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.fInput = ssel.size() == 1 ? (IPluginExtensionPoint)ssel.getFirstElement() : null;
        this.update();
    }

    public void commit(boolean onSave) {
        this.fIdEntry.commit();
        this.fNameEntry.commit();
        this.fSchemaEntry.commit();
        super.commit(onSave);
    }

    public void setFocus() {
        this.fIdEntry.getText().setFocus();
    }

    public void refresh() {
        this.update();
        super.refresh();
    }
}

