/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EArgument;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.reachabilitygraph.DeterministicScenarios;
import org.eclipse.comma.reachabilitygraph.Edge;
import org.eclipse.comma.reachabilitygraph.Node;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraph;

class GsonHelper {
    GsonHelper() {
    }

    public static Gson getGson(boolean pretty) {
        GsonBuilder builder = new GsonBuilder().serializeNulls();
        builder.registerTypeAdapter(DeterministicScenarios.class, (Object)new DeterministicScenariosSerializer());
        builder.registerTypeAdapter(ReachabilityGraph.class, (Object)new ReachabilityGraphSerializer());
        builder.registerTypeAdapter(EAction.class, (Object)new EActionSerializer());
        builder.registerTypeAdapter(EVariable.class, (Object)new EVariableSerializer());
        builder.registerTypeAdapter(EArgument.class, (Object)new EArgumentSerializer());
        builder.registerTypeAdapter(ENotification.class, (Object)new EActionSerializer());
        builder.registerTypeAdapter(EReply.class, (Object)new EActionSerializer());
        builder.registerTypeAdapter(ECommand.class, (Object)new EActionSerializer());
        builder.registerTypeAdapter(ESignal.class, (Object)new EActionSerializer());
        if (pretty) {
            builder = builder.setPrettyPrinting();
        }
        return builder.create();
    }

    public static ReachabilityGraph fromJSON(String json) {
        Gson gson = GsonHelper.getGson(false);
        return (ReachabilityGraph)gson.fromJson(json, ReachabilityGraph.class);
    }

    private static void removeIfNull(JsonObject obj, String property) {
        if (obj.has(property) && obj.get(property).isJsonNull()) {
            obj.remove(property);
        }
    }

    private static void removeNullPortConnectionReturnValue(JsonObject obj) {
        GsonHelper.removeIfNull(obj, "port");
        GsonHelper.removeIfNull(obj, "connection");
        GsonHelper.removeIfNull(obj, "return_value");
    }

    public static String toJSON(ReachabilityGraph graph, boolean pretty) {
        Gson gson = GsonHelper.getGson(pretty);
        JsonObject root = gson.toJsonTree((Object)graph).getAsJsonObject();
        root.getAsJsonObject("graph").getAsJsonArray("edges").forEach(edge -> edge.getAsJsonObject().getAsJsonArray("entries").forEach(entry -> GsonHelper.removeNullPortConnectionReturnValue(entry.getAsJsonObject())));
        return gson.toJson((JsonElement)root);
    }

    public static String toJSON(DeterministicScenarios scenarios, boolean pretty) {
        Gson gson = GsonHelper.getGson(pretty);
        JsonObject root = gson.toJsonTree((Object)scenarios).getAsJsonObject();
        root.getAsJsonArray("scenarios").forEach(scenario -> scenario.getAsJsonArray().forEach(e -> GsonHelper.removeNullPortConnectionReturnValue(e.getAsJsonObject())));
        return gson.toJson((JsonElement)root);
    }

    static class DeterministicScenariosSerializer
    implements JsonSerializer<DeterministicScenarios>,
    JsonDeserializer<DeterministicScenarios> {
        DeterministicScenariosSerializer() {
        }

        public DeterministicScenarios deserialize(JsonElement r, Type arg1, JsonDeserializationContext context) throws JsonParseException {
            throw new RuntimeException("Not supported");
        }

        public JsonElement serialize(DeterministicScenarios ds, Type arg1, JsonSerializationContext context) {
            JsonObject root = new JsonObject();
            root.add("scenarios", context.serialize(ds.getScenariosEntries()));
            return root;
        }
    }

    static class EActionSerializer
    implements JsonSerializer<EAction>,
    JsonDeserializer<EAction> {
        private final Gson gson = new GsonBuilder().serializeNulls().registerTypeAdapter(EVariable.class, (Object)new EVariableSerializer()).registerTypeAdapter(EArgument.class, (Object)new EArgumentSerializer()).create();

        EActionSerializer() {
        }

        public EAction deserialize(JsonElement rootElement, Type arg1, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = rootElement.getAsJsonObject();
            String kind = root.get("kind").getAsString();
            if (root.has("connection")) {
                JsonObject connection = new JsonObject();
                connection.add("id", root.get("connection"));
                connection.add("port", root.get("port"));
                root.add("connection", (JsonElement)connection);
            }
            switch (kind) {
                case "Command": {
                    return (EAction)this.gson.fromJson((JsonElement)root, ECommand.class);
                }
                case "Signal": {
                    return (EAction)this.gson.fromJson((JsonElement)root, ESignal.class);
                }
                case "Reply": {
                    root.getAsJsonObject().add("returnValue", root.getAsJsonObject().get("return_value"));
                    return (EAction)this.gson.fromJson((JsonElement)root, EReply.class);
                }
                case "Notification": {
                    return (EAction)this.gson.fromJson((JsonElement)root, ENotification.class);
                }
            }
            throw new RuntimeException("Unsupported");
        }

        public JsonElement serialize(EAction action, Type arg1, JsonSerializationContext context) {
            JsonObject json = this.gson.toJsonTree((Object)action).getAsJsonObject();
            json.addProperty("kind", action.getClass().getName().replace("org.eclipse.comma.evaluator.E", ""));
            if (action instanceof EReply) {
                json.add("return_value", json.get("returnValue"));
                json.remove("returnValue");
            }
            if (action.connection != null) {
                JsonObject connection = json.get("connection").getAsJsonObject();
                json.remove("connection");
                json.add("connection", connection.get("id"));
                json.add("port", connection.get("port"));
            }
            return json;
        }
    }

    static class EArgumentSerializer
    implements JsonSerializer<EArgument>,
    JsonDeserializer<EArgument> {
        private final EVariableSerializer variableSerializer = new EVariableSerializer();

        EArgumentSerializer() {
        }

        public JsonElement serialize(EArgument argument, Type type, JsonSerializationContext context) {
            JsonObject obj = (JsonObject)this.variableSerializer.serialize((EVariable)argument, type, context);
            obj.add("direction", context.serialize((Object)argument.direction));
            return obj;
        }

        public EArgument deserialize(JsonElement root, Type type, JsonDeserializationContext context) throws JsonParseException {
            EVariable variable = this.variableSerializer.deserialize(root, type, context);
            return new EArgument(variable, root.getAsJsonObject().get("direction").getAsString());
        }
    }

    static class EVariableSerializer
    implements JsonSerializer<EVariable>,
    JsonDeserializer<EVariable> {
        EVariableSerializer() {
        }

        public JsonElement serialize(EVariable variable, Type type, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("type", variable.type.name().toLowerCase());
            if (variable.type == EVariableType.MAP) {
                JsonArray value = new JsonArray();
                variable.getValueMap().entrySet().forEach(entry -> {
                    JsonObject e = new JsonObject();
                    e.add("key", context.serialize(entry.getKey()));
                    e.add("value", context.serialize(entry.getValue()));
                    value.add((JsonElement)e);
                });
                obj.add("value", (JsonElement)value);
            } else {
                obj.add("value", context.serialize(variable.value));
            }
            if (variable.subtype != null) {
                obj.add("subtype", context.serialize((Object)variable.subtype));
            }
            return obj;
        }

        public EVariable deserialize(JsonElement r, Type t, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = r.getAsJsonObject();
            EVariableType type = EVariableType.valueOf((String)root.get("type").getAsString().toUpperCase());
            String subtype = root.has("subtype") ? root.get("subtype").getAsString() : null;
            Serializable value = null;
            if (type == EVariableType.MAP) {
                LinkedHashMap v = new LinkedHashMap();
                root.get("value").getAsJsonArray().forEach(vv -> {
                    EVariable key = (EVariable)context.deserialize(vv.getAsJsonObject().get("key"), EVariable.class);
                    EVariable vvv = (EVariable)context.deserialize(vv.getAsJsonObject().get("value"), EVariable.class);
                    v.put(key, vvv);
                });
                value = v;
            } else {
                value = context.deserialize(root.get("value"), Object.class);
                if (type == EVariableType.INT) {
                    value = (int)Math.round((Double)value);
                }
            }
            return new EVariable(type, value, subtype);
        }
    }

    static class ReachabilityGraphSerializer
    implements JsonSerializer<ReachabilityGraph>,
    JsonDeserializer<ReachabilityGraph> {
        ReachabilityGraphSerializer() {
        }

        public ReachabilityGraph deserialize(JsonElement r, Type arg1, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = r.getAsJsonObject().getAsJsonObject("graph");
            ReachabilityGraph graph = new ReachabilityGraph();
            root.getAsJsonObject("nodes").entrySet().forEach(e -> {
                JsonObject n = ((JsonElement)e.getValue()).getAsJsonObject();
                String name = (String)e.getKey();
                String state = n.get("state").getAsString();
                String trigger = n.has("trigger") ? n.get("trigger").getAsString() : null;
                reachabilityGraph.nodes.add(new Node(name, state, trigger));
            });
            root.getAsJsonArray("edges").forEach(e -> {
                JsonObject n = e.getAsJsonObject();
                Node source = graph.getNode(n.get("source").getAsString()).get();
                Node target = graph.getNode(n.get("target").getAsString()).get();
                Type actionsType = new TypeToken<ArrayList<EAction>>(){}.getType();
                Edge edge = new Edge(source, target);
                edge.entries = (List)context.deserialize((JsonElement)n.getAsJsonArray("entries"), actionsType);
                reachabilityGraph.edges.add(edge);
            });
            JsonObject metadata = root.getAsJsonObject("metadata");
            graph.initial = graph.getNode(metadata.get("initial").getAsString()).get();
            graph.depth = metadata.get("depth").getAsInt();
            graph.maxDepth = metadata.get("max-depth").getAsInt();
            graph.totalStates = metadata.get("total-states").getAsInt();
            graph.coveredStates = metadata.get("covered-states").getAsInt();
            graph.totalClauses = metadata.get("total-clauses").getAsInt();
            graph.coveredClauses = metadata.get("covered-clauses").getAsInt();
            return graph;
        }

        public JsonElement serialize(ReachabilityGraph rg, Type arg1, JsonSerializationContext context) {
            JsonObject nodes = new JsonObject();
            rg.nodes.stream().forEach(n -> {
                JsonObject nodeJson = new JsonObject();
                nodeJson.addProperty("state", n.state);
                if (n.trigger != null) {
                    nodeJson.addProperty("trigger", n.trigger);
                }
                nodes.add(n.name, (JsonElement)nodeJson);
            });
            JsonArray edges = new JsonArray();
            rg.edges.stream().forEach(e -> {
                JsonObject edgeJson = new JsonObject();
                edgeJson.addProperty("source", e.source.name);
                edgeJson.addProperty("target", e.target.name);
                edgeJson.add("entries", context.serialize(e.entries));
                edges.add((JsonElement)edgeJson);
            });
            JsonObject metadata = new JsonObject();
            metadata.addProperty("initial", rg.initial.name);
            metadata.addProperty("depth", (Number)rg.depth);
            metadata.addProperty("max-depth", (Number)rg.maxDepth);
            metadata.addProperty("total-states", (Number)rg.totalStates);
            metadata.addProperty("covered-states", (Number)rg.coveredStates);
            metadata.addProperty("total-clauses", (Number)rg.totalClauses);
            metadata.addProperty("covered-clauses", (Number)rg.coveredClauses);
            JsonObject graph = new JsonObject();
            graph.add("metadata", (JsonElement)metadata);
            graph.add("nodes", (JsonElement)nodes);
            graph.add("edges", (JsonElement)edges);
            JsonObject root = new JsonObject();
            root.add("graph", (JsonElement)graph);
            return root;
        }
    }
}

