/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.impl.AssignmentActionImpl;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.ConstraintState;
import org.eclipse.comma.behavior.component.component.EventReception;
import org.eclipse.comma.behavior.component.component.ExpressionConnectionState;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.TraceFragment;
import org.eclipse.comma.behavior.component.component.impl.CommandEventImpl;
import org.eclipse.comma.behavior.component.component.impl.CommandReplyImpl;
import org.eclipse.comma.behavior.component.component.impl.NotificationEventImpl;
import org.eclipse.comma.behavior.component.component.impl.SignalEventImpl;
import org.eclipse.comma.behavior.component.component.impl.StateBasedFunctionalConstraintImpl;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EArgument;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EComponentState;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EIConstraint;
import org.eclipse.comma.evaluator.EInterfaceState;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.impl.CommandImpl;
import org.eclipse.comma.signature.interfaceSignature.impl.NotificationImpl;
import org.eclipse.comma.signature.interfaceSignature.impl.SignalImpl;
import org.eclipse.emf.common.util.EList;

public class EStateBasedFunctionalConstraint
implements EIConstraint {
    private final StateBasedFunctionalConstraintImpl constraint;
    private final ConstraintState state;
    private final EVariableCollection variables;
    private List<WrappedTraceFragment> allowedFragments;

    public EStateBasedFunctionalConstraint(StateBasedFunctionalConstraintImpl c) {
        this.allowedFragments = null;
        this.constraint = c;
        this.state = (ConstraintState)this.constraint.getStates().stream().filter(s -> s.isInitial()).findFirst().get();
        this.variables = new EVariableCollection();
        c.getVars().forEach(v -> this.variables.add((Variable)v));
        if (c.getInitActions().size() != 0) {
            throw new RuntimeException("Not yet implemented");
        }
        if (this.constraint.getUsedEvents().isEmpty()) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    public List<WrappedTraceFragment> getAllowedFragment(EComponentState currentState, EComponentState nextState, EAction action) {
        if (this.allowedFragments == null) {
            ArrayList<WrappedTraceFragment> allowedFragments = new ArrayList<WrappedTraceFragment>();
            for (TraceFragment fragment : this.state.getTraceFragments()) {
                boolean conditionTrue;
                EventReception firstAction = (EventReception)fragment.getFirstAction();
                EventPattern firstEvent = firstAction.getEvent();
                WrappedEvent wrappedEvent = new WrappedEvent(firstEvent, this.variables);
                EVariableCollection variables = this.variables;
                if (wrappedEvent.idVarName != null) {
                    variables = variables.clone();
                    variables.put(wrappedEvent.idVarName, variables.get(wrappedEvent.idVarName).clone(action.connection));
                }
                boolean bl = conditionTrue = firstAction.getCondition() == null || this.isConditionTrue(firstAction.getCondition(), currentState, variables);
                if (!wrappedEvent.equalsAction(action) || !conditionTrue) continue;
                allowedFragments.add(new WrappedTraceFragment(fragment, 0, variables));
            }
            return allowedFragments;
        }
        return this.allowedFragments.stream().map(f -> {
            WrappedTraceFragment fragment = new WrappedTraceFragment(f.fragment, f.index, f.variables.clone());
            int i = fragment.index;
            while (i < fragment.fragment.getActions().size()) {
                Action a = (Action)fragment.fragment.getActions().get(i);
                if (!(a instanceof AssignmentActionImpl)) {
                    if (a instanceof EventReception) {
                        if (((EventReception)a).getCondition() != null) {
                            throw new RuntimeException("Not supported");
                        }
                        WrappedEvent event = new WrappedEvent(((EventReception)a).getEvent(), fragment.variables);
                        if (!event.equalsAction(action)) {
                            return null;
                        }
                        ++fragment.index;
                        break;
                    }
                    throw new RuntimeException("Not supported");
                }
                AssignmentActionImpl aa = (AssignmentActionImpl)a;
                fragment.variables.put(aa.getAssignment().getName(), EVariable.fromExpression(aa.getExp(), fragment.variables));
                ++i;
            }
            return fragment;
        }).filter(f -> f != null).collect(Collectors.toList());
    }

    @Override
    public boolean isAllowed(EComponentState currentState, EComponentState nextState, EAction action) {
        if (this.isUsedEvent(action)) {
            boolean allowed = !this.getAllowedFragment(currentState, nextState, action).isEmpty();
            return allowed;
        }
        return true;
    }

    @Override
    public EIConstraint take(EComponentState currentState, EComponentState nextState, EAction action) {
        if (this.isUsedEvent(action)) {
            List<WrappedTraceFragment> allowedFragments = this.getAllowedFragment(currentState, nextState, action);
            EVariableCollection variables = this.variables;
            ConstraintState state = this.state;
            Optional<WrappedTraceFragment> fragment = allowedFragments.stream().filter(f -> f.isCompleted()).findFirst();
            if (fragment.isPresent()) {
                allowedFragments = null;
                variables = fragment.get().variables;
                state = fragment.get().fragment.getTarget();
            }
            return new EStateBasedFunctionalConstraint(this.constraint, state, variables, allowedFragments);
        }
        return this;
    }

    private EStateBasedFunctionalConstraint(StateBasedFunctionalConstraintImpl c, ConstraintState state, EVariableCollection variables, List<WrappedTraceFragment> allowedFragments) {
        this.constraint = c;
        this.state = state;
        this.variables = variables;
        this.allowedFragments = allowedFragments;
    }

    private boolean isConditionTrue(Expression condition, final EComponentState state, final EVariableCollection variables) {
        return EVariable.fromExpression(condition, variables, new BiFunction<Expression, EVariableCollection, EVariable>(){

            @Override
            public EVariable apply(Expression expression, EVariableCollection u) {
                if (expression instanceof ExpressionInterfaceState) {
                    ExpressionInterfaceState c = (ExpressionInterfaceState)expression;
                    StateMachine machine = (StateMachine)c.getState().eContainer();
                    List states = state.connections.entrySet().stream().filter(e -> ((EConnection)e.getKey()).port.equals(c.getPort().getName())).map(e -> (EInterfaceState)e.getValue()).collect(Collectors.toList());
                    if (states.size() != 1) {
                        throw new RuntimeException("Not supported");
                    }
                    return new EVariable(EVariableType.BOOL, ((EInterfaceState)states.get((int)0)).states.get(machine) == c.getState(), null);
                }
                if (expression instanceof ExpressionConnectionState) {
                    ExpressionConnectionState c = (ExpressionConnectionState)expression;
                    if (!c.getQuantifier().getLiteral().equals("all") || c.getMultiplicity() != null) {
                        throw new RuntimeException("Not supported");
                    }
                    String port = c.getPort().getName();
                    String id = variables.get((String)c.getIdVar().getVariable().getName()).getValueConnection().id;
                    List<State> states = ((EInterfaceState)state.connections.entrySet().stream().filter(e -> ((EConnection)e.getKey()).id.equals(id) && ((EConnection)e.getKey()).port.equals(port)).findFirst().get().getValue()).getCurrentStates();
                    return new EVariable(EVariableType.BOOL, c.getStates().stream().anyMatch(s -> states.contains(s)), null);
                }
                throw new RuntimeException("Not supported");
            }
        }).getValueBool();
    }

    private boolean isUsedEvent(EAction action) {
        return this.constraint.getUsedEvents().stream().anyMatch(eventPattern -> {
            WrappedEvent wrappedEvent = new WrappedEvent((EventPattern)eventPattern, this.variables);
            return wrappedEvent.equalsAction(action);
        });
    }

    @Override
    public boolean usesRequiredPort(List<Port> ports) {
        for (EventPattern eventPattern : this.constraint.getUsedEvents()) {
            WrappedEvent wrappedEvent = new WrappedEvent(eventPattern, null);
            Port port = ports.stream().filter(p -> p.getName().equals(wrappedEvent.port)).findFirst().get();
            if (!(port instanceof RequiredPort)) continue;
            return true;
        }
        return false;
    }

    private class WrappedEvent {
        public final Object event;
        public final String port;
        public final String type;
        public final String name;
        public final String idVarName;
        public final List<EVariable> parameters;

        public boolean equalsAction(EAction action) {
            boolean match = false;
            ArrayList<EArgument> actionParameters = null;
            if (!(action instanceof ECommand || action instanceof EReply || action instanceof ENotification || action instanceof ESignal)) {
                throw new RuntimeException("Not supported");
            }
            if (action instanceof ESignal && this.type.equals("signal") && ((ESignal)action).method.equals(this.name)) {
                match = true;
                actionParameters = new ArrayList<EArgument>(((ESignal)action).arguments);
            }
            if (action instanceof ECommand && this.type.equals("command") && ((ECommand)action).method.equals(this.name)) {
                match = true;
                actionParameters = new ArrayList<EArgument>(((ECommand)action).arguments);
            }
            if (action instanceof ENotification && this.type.equals("notification") && ((ENotification)action).method.equals(this.name)) {
                match = true;
                actionParameters = new ArrayList<EArgument>(((ENotification)action).arguments);
            }
            if (action instanceof EReply && this.type.equals("reply") && ((EReply)action).method.equals(this.name)) {
                match = true;
                EReply reply = (EReply)action;
                actionParameters = new ArrayList<EArgument>(reply.arguments);
                if (reply.returnValue != null) {
                    actionParameters.add((EArgument)reply.returnValue);
                }
            }
            if (match && this.parameters.size() != 0 && actionParameters != null) {
                int i = 0;
                while (i < this.parameters.size()) {
                    EVariable parameter = this.parameters.get(i);
                    EVariable actionParameter = (EVariable)actionParameters.get(i);
                    if (parameter.type != EVariableType.ANY && !parameter.equals(actionParameter)) {
                        return false;
                    }
                    ++i;
                }
            }
            return match && this.port.equals(action.connection.port);
        }

        public WrappedEvent(EventPattern eventPattern, EVariableCollection variables) {
            EList parameters;
            ExpressionVariable idVar = null;
            if (eventPattern instanceof CommandEventImpl) {
                CommandEventImpl e = (CommandEventImpl)eventPattern;
                this.event = e.getEvent();
                this.port = e.getPort().getName();
                this.type = "command";
                idVar = e.getIdVar();
                this.name = ((CommandImpl)e.getEvent()).getName();
                parameters = ((CommandEventImpl)eventPattern).getParameters();
            } else if (eventPattern instanceof CommandReplyImpl) {
                CommandReplyImpl e = (CommandReplyImpl)eventPattern;
                this.event = e.getCommand().getEvent();
                this.port = e.getPort().getName();
                this.type = "reply";
                idVar = e.getIdVar();
                this.name = e.getCommand().getEvent().getName();
                parameters = e.getParameters();
            } else if (eventPattern instanceof NotificationEventImpl) {
                NotificationEventImpl e = (NotificationEventImpl)eventPattern;
                this.event = e.getEvent();
                this.port = e.getPort().getName();
                this.type = "notification";
                idVar = e.getIdVar();
                this.name = ((NotificationImpl)e.getEvent()).getName();
                parameters = e.getParameters();
            } else if (eventPattern instanceof SignalEventImpl) {
                SignalEventImpl e = (SignalEventImpl)eventPattern;
                this.event = e.getEvent();
                this.port = e.getPort().getName();
                this.type = "signal";
                idVar = e.getIdVar();
                this.name = ((SignalImpl)e.getEvent()).getName();
                parameters = e.getParameters();
            } else {
                throw new RuntimeException("Not supported");
            }
            this.idVarName = idVar != null ? idVar.getVariable().getName() : null;
            this.parameters = parameters.stream().map(p -> EVariable.fromExpression(p, variables)).collect(Collectors.toList());
            if (!(this.event instanceof CommandImpl || this.event instanceof NotificationImpl || this.event instanceof SignalImpl)) {
                throw new RuntimeException("Wrong event");
            }
        }
    }

    private class WrappedTraceFragment {
        public final TraceFragment fragment;
        public int index;
        public final EVariableCollection variables;

        private WrappedTraceFragment(TraceFragment fragment, int index, EVariableCollection variables) {
            this.fragment = fragment;
            this.index = index;
            this.variables = variables;
        }

        boolean isCompleted() {
            return this.index == this.fragment.getActions().size();
        }
    }
}

