/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertLineAction
extends QuickDiffRestoreAction {
    private int fLine;

    public RevertLineAction(ITextEditor editor, boolean isRulerAction) {
        super(QuickDiffMessages.getResourceBundle(), "RevertLineAction.", editor, isRulerAction);
    }

    @Override
    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        this.fLine = this.getLastLine();
        if (this.fLine == -1) {
            return false;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ == null) {
            return false;
        }
        ILineDiffInfo info = differ.getLineInfo(this.fLine);
        if (info == null || info.getChangeType() == 0) {
            return false;
        }
        if (info.getChangeType() == 1) {
            this.setText(QuickDiffMessages.getString("RevertLineAction.delete.label"));
        } else {
            this.setText(QuickDiffMessages.getString("RevertLineAction.label"));
        }
        return true;
    }

    @Override
    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer differ = this.getDiffer();
        if (differ != null) {
            try {
                differ.revertLine(this.fLine);
            }
            catch (BadLocationException e) {
                this.setStatus(e.getMessage());
            }
        }
    }
}

