/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public abstract class ProjectWizard
extends Wizard
implements INewWizard {
    private static final String WIZARD_NAME = "New CommaSuite project";
    private static final Logger LOGGER = Logger.getLogger(ProjectWizard.class.getName());
    private static final String XTEXT_NATURE = "org.eclipse.xtext.ui.shared.xtextNature";
    private WizardNewProjectCreationPage pageOne;

    public ProjectWizard() {
        this.setWindowTitle(WIZARD_NAME);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        String name = this.pageOne.getProjectName();
        URI location = null;
        if (!this.pageOne.useDefaults()) {
            location = this.pageOne.getLocationURI();
        }
        try {
            this.createProject(name, location, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 275) {
                this.pageOne.setErrorMessage("A project with that name but different capitalization already exists in the workspace.");
            }
            LOGGER.log(Level.WARNING, "Error trying to create project.", e);
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new WizardNewProjectCreationPage(WIZARD_NAME);
        this.pageOne.setTitle(WIZARD_NAME);
        this.pageOne.setDescription("This wizard creates a new CommaSuite project");
        this.addPage((IWizardPage)this.pageOne);
    }

    public IProject createProject(String projectName, URI location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)projectName);
        Assert.isTrue((projectName.trim().length() > 0 ? 1 : 0) != 0);
        IProject project = ProjectWizard.createBaseProject(projectName, location, monitor);
        this.addProjectStructure(project);
        ProjectWizard.addXtextNature(project, monitor);
        return project;
    }

    private static IProject createBaseProject(String projectName, URI location, IProgressMonitor monitor) throws CoreException {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            URI projectLocation = location;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            newProject.create(desc, monitor);
            if (!newProject.isOpen()) {
                newProject.open(monitor);
            }
        }
        return newProject;
    }

    private void addProjectStructure(IProject newProject) throws CoreException {
        this.createFile(newProject.getFile("Example.prj"));
        this.createFile(newProject.getFile("Example.signature"));
        this.createFile(newProject.getFile("Example.interface"));
        this.createFile(newProject.getFile("Template.docx"));
    }

    private void createFile(IFile file) throws CoreException {
        InputStream inputStream = null;
        try {
            URL url = new URL(String.valueOf(this.getTemplateLocation()) + file.getName());
            inputStream = url.openConnection().getInputStream();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error trying to create File.", e);
        }
        file.create(inputStream, true, null);
    }

    protected abstract String getTemplateLocation();

    public static void addXtextNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(XTEXT_NATURE)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = XTEXT_NATURE;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }
}

