/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.comma.monitoring.lib.CComponentMonitor;
import org.eclipse.comma.monitoring.lib.CConnectionResults;
import org.eclipse.comma.monitoring.lib.CError;
import org.eclipse.comma.monitoring.lib.CExecutionContext;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CInterfaceDecisionClass;
import org.eclipse.comma.monitoring.lib.CInterfaceDecisionResult;
import org.eclipse.comma.monitoring.lib.CInterfaceDecisionResultKind;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringError;
import org.eclipse.comma.monitoring.lib.CInterfaceRuntimeError;
import org.eclipse.comma.monitoring.lib.CMalformedTraceError;
import org.eclipse.comma.monitoring.lib.CPathDescription;
import org.eclipse.comma.monitoring.lib.CState;
import org.eclipse.comma.monitoring.lib.constraints.CDataRuleObserver;
import org.eclipse.comma.monitoring.lib.constraints.CRule;
import org.eclipse.comma.monitoring.lib.constraints.CRuleError;
import org.eclipse.comma.monitoring.lib.constraints.CRulesExecutor;
import org.eclipse.comma.monitoring.lib.constraints.CTimeRuleObserver;
import org.eclipse.comma.monitoring.lib.messages.CMatchResult;
import org.eclipse.comma.monitoring.lib.messages.CMessagePattern;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedNotification;
import org.eclipse.comma.monitoring.lib.messages.CObservedReply;
import org.eclipse.comma.monitoring.lib.messages.CObservedSignal;
import org.eclipse.comma.monitoring.lib.utils.CTraceSerializer;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public class CInterfaceMonitor {
    private CInterfaceMonitoringContext context;
    private List<CExecutionContext> executionContexts;
    private CInterfaceDecisionClass decisionClass;
    private List<CPathDescription> pathDescriptions = null;
    private CObservedCommand lastSeenCommand;
    private CConnectionResults monitoringResult;
    private boolean inErrorState;
    private CTraceSerializer traceSerializer;
    private CRulesExecutor rulesRunner;
    private CComponentMonitor componentMonitor = null;

    public CInterfaceMonitor(CInterfaceMonitoringContext context, CFactory factory) {
        this.context = context;
        this.executionContexts = new ArrayList<CExecutionContext>();
        CExecutionContext initialContext = new CExecutionContext();
        initialContext.setExecutionPathId("p");
        this.executionContexts.add(initialContext);
        this.lastSeenCommand = null;
        this.monitoringResult = new CConnectionResults(context);
        this.inErrorState = false;
        this.traceSerializer = new CTraceSerializer(context.getTraceFile());
        this.decisionClass = factory.createDecisionClass(context.getInterfaceName());
        this.rulesRunner = new CRulesExecutor(context);
        List<CRule> rules = this.decisionClass.getRules();
        this.registerRuleObservers(rules);
        this.rulesRunner.setListOfRules(rules);
        initialContext.setRulesExecutor(this.rulesRunner);
    }

    private void registerRuleObservers(List<CRule> rules) {
        CTimeRuleObserver observerTR = new CTimeRuleObserver(this.context.getTimeStatisticsFileName(), "time");
        CDataRuleObserver observerDR = new CDataRuleObserver(this.context.getDataStatisticsFileName(), "data");
        for (CRule r : rules) {
            r.registerObserver(observerTR);
            r.registerObserver(observerDR);
        }
    }

    public CInterfaceMonitor(CInterfaceMonitoringContext context, CFactory factory, CComponentMonitor componentMonitor) {
        this(context, factory);
        this.componentMonitor = componentMonitor;
    }

    public boolean inErrorState() {
        return this.inErrorState;
    }

    private void executeRules(CObservedMessage m, CExecutionContext context, String state) {
        CObservedMessage newObservation = m.clone();
        newObservation.addState(state);
        this.monitoringResult.addConstraintErrors(context.consumeEvent(newObservation));
    }

    private void setRuleExecutor(CExecutionContext currentContext, CExecutionContext newContext) {
        newContext.setRulesExecutor((CRulesExecutor)Utils.deepCopy(currentContext.getRulesExecutor()));
    }

    private void serializeResults() {
        try {
            FileWriter umlWriter;
            FileWriter writer = new FileWriter(this.context.getResultsFile(), true);
            writer.write(this.monitoringResult.toString());
            writer.close();
            if (!this.monitoringResult.isSuccess()) {
                for (CError error : this.monitoringResult.getMonitoringErrors()) {
                    String umlErrorFileName = this.context.getErrorUMLFile();
                    umlWriter = new FileWriter(umlErrorFileName, false);
                    umlWriter.write(error.toUML());
                    umlWriter.close();
                    error.setUMLFile(umlErrorFileName);
                }
            }
            List<CRuleError> ruleErrors = this.monitoringResult.getConstraintErrors();
            int i = 0;
            while (i < ruleErrors.size()) {
                String umlRuleErrorFileName = this.context.getRuleErrorUMLFile(i);
                umlWriter = new FileWriter(umlRuleErrorFileName, false);
                umlWriter.write(ruleErrors.get(i).toUML());
                umlWriter.close();
                ruleErrors.get(i).setUMLFile(umlRuleErrorFileName);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void traceEnded() {
        if (!this.inErrorState) {
            for (CExecutionContext context : this.executionContexts) {
                CState s = context.getState();
                this.monitoringResult.addExecutionState(s);
            }
            if (this.componentMonitor != null) {
                this.componentMonitor.connectionMonitoringDone(this.monitoringResult);
            }
        }
        this.serializeResults();
    }

    public CConnectionResults getResults() {
        return this.monitoringResult;
    }

    private boolean isTraceMalformed(CObservedMessage message) {
        String errorMessage = null;
        if (message instanceof CObservedCommand) {
            if (this.lastSeenCommand == null) {
                this.lastSeenCommand = (CObservedCommand)message;
            } else {
                errorMessage = "Malformed trace: nested blocking calls.";
            }
        } else if (message instanceof CObservedReply) {
            if (this.lastSeenCommand != null) {
                ((CObservedReply)message).setCommand(this.lastSeenCommand);
                this.lastSeenCommand = null;
            } else {
                errorMessage = "Malformed trace: reply without a call.";
            }
        } else if (message instanceof CObservedSignal && this.lastSeenCommand != null) {
            errorMessage = "Malformed trace: signal sent before reply to a blocking call.";
        }
        if (errorMessage != null) {
            CMalformedTraceError error = new CMalformedTraceError(errorMessage);
            error.setErrorContext(this.traceSerializer.getLatestTrace());
            this.monitoringResult.addMonitoringError(error);
            this.inErrorState = true;
            return true;
        }
        return false;
    }

    public boolean consume(CObservedMessage message) throws Exception {
        if (this.inErrorState) {
            return false;
        }
        this.traceSerializer.processEvent(message);
        if (this.isTraceMalformed(message)) {
            this.serializeResults();
            if (this.componentMonitor != null) {
                this.componentMonitor.connectionError(this.monitoringResult);
            }
            return false;
        }
        ArrayList<CExecutionContext> newExecutionContexts = new ArrayList<CExecutionContext>();
        ArrayList<CExecutionContext> processedContexts = new ArrayList<CExecutionContext>();
        ArrayList<CMessagePattern> possibleEvents = new ArrayList<CMessagePattern>();
        this.pathDescriptions = new ArrayList<CPathDescription>();
        int i = 0;
        while (i < this.executionContexts.size()) {
            CExecutionContext context = this.executionContexts.get(i);
            int oldNumberNewContexts = newExecutionContexts.size();
            if (context.expectedMessagesEmpty()) {
                CState state = context.getState();
                if (state != null) {
                    context.setExecuted(true);
                    processedContexts.add(context);
                    this.decisionClass.setState(state);
                }
                CInterfaceDecisionResult result = this.decisionClass.consume(message);
                if (result.resutKind == CInterfaceDecisionResultKind.RUNTIME_ERROR) {
                    CInterfaceRuntimeError error = new CInterfaceRuntimeError(message, result.errorMessage, state);
                    error.setErrorContext(this.traceSerializer.getLatestTrace());
                    this.monitoringResult.addMonitoringError(error);
                    this.inErrorState = true;
                    this.serializeResults();
                    if (this.componentMonitor != null) {
                        this.componentMonitor.connectionError(this.monitoringResult);
                    }
                    return false;
                }
                if (result.resutKind == CInterfaceDecisionResultKind.SUCCESS) {
                    this.postProcessMessage(context, newExecutionContexts, result.expectedObservations, possibleEvents, message);
                }
            } else {
                context.setExecuted(false);
                processedContexts.add(context);
                ArrayList<CMessagePattern> oldPossibleEvents = new ArrayList<CMessagePattern>(possibleEvents);
                possibleEvents.addAll(context.getPossibleEvents());
                CMatchResult matchResult = this.matchExpectedObservation(message, context, newExecutionContexts);
                if (matchResult == CMatchResult.MATCH || matchResult == CMatchResult.DROP) {
                    this.executeRules(message, context, context.getState().getExecutionState());
                } else if (matchResult == CMatchResult.SKIP) {
                    processedContexts.remove(processedContexts.size() - 1);
                    possibleEvents = oldPossibleEvents;
                    --i;
                }
            }
            int j = 0;
            while (j < newExecutionContexts.size() - oldNumberNewContexts) {
                if (newExecutionContexts.size() - oldNumberNewContexts == 1) {
                    ((CExecutionContext)newExecutionContexts.get(newExecutionContexts.size() - 1)).setExecutionPathId(context.getExecutionPathId());
                    this.pathDescriptions.get(this.pathDescriptions.size() - 1).setPathId(context.getExecutionPathId());
                } else {
                    ((CExecutionContext)newExecutionContexts.get(oldNumberNewContexts + j)).setExecutionPathId(String.valueOf(context.getExecutionPathId()) + j);
                    this.pathDescriptions.get(oldNumberNewContexts + j).setPathId(String.valueOf(context.getExecutionPathId()) + j);
                }
                ++j;
            }
            ++i;
        }
        if (newExecutionContexts.isEmpty()) {
            CInterfaceMonitoringError error = new CInterfaceMonitoringError(message, processedContexts, possibleEvents);
            error.setErrorContext(this.traceSerializer.getLatestTrace());
            this.monitoringResult.addMonitoringError(error);
            this.inErrorState = true;
            this.serializeResults();
            if (this.componentMonitor != null) {
                this.componentMonitor.connectionError(this.monitoringResult);
            }
            return false;
        }
        this.executionContexts = newExecutionContexts;
        if (this.componentMonitor != null) {
            this.componentMonitor.consume(message, this.pathDescriptions);
        }
        return true;
    }

    private void postProcessMessage(CExecutionContext currentContext, List<CExecutionContext> newContexts, List<CExecutionContext> receivedContexts, List<CMessagePattern> possibleEvents, CObservedMessage message) {
        if (message instanceof CObservedNotification || message instanceof CObservedReply) {
            boolean executed = false;
            for (CExecutionContext receivedContext : receivedContexts) {
                CMatchResult matchResult;
                if (!receivedContext.expectedMessagesEmpty()) {
                    possibleEvents.addAll(receivedContext.getPossibleEvents());
                }
                if ((matchResult = this.matchExpectedObservation(message, receivedContext, newContexts)) != CMatchResult.MATCH && matchResult != CMatchResult.DROP) continue;
                if (!executed) {
                    this.executeRules(message, currentContext, receivedContext.getState().getExecutionState());
                    executed = true;
                }
                this.setRuleExecutor(currentContext, receivedContext);
            }
        } else {
            if (receivedContexts.isEmpty()) {
                return;
            }
            this.executeRules(message, currentContext, receivedContexts.get(0).getState().getExecutionState());
            for (CExecutionContext context : receivedContexts) {
                CState receivedState = context.getState();
                CPathDescription pathDescription = new CPathDescription();
                context.setPathDescription(pathDescription);
                HashSet<String> activeStates = new HashSet<String>(receivedState.getActiveStates());
                activeStates.remove(receivedState.getActiveState());
                activeStates.add(receivedState.getExecutionState());
                pathDescription.setActiveStates(activeStates);
                if (context.expectedMessagesEmpty() || !context.expectedMessagesSkippable()) {
                    if (context.expectedMessagesEmpty()) {
                        pathDescription.setPostEventStates(new HashSet<String>(receivedState.getActiveStates()));
                    } else {
                        pathDescription.setPostEventStates(new HashSet<String>(pathDescription.getActiveStates()));
                    }
                } else {
                    pathDescription.setPostEventStates(new HashSet<String>(receivedState.getActiveStates()));
                    pathDescription.setPostStatesUnknown();
                }
                this.pathDescriptions.add(pathDescription);
                this.setRuleExecutor(currentContext, context);
                newContexts.add(context);
            }
        }
    }

    private CMatchResult matchExpectedObservation(CObservedMessage message, CExecutionContext context, List<CExecutionContext> newContexts) {
        if (context.expectedMessagesEmpty()) {
            return CMatchResult.FAIL;
        }
        CMatchResult result = context.getExpectedMessages().match(message);
        if (result == CMatchResult.MATCH || result == CMatchResult.DROP) {
            CPathDescription pathDescription = new CPathDescription();
            context.setPathDescription(pathDescription);
            CState receivedState = context.getState();
            HashSet<String> activeStates = new HashSet<String>(receivedState.getActiveStates());
            activeStates.remove(receivedState.getActiveState());
            activeStates.add(receivedState.getExecutionState());
            pathDescription.setActiveStates(activeStates);
            if (context.expectedMessagesEmpty() || !context.expectedMessagesSkippable()) {
                if (context.expectedMessagesEmpty()) {
                    pathDescription.setPostEventStates(new HashSet<String>(receivedState.getActiveStates()));
                } else {
                    pathDescription.setPostEventStates(new HashSet<String>(pathDescription.getActiveStates()));
                }
            } else {
                pathDescription.setPostEventStates(new HashSet<String>(receivedState.getActiveStates()));
                pathDescription.setPostStatesUnknown();
            }
            this.pathDescriptions.add(pathDescription);
            newContexts.add(context);
        }
        return result;
    }
}

