/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generator;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.FunctionalConstraintsBlock;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.monitoring.generator.ComponentTimeDataConstraintsGenerator;
import org.eclipse.comma.monitoring.generator.FunctionalConstraintGenerator;
import org.eclipse.comma.monitoring.generator.InfrastructureGenerator;
import org.eclipse.comma.monitoring.generator.InterfaceDecisionGenerator;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.DocumentationGeneratorTask;
import org.eclipse.comma.project.generatortasks.MonitoringGeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.generatortasks.UMLGeneratorTask;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.project.project.ProjectPackage;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.UMLTask;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CmdLineContext;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ProjectGenerator
extends AbstractGenerator {
    @Inject
    protected IScopeProvider scopeProvider;
    protected OutputLocator outputLocator;
    protected Project project;
    protected Consumer<Task> processTaskConsumer;
    protected List<String> errors = new ArrayList<String>();

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        if (context instanceof CmdLineContext) {
            this.generateWithErrorReport(resource, fsa, context);
        }
    }

    public List<String> generateWithErrorReport(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext contex) {
        boolean _not;
        this.init(resource, fsa);
        this.runTasks();
        List<MonitoringTask> monitorTasks = ProjectUtility.getMonitorTasks(this.project);
        boolean _isEmpty = monitorTasks.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.generateJavaInfrastructure(monitorTasks, fsa);
        }
        this.createErrorFile(fsa, this.errors);
        System.gc();
        return this.errors;
    }

    public void init(Resource resource, final IFileSystemAccess2 fsa) {
        this.errors.clear();
        EObject _head = (EObject)IteratorExtensions.head((Iterator)resource.getAllContents());
        this.project = ((ProjectDescription)_head).getProject();
        this.processTaskConsumer = new Consumer<Task>(){

            @Override
            public void accept(Task task) {
                ProjectGenerator.this.errors.addAll(ProjectGenerator.this.processTask(task, fsa));
            }
        };
        this.setOutputLocator();
    }

    public void runTasks() {
        ProjectUtility.getMonitorTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getDocumentationTasks(this.project).forEach(this.processTaskConsumer);
        ProjectUtility.getUMLTasks(this.project).forEach(this.processTaskConsumer);
    }

    public void setOutputLocator() {
        OutputLocator _outputLocator;
        this.outputLocator = _outputLocator = new OutputLocator();
    }

    public void createErrorFile(IFileSystemAccess2 fsa, List<String> errors) {
        boolean _not;
        boolean _isEmpty = errors.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            for (String error : errors) {
                _builder.append(error);
                _builder.newLineIfNotEmpty();
            }
            fsa.generateFile("errorReport.txt", (CharSequence)_builder);
        }
    }

    protected List<String> _processTask(MonitoringTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        MonitoringGeneratorTask generatorTask = new MonitoringGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(UMLTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        UMLGeneratorTask generatorTask = new UMLGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    protected List<String> _processTask(DocumentationGenerationTask task, IFileSystemAccess2 fsa) {
        List<String> _xblockexpression = null;
        DocumentationGeneratorTask generatorTask = new DocumentationGeneratorTask(task, this.scopeProvider, this.outputLocator, fsa);
        _xblockexpression = generatorTask.startGeneration();
        return _xblockexpression;
    }

    public void generateJavaInfrastructure(List<MonitoringTask> monitorTasks, IFileSystemAccess2 fsa) {
        CommaFileSystemAccess javaFsa = new CommaFileSystemAccess("java/", fsa);
        List recordTypes = StateMachineUtilities.getRecordTypes((EObject)this.project, (IScopeProvider)this.scopeProvider);
        InfrastructureGenerator infrastructureGenerator = new InfrastructureGenerator((IFileSystemAccess)javaFsa, recordTypes);
        infrastructureGenerator.generateRecords();
        infrastructureGenerator.generateTraceReader();
        Functions.Function1<EObject, Interface> _function = new Functions.Function1<EObject, Interface>(){

            public Interface apply(EObject it) {
                return (Interface)it;
            }
        };
        List interfaces = ListExtensions.map((List)CommaUtilities.resolveProxy((EObject)this.project, (Iterable)this.scopeProvider.getScope((EObject)this.project, ProjectPackage.Literals.INTERFACE_REFERENCE__INTERFACE).getAllElements()), (Functions.Function1)_function);
        Functions.Function1<EObject, Component> _function_1 = new Functions.Function1<EObject, Component>(){

            public Component apply(EObject it) {
                return (Component)it;
            }
        };
        List components = ListExtensions.map((List)CommaUtilities.resolveProxy((EObject)this.project, (Iterable)this.scopeProvider.getScope((EObject)this.project, ProjectPackage.Literals.COMPONENT_REFERENCE__COMPONENT).getAllElements()), (Functions.Function1)_function_1);
        infrastructureGenerator.generateFactory(interfaces, components);
        boolean _isEmpty = recordTypes.isEmpty();
        boolean recordsPresent = !_isEmpty;
        for (Interface i : interfaces) {
            Signature signature = InterfaceUtilities.getSignature((Interface)i, (IScopeProvider)this.scopeProvider);
            InterfaceDecisionGenerator decisionClassGenerator = new InterfaceDecisionGenerator(signature, i, recordsPresent, (IFileSystemAccess)javaFsa);
            decisionClassGenerator.generateUtilityClass();
            decisionClassGenerator.generateConstraintClasses();
            decisionClassGenerator.generateDecisionClass();
        }
        FunctionalConstraintGenerator fcGenerator = new FunctionalConstraintGenerator(interfaces, recordsPresent, (IFileSystemAccess)javaFsa);
        for (Component c : components) {
            boolean _tripleNotEquals;
            FunctionalConstraintsBlock _functionalConstraintsBlock = c.getFunctionalConstraintsBlock();
            boolean bl = _tripleNotEquals = _functionalConstraintsBlock != null;
            if (_tripleNotEquals) {
                EList _functionalConstraints = c.getFunctionalConstraintsBlock().getFunctionalConstraints();
                for (FunctionalConstraint fc : _functionalConstraints) {
                    fcGenerator.generateUtilityClass(c, fc);
                    fcGenerator.generateConstraintClass(c, fc);
                }
            }
            ComponentTimeDataConstraintsGenerator tdGenerator = new ComponentTimeDataConstraintsGenerator(c, recordsPresent, (IFileSystemAccess)javaFsa);
            tdGenerator.generateConstraintClasses();
        }
        Functions.Function1<MonitoringTask, String> _function_2 = new Functions.Function1<MonitoringTask, String>(){

            public String apply(MonitoringTask it) {
                return it.getName();
            }
        };
        infrastructureGenerator.generateScenarioPlayer(ListExtensions.map(monitorTasks, (Functions.Function1)_function_2));
    }

    public List<String> processTask(Task task, IFileSystemAccess2 fsa) {
        if (task instanceof DocumentationGenerationTask) {
            return this._processTask((DocumentationGenerationTask)task, fsa);
        }
        if (task instanceof MonitoringTask) {
            return this._processTask((MonitoringTask)task, fsa);
        }
        if (task instanceof UMLTask) {
            return this._processTask((UMLTask)task, fsa);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task, fsa).toString());
    }
}

