/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.papyrus.uml.service.types.utils.InteractionConstraintUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintEditHelper
extends ElementEditHelper {
    public ConstraintEditHelper() {
        this.getDefaultContainmentFeatures().put(UMLPackage.eINSTANCE.getValueSpecification(), UMLPackage.eINSTANCE.getConstraint_Specification());
    }

    @Override
    protected ICommand getConfigureCommand(final ConfigureRequest req) {
        ConfigureElementCommand configureCommand = new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Constraint element = (Constraint)req.getElementToConfigure();
                ValueSpecification spec = ConstraintEditHelper.this.createSpecification();
                spec.setName("constraintSpec");
                element.setSpecification(spec);
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
        return CompositeCommand.compose((ICommand)configureCommand, (ICommand)super.getConfigureCommand(req));
    }

    protected ValueSpecification createSpecification() {
        return UMLFactory.eINSTANCE.createLiteralString();
    }

    protected ICommand getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return null;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (req.getSource() instanceof Constraint) {
            return null;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand getSetCommand(SetRequest req) {
        EStructuralFeature feature = req.getFeature();
        Object value = req.getValue();
        if (value != null) {
            EObject elementToEdit = req.getElementToEdit();
            if (UMLPackage.eINSTANCE.getInteractionConstraint_Minint() == feature) {
                Integer minintValue = InteractionConstraintUtil.getNonNegativeInteger((ValueSpecification)value);
                if (minintValue == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                InteractionConstraint element = (InteractionConstraint)elementToEdit;
                Integer maxintValue = InteractionConstraintUtil.getMaxintValue(element);
                if (maxintValue != null && maxintValue < minintValue) {
                    return UnexecutableCommand.INSTANCE;
                }
            } else if (UMLPackage.eINSTANCE.getInteractionConstraint_Maxint() == feature) {
                InteractionConstraint element = (InteractionConstraint)elementToEdit;
                Integer maxintValue = InteractionConstraintUtil.getNonNegativeInteger((ValueSpecification)value);
                if (maxintValue == null || maxintValue == 0) {
                    return UnexecutableCommand.INSTANCE;
                }
                Integer minintValue = InteractionConstraintUtil.getMinintValue(element);
                if (minintValue != null && maxintValue < minintValue) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        return super.getSetCommand(req);
    }
}

