/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.HTMLConvertor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseMetadata;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UseReportConverter
extends HTMLConvertor {
    static Comparator<Object> compare = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            if (o1 instanceof Type && o2 instanceof Type) {
                return this.compare(((Type)o1).desc, ((Type)o2).desc);
            }
            if (o1 instanceof IReferenceTypeDescriptor && o2 instanceof IReferenceTypeDescriptor) {
                return ((IReferenceTypeDescriptor)o1).getQualifiedName().compareTo(((IReferenceTypeDescriptor)o2).getQualifiedName());
            }
            if (o1 instanceof IMethodDescriptor && o2 instanceof IMethodDescriptor) {
                try {
                    return Signatures.getQualifiedMethodSignature((IMethodDescriptor)o1).compareTo(Signatures.getQualifiedMethodSignature((IMethodDescriptor)o2));
                }
                catch (CoreException coreException) {
                    return -1;
                }
            }
            if (o1 instanceof IFieldDescriptor && o2 instanceof IFieldDescriptor) {
                return Signatures.getQualifiedFieldSignature((IFieldDescriptor)o1).compareTo(Signatures.getQualifiedFieldSignature((IFieldDescriptor)o2));
            }
            if (o1 instanceof IComponentDescriptor && o2 instanceof IComponentDescriptor) {
                return ((IComponentDescriptor)o1).getId().compareTo(((IComponentDescriptor)o2).getId());
            }
            return -1;
        }
    };
    public static final int FRAGMENT_PERMISSIBLE = 5;
    public static final String DEFAULT_XSLT = "/references.xsl";
    public static final String NORMAL_REFS_COLOUR = "#FFFFFF";
    public static final String INTERNAL_REFS_COLOUR = "#F2C3C3";
    public static final String ILLEGAL_REFS_COLOUR = "#E0E0E0";
    public static final String REFERENCES_TABLE_HEADER_COLOUR = "#E0C040";
    static final String REF_STYLE;
    static final String REF_SCRIPT;
    private String xmlLocation = null;
    private String htmlLocation = null;
    private File reportsRoot = null;
    private File htmlIndex = null;
    private boolean hasmissing = false;
    private boolean useNotSearchedXml = false;
    SAXParser parser = null;
    private UseMetadata metadata = null;
    private int filteredCount = -1;
    Pattern[] topatterns = null;
    Pattern[] frompatterns = null;

    static {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<style type=\"text/css\">\n");
        buffer.append("\t.main {\t\tfont-family:Arial, Helvetica, sans-serif;\n\t}\n");
        buffer.append("\t.main h3 {\n\t\tfont-family:Arial, Helvetica, sans-serif;\n\t\t\background-color:#FFFFFF;\n\t\tfont-size:14px;\n\t\tmargin:0.1em;\n\t}\n");
        buffer.append("\t.main h4 {\n\t\tbackground-color:#CCCCCC;\n\t\tmargin:0.15em;\n\t}\n");
        buffer.append("\ta.typeslnk {\n\t\tfont-family:Arial, Helvetica, sans-serif;\n\t\ttext-decoration:none;\n\t\tmargin-left:0.25em;\n\t}\n");
        buffer.append("\ta.typeslnk:hover {\n\t\ttext-decoration:underline;\n\t}\n");
        buffer.append("\ta.kindslnk {\n\t\tfont-family:Arial, Helvetica, sans-serif;\n\t\ttext-decoration:none;\n\t\tmargin-left:0.25em;\n\t}\n");
        buffer.append("\t.types {\n\t\tdisplay:none;\n\t\tmargin-bottom:0.25em;\n\t\tmargin-top:0.25em;\n\t\tmargin-right:0.25em;\n\t\tmargin-left:0.75em;\n\t}\n");
        buffer.append("</style>\n");
        REF_STYLE = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("<script type=\"text/javascript\">\n\tfunction expand(location) {\n\t\tif(document.getElementById) {\n\t\t\tvar childhtml = location.firstChild;\n\t\t\tif(!childhtml.innerHTML) {\n\t\t\t\tchildhtml = childhtml.nextSibling;\n\t\t\t}\n\t\t\tchildhtml.innerHTML = childhtml.innerHTML == '[+] ' ? '[-] ' : '[+] ';\n\t\t\tvar parent = location.parentNode;\n\t\t\tchildhtml = parent.nextSibling.style ? parent.nextSibling : parent.nextSibling.nextSibling;\n\t\t\tchildhtml.style.display = childhtml.style.display == 'block' ? 'none' : 'block';\n\t\t}\n\t}\n</script>\n");
        buffer.append("<noscript>\n\t<style type=\"text/css\">\n\t\t.types {display:block;}\n\t\t.kinds{display:block;}\n\t</style>\n</noscript>\n");
        REF_SCRIPT = buffer.toString();
    }

    public UseReportConverter(String htmlroot, String xmlroot, String[] topatterns, String[] frompatterns) {
        int n;
        int n2;
        String[] stringArray;
        ArrayList<Pattern> pats;
        this.xmlLocation = xmlroot;
        this.htmlLocation = htmlroot;
        if (topatterns != null) {
            pats = new ArrayList<Pattern>(topatterns.length);
            stringArray = topatterns;
            n2 = topatterns.length;
            n = 0;
            while (n < n2) {
                block10: {
                    String topattern = stringArray[n];
                    try {
                        pats.add(Pattern.compile(topattern));
                    }
                    catch (PatternSyntaxException pse) {
                        if (!ApiPlugin.DEBUG_USE_REPORT_CONVERTER) break block10;
                        System.out.println(NLS.bind((String)SearchMessages.UseReportConverter_filter_pattern_not_valid, (Object)topattern));
                        System.out.println(pse.getMessage());
                    }
                }
                ++n;
            }
            if (!pats.isEmpty()) {
                this.topatterns = pats.toArray(new Pattern[pats.size()]);
            }
        }
        if (frompatterns != null) {
            pats = new ArrayList(frompatterns.length);
            stringArray = frompatterns;
            n2 = frompatterns.length;
            n = 0;
            while (n < n2) {
                block11: {
                    String frompattern = stringArray[n];
                    try {
                        pats.add(Pattern.compile(frompattern));
                    }
                    catch (PatternSyntaxException pse) {
                        if (!ApiPlugin.DEBUG_USE_REPORT_CONVERTER) break block11;
                        System.out.println(NLS.bind((String)SearchMessages.UseReportConverter_filter_pattern_not_valid, (Object)frompattern));
                        System.out.println(pse.getMessage());
                    }
                }
                ++n;
            }
            if (!pats.isEmpty()) {
                this.frompatterns = pats.toArray(new Pattern[pats.size()]);
            }
        }
    }

    protected String getHtmlLocation() {
        return this.htmlLocation;
    }

    protected String getXmlLocation() {
        return this.xmlLocation;
    }

    protected File getReportsRoot() {
        if (this.reportsRoot == null) {
            this.reportsRoot = new File(this.getXmlLocation());
        }
        return this.reportsRoot;
    }

    protected boolean hasMissing() {
        return this.hasmissing;
    }

    public void convert(String xslt, IProgressMonitor monitor) throws Exception {
        if (this.getHtmlLocation() == null) {
            return;
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.UseReportConverter_preparing_report_metadata, (int)11);
        try {
            localmonitor.setTaskName(SearchMessages.UseReportConverter_preparing_html_root);
            localmonitor.split(1);
            File htmlRoot = new File(this.getHtmlLocation());
            if (!htmlRoot.exists()) {
                if (!htmlRoot.mkdirs()) {
                    throw new Exception(NLS.bind((String)SearchMessages.could_not_create_file, (Object)this.getHtmlLocation()));
                }
            } else {
                htmlRoot.mkdirs();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_preparing_xml_root);
            localmonitor.split(1);
            if (this.getXmlLocation() == null) {
                throw new Exception(SearchMessages.missing_xml_files_location);
            }
            File lreportsRoot = this.getReportsRoot();
            if (!lreportsRoot.exists() || !lreportsRoot.isDirectory()) {
                throw new Exception(NLS.bind((String)SearchMessages.invalid_directory_name, (Object)this.getXmlLocation()));
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_preparing_xslt_file);
            localmonitor.split(1);
            File xsltFile = null;
            if (!(xslt == null || (xsltFile = new File(xslt)).exists() && xsltFile.isFile())) {
                throw new Exception(SearchMessages.UseReportConverter_xslt_file_not_valid);
            }
            long start = 0L;
            if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_writing_not_searched);
            this.hasmissing = this.writeMissingBundlesPage(htmlRoot);
            this.writeNotSearchedPage(htmlRoot);
            localmonitor.split(1);
            if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                System.out.println("Parsing use scan...");
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_parsing_use_scan);
            List<?> result = this.parse((IProgressMonitor)localmonitor.split(5));
            localmonitor.split(1);
            if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                System.out.println("Sorting reports and writing index...");
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_writing_root_index);
            this.writeIndexPage(result);
            localmonitor.split(1);
            if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
            }
            this.writeMetaPage(htmlRoot);
        }
        finally {
            if (localmonitor != null) {
                localmonitor.done();
            }
        }
    }

    protected List<?> parse(IProgressMonitor monitor) throws Exception {
        UseScanParser lparser = new UseScanParser();
        Visitor convertor = new Visitor();
        lparser.parse(this.getXmlLocation(), monitor, convertor);
        return convertor.reports;
    }

    SAXParser getParser() throws Exception {
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                this.parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                throw new Exception(SearchMessages.UseReportConverter_pce_error_getting_parser, pce);
            }
            catch (SAXException se) {
                throw new Exception(SearchMessages.UseReportConverter_se_error_parser_handle, se);
            }
            if (this.parser == null) {
                throw new Exception(SearchMessages.could_not_create_sax_parser);
            }
        }
        return this.parser;
    }

    protected String composeName(String id, String version) {
        String versionName = version;
        if (version == null) {
            versionName = Version.emptyVersion.toString();
        }
        StringBuffer buffer = new StringBuffer(3 + id.length() + versionName.length());
        buffer.append(id).append(" (").append(versionName).append(")");
        return buffer.toString();
    }

    public File getReportIndex() {
        return this.htmlIndex;
    }

    protected void setReportIndex(File index) {
        this.htmlIndex = index;
    }

    protected void applyXSLT(File xsltFile, File xmlfile, File htmloutput) throws TransformerException, Exception {
        StreamSource xslt = null;
        if (xsltFile != null) {
            xslt = new StreamSource(xsltFile);
        } else {
            InputStream defaultXsltInputStream = UseReportConverter.class.getResourceAsStream(DEFAULT_XSLT);
            if (defaultXsltInputStream != null) {
                xslt = new StreamSource(new BufferedInputStream(defaultXsltInputStream));
            }
        }
        if (xslt == null) {
            throw new Exception(SearchMessages.UseReportConverter_no_xstl_specified);
        }
        this.applyXSLT(xslt, xmlfile, htmloutput);
    }

    protected void applyXSLT(Source xslt, File xmlfile, File htmlfile) throws TransformerException {
        StreamSource xml = new StreamSource(xmlfile);
        StreamResult html = new StreamResult(htmlfile);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer former = factory.newTransformer(xslt);
        former.transform(xml, html);
    }

    protected void tranformXml(File[] xmlfiles, File xsltFile) {
        File html = null;
        File[] fileArray = xmlfiles;
        int n = xmlfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlfile = fileArray[n2];
            try {
                File htmlroot = new File(this.getHtmlLocation(), this.getHTMLFileLocation(xmlfile));
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                html = new File(this.getNameFromXMLFilename(xmlfile));
                this.applyXSLT(xsltFile, xmlfile, html);
            }
            catch (TransformerException transformerException) {
            }
            catch (Exception e) {
                ApiPlugin.log(e);
            }
            ++n2;
        }
    }

    protected String getHTMLFileLocation(File xmlfile) {
        Path report;
        File reportRoot = new File(this.getXmlLocation());
        Path xml = new Path(xmlfile.getPath());
        int segments = xml.matchingFirstSegments((IPath)(report = new Path(reportRoot.getPath())));
        if (segments > 0) {
            if (xml.getDevice() != null) {
                xml = xml.setDevice(null);
            }
            IPath html = xml.removeFirstSegments(segments);
            return html.removeLastSegments(1).toOSString();
        }
        return null;
    }

    protected String getNameFromXMLFilename(File xmlFile) {
        String fileName = xmlFile.getAbsolutePath();
        int index = fileName.lastIndexOf(46);
        StringBuffer buffer = new StringBuffer();
        buffer.append(fileName.substring(this.getReportsRoot().getAbsolutePath().length(), index)).append(".html");
        File htmlFile = new File(this.getHtmlLocation(), String.valueOf(buffer));
        return htmlFile.getAbsolutePath();
    }

    protected String[] getMissingBundles(File missingfile) throws Exception {
        MissingHandler handler;
        block14: {
            handler = new MissingHandler();
            FileInputStream inputFile = null;
            try {
                try {
                    inputFile = new FileInputStream(missingfile.getAbsolutePath());
                    this.getParser().parse((InputStream)inputFile, (DefaultHandler)handler);
                }
                catch (IOException ioe) {
                    ApiPlugin.log(ioe);
                    if (inputFile != null) {
                        try {
                            ((InputStream)inputFile).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (inputFile != null) {
                    try {
                        ((InputStream)inputFile).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputFile != null) {
                try {
                    ((InputStream)inputFile).close();
                }
                catch (IOException iOException) {}
            }
        }
        return handler.missing.toArray(new String[handler.missing.size()]);
    }

    protected String getMissingBundlesHeader() {
        return SearchMessages.UseReportConverter_reported_missing_bundles;
    }

    void writeMetaPage(File htmlroot) throws Exception {
        File meta = null;
        try (PrintWriter writer = null;){
            File file = new File(this.getReportsRoot(), "meta.xml");
            if (!file.exists()) {
                return;
            }
            try {
                String filename = "meta";
                meta = new File(htmlroot, String.valueOf(filename) + ".html");
                if (!meta.exists()) {
                    meta.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append("<title>").append(SearchMessages.UseReportConverter_use_scan_info).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(SearchMessages.UseReportConverter_use_scan_info).append("</h3>\n");
                this.writeMetadataSummary(buffer);
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(meta), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)meta.getAbsolutePath()));
            }
        }
    }

    protected boolean writeMissingBundlesPage(File htmlroot) throws Exception {
        boolean hasMissing = false;
        File missing = null;
        try (PrintWriter writer = null;){
            try {
                File file;
                String filename = "missing";
                missing = new File(htmlroot, String.valueOf(filename) + ".html");
                if (!missing.exists()) {
                    missing.createNewFile();
                }
                if (!(file = new File(this.getReportsRoot(), "not_searched.xml")).exists()) {
                    file = new File(this.getReportsRoot() + File.separator + "xml", "not_searched.xml");
                }
                TreeSet<Object> sorted = new TreeSet<Object>(Util.componentsorter);
                if (file.exists()) {
                    String[] missingBundles = this.getMissingBundles(file);
                    hasMissing = missingBundles.length > 0;
                    String[] stringArray = missingBundles;
                    int n = missingBundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        sorted.add(string);
                        ++n2;
                    }
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append("<title>").append(SearchMessages.UseReportConverter_missing_required).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(SearchMessages.UseReportConverter_missing_required).append("</h3>\n");
                if (sorted.isEmpty()) {
                    buffer.append(SearchMessages.UseReportConverter_no_required_missing).append("<br>");
                } else {
                    buffer.append("<p>").append(this.getMissingBundlesHeader()).append("</p>\n");
                    buffer.append("<table border=\"1\" width=\"50%\">\n");
                    buffer.append("<tr>\n").append("<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"36%\">").append("<b>").append(SearchMessages.UseReportConverter_required_bundles).append("</b>").append("</td>\n").append("</tr>\n");
                }
                for (String string : sorted) {
                    buffer.append("<tr>\n").append("<td>").append(string).append("</td>\n").append("</tr>\n");
                }
                buffer.append("</table>\n");
                buffer.append("<br>").append("<a href=\"not_searched.html\">").append(SearchMessages.UseReportConverter_back_to_not_searched).append("</a>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(missing), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)missing.getAbsolutePath()));
            }
        }
        return hasMissing;
    }

    void writeNotSearchedPage(File htmlroot) throws Exception {
        File originhtml = null;
        try (InputStream defaultXsltInputStream = null;){
            try {
                File xml;
                String filename = "not_searched";
                originhtml = new File(htmlroot, String.valueOf(filename) + ".html");
                if (!originhtml.exists()) {
                    originhtml.createNewFile();
                }
                if (!(xml = new File(this.getReportsRoot(), String.valueOf(filename) + ".xml")).exists()) {
                    xml = new File(this.getReportsRoot() + File.separator + "xml", String.valueOf(filename) + ".xml");
                }
                defaultXsltInputStream = UseReportConverter.class.getResourceAsStream(this.getNotSearchedXSLPath());
                StreamSource xslt = null;
                if (defaultXsltInputStream != null) {
                    xslt = new StreamSource(new BufferedInputStream(defaultXsltInputStream));
                }
                if (xslt == null) {
                    throw new Exception(SearchMessages.UseReportConverter_no_xstl_specified);
                }
                if (xml.exists()) {
                    try {
                        this.applyXSLT(xslt, xml, originhtml);
                    }
                    catch (TransformerException transformerException) {
                        this.useNotSearchedXml = true;
                        ApiPlugin.logErrorMessage(SearchMessages.UseReportConverter_te_applying_xslt_skipped);
                    }
                }
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
            catch (TransformerException te) {
                throw new Exception(SearchMessages.UseReportConverter_te_applying_xslt_skipped, te);
            }
            catch (CoreException coreException) {
                throw new Exception(NLS.bind((String)SearchMessages.UseReportConverter_coreexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
        }
    }

    String getNotSearchedXSLPath() {
        return "/notsearched.xsl";
    }

    protected void writeReferencedMemberPage(Report report, List<Type> referees) throws Exception {
        File originhtml = null;
        try (PrintWriter writer = null;){
            try {
                File htmlroot = new File(this.getHtmlLocation(), report.name);
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                if (!(originhtml = new File(htmlroot, "index.html")).exists()) {
                    originhtml.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append(REF_STYLE);
                buffer.append(REF_SCRIPT);
                buffer.append("<title>").append(this.getReferencedTypeTitle(report.name)).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getReferencedTypeTitle(report.name)).append("</h3>\n");
                buffer.append("<p>").append(NLS.bind((String)SearchMessages.UseReportConverter_list_of_all_refing_bundles, (Object[])new String[]{"<a href=\"#bundles\">", "</a>"})).append("</p>\n");
                String additional = this.getAdditionalReferencedTypeInformation();
                if (additional != null) {
                    buffer.append(additional);
                }
                buffer.append(this.getReferencesTableHeader(SearchMessages.UseReportConverter_references, SearchMessages.UseReportConverter_referenced_type, false));
                CountGroup counts = null;
                String link = null;
                File typefile = null;
                TreeMap<IMemberDescriptor, Member> map = null;
                Type type = null;
                for (Map.Entry<Type, TreeMap<IMemberDescriptor, Member>> entry : report.children.entrySet()) {
                    map = entry.getValue();
                    type = entry.getKey();
                    counts = type.counts;
                    String fqname = Signatures.getQualifiedTypeSignature((IReferenceTypeDescriptor)type.desc);
                    typefile = new File(htmlroot, String.valueOf(fqname) + ".html");
                    if (!typefile.exists()) {
                        typefile.createNewFile();
                    }
                    link = this.extractLinkFrom(htmlroot, typefile.getAbsolutePath());
                    buffer.append(this.getReferenceTableEntry(counts, link, fqname, false));
                    this.writeTypePage(map, type, typefile, fqname);
                }
                buffer.append("</table>\n");
                buffer.append("<br>");
                buffer.append("<h4>").append(SearchMessages.UseReportConverter_referencing_bundles).append("</h4>\n");
                buffer.append("<p>").append(NLS.bind((String)SearchMessages.UseReportConverter_following_bundles_have_refs, (Object)report.name)).append("</p>\n");
                buffer.append("<a name=\"bundles\">").append("</a>\n");
                buffer.append("<table border=\"1\" width=\"80%\">\n");
                buffer.append("<tr>\n");
                buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"50%\">").append("<b>").append(SearchMessages.UseReportConverter_bundle).append("</b>").append("</td>\n");
                buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"20%\" align=\"center\">").append("<b>").append(SearchMessages.UseReportConverter_version).append("</b>").append("</td>\n");
                buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"10%\" align=\"center\">").append("<b>").append(SearchMessages.UseReportConverter_reference_count).append("</b>").append("</td>\n");
                buffer.append("</tr>\n");
                Collections.sort(referees, compare);
                IComponentDescriptor comp = null;
                int i = 0;
                while (i < referees.size()) {
                    type = referees.get(i);
                    comp = (IComponentDescriptor)type.desc;
                    buffer.append("<tr bgcolor=\"").append(this.getRowColour(counts)).append("\">\n");
                    buffer.append("\t").append("<td>").append("<b>").append(comp.getId()).append("</b>").append("</td>\n");
                    buffer.append("\t").append("<td>").append(comp.getVersion()).append("</td>\n");
                    buffer.append("\t<td align=\"center\">").append(type.counts.getTotalRefCount()).append("</td>\n");
                    buffer.append("</tr>\n");
                    ++i;
                }
                buffer.append("</table>\n");
                buffer.append("<p>").append("<a href=\"../index.html\">").append(SearchMessages.UseReportConverter_back_to_bundle_index).append("</a>\n").append("</p>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(originhtml), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
        }
    }

    String getRowColour(CountGroup counts) {
        if (counts.getTotalInternalRefCount() > 0) {
            return INTERNAL_REFS_COLOUR;
        }
        if (counts.getTotalIllegalRefCount() > 0) {
            return ILLEGAL_REFS_COLOUR;
        }
        return NORMAL_REFS_COLOUR;
    }

    protected String getAdditionalReferencedTypeInformation() {
        return null;
    }

    protected String getReferencedTypeTitle(String bundle) {
        return NLS.bind((String)SearchMessages.UseReportConverter_types_used_in, (Object)bundle);
    }

    void writeTypePage(Map<IMemberDescriptor, Member> map, Type type, File typefile, String typename) throws Exception {
        try (PrintWriter writer = null;){
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append(REF_STYLE);
                buffer.append(REF_SCRIPT);
                buffer.append("<title>").append(this.getTypeTitle(typename)).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getTypeTitle(typename)).append("</h3>\n");
                buffer.append(this.getTypeCountSummary(typename, type.counts, map.size()));
                buffer.append("<h4>").append(this.getTypeDetailsHeader()).append("</h4>\n");
                buffer.append("<p>").append(this.getTypeDetails()).append("</p>\n");
                buffer.append("<div align=\"left\" class=\"main\">");
                buffer.append("<table border=\"1\" width=\"80%\">\n");
                buffer.append("<tr>\n");
                buffer.append("<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\">").append("<b>").append(SearchMessages.UseReportConverter_member).append("</b></td>\n");
                buffer.append("</tr>\n");
                IElementDescriptor desc = null;
                for (Map.Entry<IMemberDescriptor, Member> entry : map.entrySet()) {
                    desc = entry.getKey();
                    buffer.append("<tr>\n");
                    buffer.append("<td align=\"left\">\n");
                    buffer.append("<b>");
                    buffer.append("<a href=\"javascript:void(0)\" class=\"typeslnk\" onclick=\"expand(this)\" title=\"");
                    buffer.append(this.getDisplayName(desc, true, true)).append("\">\n");
                    buffer.append("<span>[+] </span>").append(this.getDisplayName(desc, true, false)).append("\n");
                    buffer.append("</a>\n").append("</b>");
                    buffer.append("<div colspan=\"6\" class=\"types\">\n");
                    buffer.append(this.getReferencesTable(entry.getValue())).append("\n");
                    buffer.append("</div>\n");
                    buffer.append("</tr>\n");
                }
                buffer.append("</table>\n");
                buffer.append("</div>\n");
                buffer.append("<p>").append("<a href=\"index.html\">").append(SearchMessages.UseReportConverter_back_to_bundle_index).append("</a>\n").append("</p>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(typefile), "UTF-8"));
                writer.print(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)typefile.getAbsolutePath()));
            }
        }
    }

    protected String getTypeDetailsHeader() {
        return SearchMessages.UseReportConverter_reference_details;
    }

    protected String getTypeDetails() {
        return SearchMessages.UseReportConverter_click_an_entry_to_see_details;
    }

    protected String getTypeTitle(String typename) {
        return NLS.bind((String)SearchMessages.UseReportConverter_usage_details, (Object)Signature.getSimpleName((String)typename));
    }

    String getReferencesTable(Member member) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"6\">\n");
        List<Reference> refs = null;
        Reference ref2 = null;
        for (Map.Entry<String, List<Reference>> entry : member.children.entrySet()) {
            buffer.append("<tr align=\"left\"> \n");
            buffer.append("<td colspan=\"3\" bgcolor=\"#CCCCCC\">").append("<b>").append(entry.getKey()).append("</b>").append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\">");
            buffer.append("<td align=\"left\" width=\"84%\">").append("<b>").append(SearchMessages.UseReportConverter_reference_location).append("</b>").append("</td>\n");
            buffer.append("<td align=\"center\" width=\"8%\">").append("<b>").append(SearchMessages.UseReportConverter_line_number).append("</b>").append("</td>\n");
            buffer.append("<td align=\"center\" width=\"8%\">").append("<b>").append(SearchMessages.UseReportConverter_reference_kind).append("</b>").append("</td>\n");
            buffer.append("</tr>\n");
            refs = entry.getValue();
            Collections.sort(refs, compare);
            for (Reference ref2 : refs) {
                try {
                    String name = this.getDisplayName(ref2.desc, false, true);
                    buffer.append("<tr>\n");
                    buffer.append("<td>").append(name).append("</td>\n");
                    buffer.append("<td align=\"center\">").append(ref2.line).append("</td>\n");
                    buffer.append("<td align=\"center\">").append("<span class=\"typeslnk\"");
                    if (ref2.message != null) {
                        buffer.append(" title=\"").append(ref2.message).append("\"");
                    }
                    buffer.append(">").append(VisibilityModifiers.getVisibilityName(ref2.vis)).append("</span>");
                    buffer.append("</td>\n").append("</tr>\n");
                }
                catch (CoreException ce) {
                    ApiPlugin.log(ce);
                }
            }
        }
        buffer.append("</table>\n");
        return buffer.toString();
    }

    String getDisplayName(IElementDescriptor desc, boolean qualifiedparams, boolean qualified) throws CoreException {
        String displayname = null;
        switch (desc.getElementType()) {
            case 2: {
                IReferenceTypeDescriptor rtype = (IReferenceTypeDescriptor)desc;
                displayname = Signatures.getTypeSignature(rtype.getSignature(), rtype.getGenericSignature(), qualified);
                break;
            }
            case 6: {
                IMethodDescriptor method = (IMethodDescriptor)desc;
                if (qualified) {
                    displayname = Signatures.getQualifiedMethodSignature(method, qualifiedparams, qualifiedparams);
                    break;
                }
                displayname = Signatures.getMethodSignature(method, qualifiedparams);
                break;
            }
            case 5: {
                IFieldDescriptor field = (IFieldDescriptor)desc;
                if (qualified) {
                    displayname = Signatures.getQualifiedFieldSignature(field);
                    break;
                }
                displayname = field.getName();
                break;
            }
        }
        return displayname;
    }

    String extractLinkFrom(File root, String fileName) {
        StringBuffer buffer = new StringBuffer();
        String substring = fileName.substring(root.getAbsolutePath().length()).replace('\\', '/');
        buffer.append('.');
        if (substring.charAt(0) != '/') {
            buffer.append('/');
        }
        buffer.append(substring);
        return String.valueOf(buffer);
    }

    protected String getIndexTitle() {
        return SearchMessages.UseReportConverter_bundle_usage_information;
    }

    protected void writeIndexPage(List<?> scanResult) throws Exception {
        Collections.sort(scanResult, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Report)o1).name.compareTo(((Report)o2).name);
            }
        });
        try (PrintWriter writer = null;){
            try {
                File reportIndex = new File(this.getHtmlLocation(), "index.html");
                if (!reportIndex.exists()) {
                    reportIndex.createNewFile();
                }
                this.setReportIndex(reportIndex);
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                this.writeMetadataHeaders(buffer);
                buffer.append("<title>").append(this.getIndexTitle()).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getIndexTitle()).append("</h3>\n");
                try {
                    this.getMetadata();
                    this.writeMetadataSummary(buffer);
                    this.getFilteredCount();
                    this.writeFilterCount(buffer);
                }
                catch (Exception exception) {}
                buffer.append("<h4>").append(SearchMessages.UseReportConvertor_additional_infos_section).append("</h4>\n");
                if (this.hasMissing()) {
                    buffer.append("<p>");
                    buffer.append(NLS.bind((String)SearchMessages.UseReportConverter_missing_bundles_prevented_scan, (Object[])new String[]{" <a href=\"./missing.html\">", "</a>"}));
                    buffer.append("</p>\n");
                }
                buffer.append("<p>");
                buffer.append(NLS.bind((String)SearchMessages.UseReportConverter_bundles_that_were_not_searched, (Object[])new String[]{!this.useNotSearchedXml ? "<a href=\"./not_searched.html\">" : "<a href=\"../xml/not_searched.xml\">", "</a></p>\n"}));
                String additional = this.getAdditionalIndexInfo(scanResult.size() > 0);
                if (additional != null) {
                    buffer.append(additional);
                }
                if (scanResult.size() > 0) {
                    buffer.append("<p>").append(SearchMessages.UseReportConverter_inlined_description).append("</p>\n");
                    buffer.append(this.getColourLegend());
                    buffer.append(this.getReferencesTableHeader(SearchMessages.UseReportConverter_references, SearchMessages.UseReportConverter_bundle, true));
                    if (scanResult.size() > 0) {
                        File refereehtml = null;
                        String link = null;
                        for (Object obj : scanResult) {
                            if (!(obj instanceof Report)) continue;
                            Report report = (Report)obj;
                            refereehtml = new File(this.getReportsRoot(), String.valueOf(report.name) + File.separator + "index.html");
                            link = this.extractLinkFrom(this.getReportsRoot(), refereehtml.getAbsolutePath());
                            buffer.append(this.getReferenceTableEntry(report.counts, link, report.name, true));
                        }
                        buffer.append("</table>\n");
                    }
                } else {
                    buffer.append(this.getNoReportsInformation());
                }
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                buffer.append("</body>\n").append("</html>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportIndex), "UTF-8"));
                writer.print(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)this.getReportIndex().getAbsolutePath()));
            }
        }
    }

    protected String getColourLegend() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p>");
        buffer.append("<table width=\"20%\" border=\"1\">");
        buffer.append("<tr>\n");
        buffer.append("<td width=\"25px\" bgcolor=\"").append(INTERNAL_REFS_COLOUR).append("\">\n").append("&nbsp;").append("</td>\n");
        buffer.append("<td width=\"82%\">").append(SearchMessages.UseReportConverter_marks_internal_references).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("<tr>\n");
        buffer.append("<td width=\"25px\" bgcolor=\"").append(ILLEGAL_REFS_COLOUR).append("\">\n").append("&nbsp;").append("</td>\n");
        buffer.append("<td width=\"82%\">").append(SearchMessages.UseReportConverter_marks_illegal_use_references).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("</table>\n");
        buffer.append("</p>\n");
        return buffer.toString();
    }

    protected String getNoReportsInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p>").append("<br>").append(SearchMessages.UseReportConverter_no_reported_usage).append("</p>\n");
        return buffer.toString();
    }

    void writeMetadataHeaders(StringBuffer buffer) throws Exception {
        this.writeMetaTag(buffer, "description", SearchMessages.UseReportConverter_root_index_description);
    }

    void writeMetadataSummary(StringBuffer buffer) throws Exception {
        buffer.append("<h4>").append(SearchMessages.UseReportConverter_scan_details).append("</h4>\n");
        if (this.metadata != null) {
            String pattern;
            int n;
            int n2;
            Object[] objectArray;
            buffer.append("<table border=\"0px\" title=\"").append(SearchMessages.UseReportConverter_scan_details).append("\"width=\"50%\">");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_scan_date).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getRunAtDate()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_description).append("</td>\n");
            String desc = this.metadata.getDescription();
            buffer.append(UseReportConverter.openTD(36)).append(desc != null ? desc : SearchMessages.UseReportConverter_none).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_includes_API_refs).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.includesAPI() ? SearchMessages.UseReportConverter_includes_true : SearchMessages.UseReportConverter_includes_false).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_includes_internal_refs).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.includesInternal() ? SearchMessages.UseReportConverter_includes_true : SearchMessages.UseReportConverter_includes_false).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_includes_illegal_use).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.includesIllegalUse() ? SearchMessages.UseReportConverter_includes_true : SearchMessages.UseReportConverter_includes_false).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_baseline_loc).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(TextProcessor.process((String)this.metadata.getBaselineLocation())).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_scope_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getScopePattern()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_reference_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getReferencePattern()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_report_location).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(TextProcessor.process((String)this.metadata.getReportLocation())).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_api_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            String[] patterns = this.metadata.getApiPatterns();
            if (patterns != null) {
                objectArray = patterns;
                n2 = patterns.length;
                n = 0;
                while (n < n2) {
                    pattern = objectArray[n];
                    buffer.append(pattern).append("<br>");
                    ++n;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_internal_patterns).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            patterns = this.metadata.getInternalPatterns();
            if (patterns != null) {
                objectArray = patterns;
                n2 = patterns.length;
                n = 0;
                while (n < n2) {
                    pattern = objectArray[n];
                    buffer.append(pattern).append("<br>");
                    ++n;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_archive_patterns).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            patterns = this.metadata.getArchivePatterns();
            if (patterns != null) {
                objectArray = patterns;
                n2 = patterns.length;
                n = 0;
                while (n < n2) {
                    pattern = objectArray[n];
                    buffer.append(pattern).append("<br>");
                    ++n;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_filter_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            if (this.frompatterns != null) {
                objectArray = this.frompatterns;
                n2 = this.frompatterns.length;
                n = 0;
                while (n < n2) {
                    Object frompattern = objectArray[n];
                    buffer.append(((Pattern)frompattern).pattern()).append("<br>");
                    ++n;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_to_filter_patterns).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            if (this.topatterns != null) {
                objectArray = this.topatterns;
                n2 = this.topatterns.length;
                n = 0;
                while (n < n2) {
                    Object topattern = objectArray[n];
                    buffer.append(((Pattern)topattern).pattern()).append("<br>");
                    ++n;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_additional_filters).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            if (this.metadata.getAdditionalfilters() != null && !this.metadata.getAdditionalfilters().isEmpty()) {
                buffer.append(TextProcessor.process((String)this.metadata.getAdditionalfilters()));
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("</table>\n");
        } else {
            buffer.append("<p>").append(SearchMessages.UseReportConverter_no_additional_scan_info).append("</p>\n");
        }
    }

    void writeFilterCount(StringBuffer buffer) throws Exception {
        boolean isAdditionFilterProvided;
        boolean bl = isAdditionFilterProvided = this.metadata.getAdditionalfilters() != null && !this.metadata.getAdditionalfilters().isEmpty();
        if (this.filteredCount != -1 && isAdditionFilterProvided) {
            buffer.append("<h4>").append(SearchMessages.UseReportConverter_filter_information).append("</h4>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_number_filtered).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.filteredCount).append("</td>\n");
            buffer.append("</tr>\n");
        }
    }

    IMetadata getMetadata() throws Exception {
        if (this.metadata == null) {
            File xml = null;
            try {
                xml = new File(this.getReportsRoot(), "meta.xml");
                if (!xml.exists()) {
                    xml = new File(this.getReportsRoot() + File.separator + "xml", "meta.xml");
                }
                if (xml.exists()) {
                    String xmlstr = Util.getFileContentAsString(xml);
                    Element doc = Util.parseDocument(xmlstr.trim());
                    this.metadata = new UseMetadata();
                    Element element = null;
                    String value = null;
                    String name = null;
                    NodeList nodes = doc.getElementsByTagName("*");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        element = (Element)nodes.item(i);
                        value = element.getAttribute("value");
                        name = element.getNodeName();
                        if ("flags".equals(name)) {
                            try {
                                this.metadata.setSearchflags(Integer.parseInt(value));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if ("runatdate".equals(name)) {
                            this.metadata.setRunAtDate(value);
                        } else if ("description".equals(name)) {
                            this.metadata.setDescription(value);
                        } else if ("baselinelocation".equals(name)) {
                            this.metadata.setBaselineLocation(value);
                        } else if ("reportlocation".equals(name)) {
                            this.metadata.setReportLocation(value);
                        } else if ("scopepattern".equals(name)) {
                            this.metadata.setScopePattern(value);
                        } else if ("referencepattern".equals(name)) {
                            this.metadata.setReferencePattern(value);
                        } else if ("apipatterns".equals(name)) {
                            this.metadata.setApiPatterns(this.readPatterns(element));
                        } else if ("internalpatterns".equals(name)) {
                            this.metadata.setInternalPatterns(this.readPatterns(element));
                        } else if ("archivepatterns".equals(name)) {
                            this.metadata.setArchivePatterns(this.readPatterns(element));
                        } else if ("additionalfilters".equals(name)) {
                            this.metadata.setAdditionalfilters(value);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {
                throw new Exception(NLS.bind((String)SearchMessages.UseReportConverter_core_exep_reading_metadata, (Object)xml.getAbsolutePath()));
            }
        }
        return this.metadata;
    }

    int getFilteredCount() throws Exception {
        if (this.filteredCount == -1) {
            File xml = null;
            try {
                xml = new File(this.getReportsRoot(), "counts.xml");
                if (!xml.exists()) {
                    xml = new File(this.getReportsRoot() + File.separator + "xml", "meta.xml");
                }
                if (xml.exists()) {
                    String xmlstr = Util.getFileContentAsString(xml);
                    Element doc = Util.parseDocument(xmlstr.trim());
                    NamedNodeMap nodes = doc.getAttributes();
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Node element = nodes.item(i);
                        String value = element.getNodeValue();
                        String name = element.getNodeName();
                        if (name.equals("filtered")) {
                            this.filteredCount = Integer.parseInt(value);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {
                throw new Exception(NLS.bind((String)SearchMessages.UseReportConverter_core_exep_reading_metadata, (Object)xml.getAbsolutePath()));
            }
        }
        return this.filteredCount;
    }

    private String[] readPatterns(Element element) {
        String[] pats = null;
        NodeList patterns = element.getElementsByTagName("pattern");
        int length = patterns.getLength();
        if (length > 0) {
            pats = new String[length];
            int j = 0;
            while (j < length) {
                pats[j] = ((Element)patterns.item(j)).getAttribute("value");
                ++j;
            }
        }
        return pats;
    }

    void writeMetaTag(StringBuffer buffer, String name, String content) {
        buffer.append("<meta name=\"").append(name).append("\" content=\"").append(content).append("\">");
    }

    String getReferencesTableHeader(String sectionname, String columnname, boolean includeversion) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<h4>").append(sectionname).append("</h4>\n");
        buffer.append("<table border=\"1\" width=\"80%\">\n");
        buffer.append("<tr>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"30%\">").append("<b>").append(columnname).append("</b>").append("</td>\n");
        if (includeversion) {
            buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"20%\" title=\"");
            buffer.append(SearchMessages.UseReportConverter_version_column_description).append("\"\">");
            buffer.append("<b>").append(SearchMessages.UseReportConverter_version).append("</b>").append("</td>\n");
        }
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_api_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_api_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_internal_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_internal_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_permissible_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_internal_permissible_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_fragment_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_fragment_permissible_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_illegal_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_illegal).append("</b>").append("</td>\n");
        return buffer.toString();
    }

    String getReferenceTableEntry(CountGroup counts, String link, String linktext, boolean includeversion) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr bgcolor=\"").append(this.getRowColour(counts)).append("\">\n");
        buffer.append("\t<td><b><a href=\"").append(link).append("\">").append(this.getBundleOnlyName(linktext)).append("</a>").append("</b>").append("</td>\n");
        if (includeversion) {
            buffer.append("\t<td align=\"left\">").append(this.getVersion(linktext)).append("</td>\n");
        }
        buffer.append("\t<td align=\"center\">").append(counts.getTotalApiRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalInternalRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalPermissableRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalFragmentPermissibleRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalIllegalRefCount()).append("</td>\n");
        buffer.append("</tr>\n");
        return buffer.toString();
    }

    String getBundleOnlyName(String text) {
        int idx = text.indexOf(40);
        if (idx > -1) {
            return text.substring(0, idx - 1);
        }
        return text;
    }

    String getVersion(String text) {
        int idx = text.indexOf(40);
        if (idx > -1) {
            int idx2 = text.indexOf(41, idx);
            String version = text.substring(idx + 1, idx2);
            try {
                Version ver = new Version(version);
                return ver.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return "-";
    }

    protected String getAdditionalIndexInfo(boolean hasreports) {
        return null;
    }

    protected String getTypeCountSummary(String typename, CountGroup counts, int membercount) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<h4>").append(SearchMessages.UseReportConverter_summary).append("</h4>\n");
        buffer.append("<p>").append(NLS.bind((String)SearchMessages.UseReportConverter___has_total_refs, (Object[])new String[]{typename, Integer.toString(counts.getTotalRefCount()), Integer.toString(membercount)})).append("</p>\n");
        return buffer.toString();
    }

    static final class CountGroup {
        int total_api_field_count = 0;
        int total_private_field_count = 0;
        int total_permissable_field_count = 0;
        int total_fragment_permissible_field_count = 0;
        int total_illegal_field_count = 0;
        int total_api_method_count = 0;
        int total_private_method_count = 0;
        int total_permissable_method_count = 0;
        int total_fragment_permissible_method_count = 0;
        int total_illegal_method_count = 0;
        int total_api_type_count = 0;
        int total_private_type_count = 0;
        int total_permissable_type_count = 0;
        int total_fragment_permissible_type_count = 0;
        int total_illegal_type_count = 0;

        CountGroup() {
        }

        public int getTotalRefCount() {
            return this.total_api_field_count + this.total_api_method_count + this.total_api_type_count + this.total_private_field_count + this.total_private_method_count + this.total_private_type_count + this.total_permissable_field_count + this.total_permissable_method_count + this.total_permissable_type_count + this.total_fragment_permissible_field_count + this.total_fragment_permissible_method_count + this.total_fragment_permissible_type_count + this.total_illegal_field_count + this.total_illegal_method_count + this.total_illegal_type_count;
        }

        public int getTotalApiRefCount() {
            return this.total_api_field_count + this.total_api_method_count + this.total_api_type_count;
        }

        public int getTotalInternalRefCount() {
            return this.total_private_field_count + this.total_private_method_count + this.total_private_type_count;
        }

        public int getTotalPermissableRefCount() {
            return this.total_permissable_field_count + this.total_permissable_method_count + this.total_permissable_type_count;
        }

        public int getTotalFragmentPermissibleRefCount() {
            return this.total_fragment_permissible_field_count + this.total_fragment_permissible_method_count + this.total_fragment_permissible_type_count;
        }

        public int getTotalIllegalRefCount() {
            return this.total_illegal_field_count + this.total_illegal_method_count + this.total_illegal_type_count;
        }
    }

    static class Member {
        IElementDescriptor descriptor = null;
        TreeMap<String, List<Reference>> children = new TreeMap(compare);
        CountGroup counts = new CountGroup();

        public Member(IElementDescriptor desc) {
            this.descriptor = desc;
        }
    }

    static final class MissingHandler
    extends DefaultHandler {
        List<String> missing = new ArrayList<String>();
        static String pattern = "Require-Bundle:";

        MissingHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("component".equals(qName)) {
                String value = attributes.getValue("details");
                StringTokenizer tokenizer = new StringTokenizer(value, "<>");
                int index = -1;
                while (tokenizer.hasMoreTokens()) {
                    value = tokenizer.nextToken();
                    index = value.indexOf(pattern);
                    if (index <= -1) continue;
                    this.missing.add(value.replaceAll(pattern, ""));
                }
            }
        }
    }

    static class Reference {
        IElementDescriptor desc = null;
        int line = -1;
        int vis = -1;
        String message = null;

        public Reference(IElementDescriptor desc, int line, int vis, String message) {
            this.desc = desc;
            this.line = line;
            this.vis = vis;
            this.message = message;
        }
    }

    static class Report {
        String name = null;
        TreeMap<Type, TreeMap<IMemberDescriptor, Member>> children = new TreeMap(compare);
        CountGroup counts = new CountGroup();

        Report() {
        }
    }

    static class Type {
        IElementDescriptor desc = null;
        CountGroup counts = new CountGroup();

        public Type(IElementDescriptor desc) {
            this.desc = desc;
        }
    }

    class Visitor
    extends UseScanVisitor {
        ArrayList<Report> reports = new ArrayList();
        Report currentreport = null;
        Type currenttype = null;
        Type currentreferee = null;
        Member currentmember = null;
        HashMap<IReferenceTypeDescriptor, Type> keys = new HashMap();
        ArrayList<Type> referees = new ArrayList();

        Visitor() {
        }

        private boolean acceptReference(IMemberDescriptor desc, Pattern[] patterns) {
            if (patterns != null) {
                Pattern[] patternArray = patterns;
                int n = patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    Pattern pattern = patternArray[n2];
                    if (pattern.matcher(desc.getPackage().getName()).find()) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        IReferenceTypeDescriptor getEnclosingDescriptor(IMemberDescriptor member) {
            switch (member.getElementType()) {
                case 2: {
                    return (IReferenceTypeDescriptor)member;
                }
                case 5: 
                case 6: {
                    return member.getEnclosingType();
                }
            }
            return null;
        }

        @Override
        public boolean visitComponent(IComponentDescriptor target) {
            this.currentreport = new Report();
            this.currentreport.name = UseReportConverter.this.composeName(target.getId(), target.getVersion());
            this.reports.add(this.currentreport);
            return true;
        }

        @Override
        public void endVisitComponent(IComponentDescriptor target) {
            try {
                try {
                    long start = 0L;
                    if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                        System.out.println("Writing report for bundle: " + target.getId());
                        start = System.currentTimeMillis();
                    }
                    if (this.currentreport.counts.getTotalRefCount() > 0) {
                        UseReportConverter.this.writeReferencedMemberPage(this.currentreport, this.referees);
                    } else {
                        this.reports.remove(this.currentreport);
                    }
                    if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                        System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                    }
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    this.currentreport.children.clear();
                    this.keys.clear();
                    this.referees.clear();
                }
            }
            finally {
                this.currentreport.children.clear();
                this.keys.clear();
                this.referees.clear();
            }
        }

        @Override
        public boolean visitReferencingComponent(IComponentDescriptor component) {
            this.currentreferee = new Type(component);
            return true;
        }

        @Override
        public void endVisitReferencingComponent(IComponentDescriptor component) {
            if (this.currentreferee.counts.getTotalRefCount() > 0) {
                this.referees.add(this.currentreferee);
            }
        }

        @Override
        public boolean visitMember(IMemberDescriptor referencedMember) {
            TreeMap<Object, Member> map;
            IReferenceTypeDescriptor desc = this.getEnclosingDescriptor(referencedMember);
            if (desc == null) {
                return false;
            }
            this.currenttype = this.keys.get(desc);
            if (this.currenttype == null) {
                this.currenttype = new Type(desc);
                this.keys.put(desc, this.currenttype);
            }
            if ((map = this.currentreport.children.get(this.currenttype)) == null) {
                map = new TreeMap(compare);
                this.currentreport.children.put(this.currenttype, map);
            }
            this.currentmember = map.get(referencedMember);
            if (this.currentmember == null) {
                this.currentmember = new Member(referencedMember);
                map.put(referencedMember, this.currentmember);
            }
            return true;
        }

        @Override
        public void endVisitMember(IMemberDescriptor referencedMember) {
            IReferenceTypeDescriptor desc;
            if (this.currentmember.children.size() == 0) {
                TreeMap<IMemberDescriptor, Member> map = this.currentreport.children.get(this.currenttype);
                map.remove(referencedMember);
            }
            if (this.currenttype.counts.getTotalRefCount() == 0 && (desc = this.getEnclosingDescriptor(referencedMember)) != null) {
                this.keys.remove(desc);
                this.currentreport.children.remove(this.currenttype);
            }
        }

        String formatMessages(String[] messages) {
            if (messages != null) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < messages.length) {
                    buffer.append(messages[i]);
                    if (i < messages.length - 1) {
                        buffer.append("\n");
                    }
                    ++i;
                }
                return buffer.toString();
            }
            return null;
        }

        @Override
        public void visitReference(IReferenceDescriptor reference) {
            IMemberDescriptor fromMember = reference.getMember();
            if (!this.acceptReference(reference.getReferencedMember(), UseReportConverter.this.topatterns) || !this.acceptReference(fromMember, UseReportConverter.this.frompatterns)) {
                return;
            }
            int lineNumber = reference.getLineNumber();
            int refKind = reference.getReferenceKind();
            int visibility = reference.getVisibility();
            String refname = org.eclipse.pde.api.tools.internal.builder.Reference.getReferenceText(refKind);
            List<Reference> refs = this.currentmember.children.get(refname);
            if (refs == null) {
                refs = new ArrayList<Reference>();
                this.currentmember.children.put(refname, refs);
            }
            refs.add(new Reference(fromMember, lineNumber, visibility, this.formatMessages(reference.getProblemMessages())));
            block0 : switch (fromMember.getElementType()) {
                case 2: {
                    switch (visibility) {
                        case 1: {
                            ++this.currentmember.counts.total_api_type_count;
                            ++this.currenttype.counts.total_api_type_count;
                            ++this.currentreferee.counts.total_api_type_count;
                            ++this.currentreport.counts.total_api_type_count;
                            break block0;
                        }
                        case 2: {
                            ++this.currentmember.counts.total_private_type_count;
                            ++this.currenttype.counts.total_private_type_count;
                            ++this.currentreferee.counts.total_private_type_count;
                            ++this.currentreport.counts.total_private_type_count;
                            break block0;
                        }
                        case 8: {
                            ++this.currentmember.counts.total_permissable_type_count;
                            ++this.currenttype.counts.total_permissable_type_count;
                            ++this.currentreferee.counts.total_permissable_type_count;
                            ++this.currentreport.counts.total_permissable_type_count;
                            break block0;
                        }
                        case 5: {
                            ++this.currentmember.counts.total_fragment_permissible_type_count;
                            ++this.currenttype.counts.total_fragment_permissible_type_count;
                            ++this.currentreferee.counts.total_fragment_permissible_type_count;
                            ++this.currentreport.counts.total_fragment_permissible_type_count;
                            break block0;
                        }
                        case 22: {
                            ++this.currentmember.counts.total_illegal_type_count;
                            ++this.currenttype.counts.total_illegal_type_count;
                            ++this.currentreferee.counts.total_illegal_type_count;
                            ++this.currentreport.counts.total_illegal_type_count;
                            break block0;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (visibility) {
                        case 1: {
                            ++this.currentmember.counts.total_api_method_count;
                            ++this.currenttype.counts.total_api_method_count;
                            ++this.currentreferee.counts.total_api_method_count;
                            ++this.currentreport.counts.total_api_method_count;
                            break block0;
                        }
                        case 2: {
                            ++this.currentmember.counts.total_private_method_count;
                            ++this.currenttype.counts.total_private_method_count;
                            ++this.currentreferee.counts.total_private_method_count;
                            ++this.currentreport.counts.total_private_method_count;
                            break block0;
                        }
                        case 8: {
                            ++this.currentmember.counts.total_permissable_method_count;
                            ++this.currenttype.counts.total_permissable_method_count;
                            ++this.currentreferee.counts.total_permissable_method_count;
                            ++this.currentreport.counts.total_permissable_method_count;
                            break block0;
                        }
                        case 5: {
                            ++this.currentmember.counts.total_fragment_permissible_method_count;
                            ++this.currenttype.counts.total_fragment_permissible_method_count;
                            ++this.currentreferee.counts.total_fragment_permissible_method_count;
                            ++this.currentreport.counts.total_fragment_permissible_method_count;
                            break block0;
                        }
                        case 22: {
                            ++this.currentmember.counts.total_illegal_method_count;
                            ++this.currenttype.counts.total_illegal_method_count;
                            ++this.currentreferee.counts.total_illegal_method_count;
                            ++this.currentreport.counts.total_illegal_method_count;
                            break block0;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (visibility) {
                        case 1: {
                            ++this.currentmember.counts.total_api_field_count;
                            ++this.currenttype.counts.total_api_field_count;
                            ++this.currentreferee.counts.total_api_field_count;
                            ++this.currentreport.counts.total_api_field_count;
                            break block0;
                        }
                        case 2: {
                            ++this.currentmember.counts.total_private_field_count;
                            ++this.currenttype.counts.total_private_field_count;
                            ++this.currentreferee.counts.total_private_field_count;
                            ++this.currentreport.counts.total_private_field_count;
                            break block0;
                        }
                        case 8: {
                            ++this.currentmember.counts.total_permissable_field_count;
                            ++this.currenttype.counts.total_permissable_field_count;
                            ++this.currentreferee.counts.total_permissable_field_count;
                            ++this.currentreport.counts.total_permissable_field_count;
                            break block0;
                        }
                        case 5: {
                            ++this.currentmember.counts.total_fragment_permissible_field_count;
                            ++this.currenttype.counts.total_fragment_permissible_field_count;
                            ++this.currentreferee.counts.total_fragment_permissible_field_count;
                            ++this.currentreport.counts.total_fragment_permissible_field_count;
                            break block0;
                        }
                        case 22: {
                            ++this.currentmember.counts.total_illegal_field_count;
                            ++this.currenttype.counts.total_illegal_field_count;
                            ++this.currentreferee.counts.total_illegal_field_count;
                            ++this.currentreport.counts.total_illegal_field_count;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    }
}

