/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram.svg;

import com.google.common.base.Joiner;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGBasicObject;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGConnection
extends SVGBasicObject {
    List<Point> points = new ArrayList<Point>();

    public SVGConnection(Document doc, String label, int x, int y) {
        super(doc, label);
        this.element = doc.createElementNS("http://www.w3.org/2000/svg", "polyline");
        this.addPoint(x, y);
    }

    public void addPoint(int x, int y) {
        this.points.add(new Point(x, y));
    }

    @Override
    public Element getElement() {
        Joiner joiner = Joiner.on((String)",");
        this.element.setAttributeNS(null, "points", joiner.join(this.points));
        this.element.setAttributeNS(null, "stroke", this.strokeColor);
        this.element.setAttributeNS(null, "stroke-width", String.valueOf(this.strokeWidth));
        this.element.setAttributeNS(null, "fill", this.fillColor);
        return this.element;
    }

    private class Point {
        public final int x;
        public final int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.x)) + "," + String.valueOf(this.y);
        }
    }
}

