/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationPackage;
import org.eclipse.papyrus.infra.viewpoints.configuration.EReferencePropertyDescriptor;
import org.eclipse.papyrus.infra.viewpoints.configuration.PathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathElementItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public PathElementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addFeaturePropertyDescriptor(object);
            this.addOriginPropertyDescriptor(object);
            this.addTargetPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addFeaturePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EReferencePropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PathElement_feature_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PathElement_feature_feature", "_UI_PathElement_type"), (EStructuralFeature)ConfigurationPackage.Literals.PATH_ELEMENT__FEATURE, true, false, true, null, null, null)));
    }

    protected void addOriginPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PathElement_origin_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PathElement_origin_feature", "_UI_PathElement_type"), (EStructuralFeature)ConfigurationPackage.Literals.PATH_ELEMENT__ORIGIN, false, false, false, null, null, null));
    }

    protected void addTargetPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PathElement_target_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PathElement_target_feature", "_UI_PathElement_type"), (EStructuralFeature)ConfigurationPackage.Literals.PATH_ELEMENT__TARGET, false, false, false, null, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PathElement.png"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        PathElement path = (PathElement)object;
        StringBuilder builder = new StringBuilder();
        EClass origin = path.getOrigin();
        EReference feature = path.getFeature();
        EClass target = path.getTarget();
        builder.append(origin != null ? origin.getName() : "?");
        builder.append(".");
        builder.append(feature != null ? feature.getName() : "?");
        builder.append(" => ");
        builder.append(target != null ? target.getName() : "?");
        return builder.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

