/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.core.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.emf.facet.efacet.EFacetPackage;
import org.eclipse.papyrus.emf.facet.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.FacetAttribute;
import org.eclipse.papyrus.emf.facet.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.FacetReference;
import org.eclipse.papyrus.emf.facet.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetAction;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.emf.core.ICatalogSetManager;
import org.eclipse.papyrus.emf.facet.util.emf.core.exception.InvalidFacetSetException;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.exported.BuildPropertiesUtils;

@Deprecated
public class FacetActionImpl
implements IFacetAction {
    @Override
    public Facet createFacetInFacetSet(FacetSet facetSet, Facet facet, EditingDomain editingDomain) {
        if (facetSet == null) {
            throw new IllegalArgumentException("The given FacetSet cannot be null");
        }
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null");
        }
        if (facet.eResource() != null || facet.eContainer() != null) {
            throw new IllegalArgumentException("The given Facet cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        if (!editingDomain.getResourceSet().getResources().contains((Object)facetSet.eResource())) {
            editingDomain.getResourceSet().getResources().add((Object)facetSet.eResource());
        }
        AddCommand command = new AddCommand(editingDomain, (EObject)facetSet, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacetSet_Facets(), (Object)facet);
        editingDomain.getCommandStack().execute((Command)command);
        return facet;
    }

    @Override
    public void addAttributeInFacet(Facet facet, FacetAttribute facetAttribute, EditingDomain editingDomain) {
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null");
        }
        if (facetAttribute == null) {
            throw new IllegalArgumentException("The given FacetAttribute cannot be null");
        }
        if (facetAttribute.eResource() != null || facetAttribute.eContainer() != null) {
            throw new IllegalArgumentException("The given FacetAttribute cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        AddCommand command = new AddCommand(editingDomain, (EObject)facet, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)facetAttribute);
        editingDomain.getCommandStack().execute((Command)command);
    }

    @Override
    public void addReferenceInFacet(Facet facet, FacetReference facetReference, EditingDomain editingDomain) {
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null.");
        }
        if (facetReference == null) {
            throw new IllegalArgumentException("The given FacetReference cannot be null");
        }
        if (facetReference.eResource() != null || facetReference.eContainer() != null) {
            throw new IllegalArgumentException("The given FacetReference cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null.");
        }
        AddCommand command = new AddCommand(editingDomain, (EObject)facet, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)facetReference);
        editingDomain.getCommandStack().execute((Command)command);
    }

    @Override
    public void addOperationInFacet(Facet facet, FacetOperation facetOperation, EditingDomain editingDomain) {
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        if (facetOperation == null) {
            throw new IllegalArgumentException("The given FacetOperation cannot be null");
        }
        if (facetOperation.eResource() != null || facetOperation.eContainer() != null) {
            throw new IllegalArgumentException("The given FacetOperation cannot be contained by a resource");
        }
        if (facet == null) {
            throw new IllegalArgumentException("The given Facet cannot be null");
        }
        AddCommand command = new AddCommand(editingDomain, (EObject)facet, (EStructuralFeature)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)facetOperation);
        editingDomain.getCommandStack().execute((Command)command);
    }

    @Override
    public void setFacetSetNsUri(FacetSet facetSet, String nsUri, EditingDomain editingDomain) {
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        if (facetSet == null) {
            throw new IllegalArgumentException("The given FacetSet cannot be null");
        }
        SetCommand command = new SetCommand(editingDomain, (EObject)facetSet, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsURI(), (Object)nsUri);
        editingDomain.getCommandStack().execute((Command)command);
    }

    @Override
    public void addParameterInOperation(FacetOperation operation, EParameter parameter, EditingDomain editingDomain) {
        if (operation == null) {
            throw new IllegalArgumentException("The given FacetOperation cannot be null");
        }
        if (parameter == null) {
            throw new IllegalArgumentException("The given EParameter cannot be null");
        }
        if (parameter.eResource() != null || parameter.eContainer() != null) {
            throw new IllegalArgumentException("The given EParameter cannot be contained by a resource");
        }
        if (editingDomain == null) {
            throw new IllegalArgumentException("The given EditingDomain cannot be null");
        }
        AddCommand command = new AddCommand(editingDomain, (EObject)operation, (EStructuralFeature)EcorePackage.eINSTANCE.getEOperation_EParameters(), (Object)parameter);
        editingDomain.getCommandStack().execute((Command)command);
    }

    @Override
    public void createFacetSet(FacetSet facetSet, IFile file) throws IOException, InvalidFacetSetException {
        if (facetSet == null) {
            throw new IllegalArgumentException("The given FacetSet cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("The given IFile cannot be null");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("The given IFile already exists");
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)facetSet);
        resource.save(null);
        try {
            BuildPropertiesUtils.addToBuild((IFile)file);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)("Error adding file " + file.getFullPath() + " to the build.properties"), (Plugin)Activator.getDefault());
        }
        ICatalogSetManager.INSTANCE.registerModelDeclaration(file);
    }
}

