/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.utils;

import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandRunnable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandBuilder {
    private static final Parameterization[] EMPTY_PARAMETERIZATION_ARRAY = new Parameterization[0];
    private static final Logger logger = Logger.getLogger(CommandBuilder.class);
    private Command command;
    private List<Parameterization> parameterizations;
    private Exception exception;

    private CommandBuilder setCommand(String commandId) throws NotDefinedException {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.command = commandService.getCommand(commandId);
        if (this.command == null) {
            throw new NotDefinedException("Command ID '" + commandId + "' not found.");
        }
        return this;
    }

    public CommandBuilder setParameter(String parameterId, String value) throws NotDefinedException {
        if (this.parameterizations == null && value != null) {
            this.parameterizations = new ArrayList<Parameterization>();
        }
        IParameter parameter = this.command.getParameter(parameterId);
        Parameterization parameterization = new Parameterization(parameter, value);
        this.parameterizations.add(parameterization);
        return this;
    }

    public ParameterizedCommand getCommand() {
        if (this.command == null) {
            return null;
        }
        if (this.parameterizations == null || this.parameterizations.isEmpty()) {
            return new ParameterizedCommand(this.command, null);
        }
        return new ParameterizedCommand(this.command, this.parameterizations.toArray(EMPTY_PARAMETERIZATION_ARRAY));
    }

    public Object execute() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        final ParameterizedCommand parameterizedCommand = this.getCommand();
        if (parameterizedCommand == null) {
            throw new ExecutionException("The command has not been configured yet.");
        }
        final IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Display display = Display.getDefault();
        CommandRunnable commandRunnable = new CommandRunnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        logger.debug((Object)("executeCommand: " + CommandBuilder.this.command.getId()));
                        this.request = service.executeCommand(parameterizedCommand, null);
                        logger.debug((Object)("executeCommand done: " + CommandBuilder.this.command.getId()));
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        CommandBuilder.this.exception = (Exception)e;
                        if (e instanceof ExecutionException) break block2;
                        e.printStackTrace();
                    }
                }
            }
        };
        display.syncExec((Runnable)commandRunnable);
        if (this.exception instanceof ExecutionException) {
            throw (ExecutionException)((Object)this.exception);
        }
        return commandRunnable.getRequest();
    }

    public static CommandBuilder build(String commandId) throws NotDefinedException {
        return new CommandBuilder().setCommand(commandId);
    }
}

