/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.commands;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractJobCommand
extends AbstractHandler {
    private DialogUtil dialogUtil = DialogUtil.getInstance();
    String commandName = "Command Name";

    public AbstractJobCommand(String commandName) {
        this.commandName = commandName;
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        boolean noExceptions = false;
        try {
            this.execPreJobOperations(event, (IProgressMonitor)new NullProgressMonitor());
            noExceptions = true;
        }
        catch (Exception e) {
            this.dialogUtil.showMessage_ExceptionError(e);
            e.printStackTrace();
        }
        if (noExceptions) {
            Job job = new Job(this.commandName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        AbstractJobCommand.this.execJobCommand(event, monitor);
                    }
                    catch (Exception e) {
                        AbstractJobCommand.this.dialogUtil.showMessage_ExceptionError(e);
                        e.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(false);
            job.schedule();
            if (this.waitJobExec(event)) {
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.execPostJobOperations(event, new NullProgressMonitor());
            noExceptions = true;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.dialogUtil.showMessage_ExceptionError(e);
            e.printStackTrace();
        }
        return null;
    }

    public abstract void execPreJobOperations(ExecutionEvent var1, IProgressMonitor var2) throws Exception;

    public abstract void execJobCommand(ExecutionEvent var1, IProgressMonitor var2) throws Exception;

    public boolean waitJobExec(ExecutionEvent event) {
        String paramisProgrExec = event.getParameter("waitJobExec");
        if (paramisProgrExec != null) {
            return Boolean.valueOf(paramisProgrExec);
        }
        return false;
    }

    public abstract void execPostJobOperations(ExecutionEvent var1, NullProgressMonitor var2) throws Exception;
}

