/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Interaction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConcurrentAccessProtocolKind implements Enumerator
{
    PIP(0, "PIP", "PIP"),
    PCP(1, "PCP", "PCP"),
    NO_PREEMPTION(2, "NoPreemption", "NoPreemption"),
    UNDEF(3, "Undef", "Undef"),
    OTHER(4, "Other", "Other");

    public static final int PIP_VALUE = 0;
    public static final int PCP_VALUE = 1;
    public static final int NO_PREEMPTION_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final ConcurrentAccessProtocolKind[] VALUES_ARRAY;
    public static final List<ConcurrentAccessProtocolKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConcurrentAccessProtocolKind[]{PIP, PCP, NO_PREEMPTION, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConcurrentAccessProtocolKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConcurrentAccessProtocolKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConcurrentAccessProtocolKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConcurrentAccessProtocolKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConcurrentAccessProtocolKind get(int value) {
        switch (value) {
            case 0: {
                return PIP;
            }
            case 1: {
                return PCP;
            }
            case 2: {
                return NO_PREEMPTION;
            }
            case 3: {
                return UNDEF;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private ConcurrentAccessProtocolKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

