/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram.ui.docGenerators;

import eu.fbk.eclipse.standardtools.diagram.ContainerDescriptor;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGComponent;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGConnection;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGLabel;
import eu.fbk.eclipse.standardtools.diagram.ui.model.AbstractBlockDefinitionDiagramModel;
import java.awt.Dimension;
import java.awt.Point;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlockDefinitionDiagramGeneratorService {
    private static final Logger logger = Logger.getLogger(BlockDefinitionDiagramGeneratorService.class);
    private static BlockDefinitionDiagramGeneratorService diagramGeneratorService;
    AbstractBlockDefinitionDiagramModel graphicalModel;
    private boolean showConnections = true;
    private boolean showCompositionAssociationLabels = true;
    private int component_border = 0;
    private int xTranslation = 400;
    private int yTranslation = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;

    public static BlockDefinitionDiagramGeneratorService getInstance(AbstractBlockDefinitionDiagramModel graphicalModel) {
        if (diagramGeneratorService == null) {
            diagramGeneratorService = new BlockDefinitionDiagramGeneratorService(graphicalModel);
        }
        return diagramGeneratorService;
    }

    public BlockDefinitionDiagramGeneratorService(AbstractBlockDefinitionDiagramModel graphicalModel) {
        this.graphicalModel = graphicalModel;
    }

    public void createDiagramFile(String saveFilePath, Object diagramEditPart, IProgressMonitor monitor) {
        monitor.beginTask("Creating Diagram File", 1);
        this.maxWidth = 0;
        this.maxHeight = 0;
        Document docDiagram = this.createDocumentDiagram(diagramEditPart);
        this.createImageFileFromDocumentDiagram(saveFilePath, docDiagram);
        monitor.done();
    }

    protected ContainerDescriptor createDiagramDescriptorWithImageFileUrl(String diagramName, String saveFilePath) {
        ContainerDescriptor diagramDescriptor = new ContainerDescriptor();
        diagramDescriptor.name = diagramName;
        return diagramDescriptor;
    }

    public String getImageName(Object graphicalComponent) {
        return this.graphicalModel.getGraphicalComponentName(graphicalComponent);
    }

    private void createImageFileFromDocumentDiagram(String saveFilePath, Document doc) {
        try {
            TranscoderInput input = new TranscoderInput(doc);
            if (saveFilePath.endsWith("svg")) {
                SVGTranscoder transcoder = new SVGTranscoder();
                FileWriter ostream = new FileWriter(saveFilePath);
                TranscoderOutput output = new TranscoderOutput((Writer)ostream);
                transcoder.transcode(input, output);
                ((Writer)ostream).flush();
                ((Writer)ostream).close();
            } else if (saveFilePath.endsWith("png")) {
                PNGTranscoder transcoder = new PNGTranscoder();
                FileOutputStream ostream = new FileOutputStream(saveFilePath);
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                transcoder.transcode(input, output);
                ostream.flush();
                ostream.close();
            } else if (saveFilePath.endsWith("pdf")) {
                PDFTranscoder transcoder = new PDFTranscoder();
                FileOutputStream ostream = new FileOutputStream(saveFilePath);
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                transcoder.transcode(input, output);
                ostream.flush();
                ostream.close();
            } else {
                logger.error((Object)"Unsupported image format");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Document createDocumentDiagram(Object diagramEditPart) {
        Document docDiagram = this.createDocument("svg");
        Element svgRoot = this.createDocumentElement(docDiagram);
        this.createSVGComponents(docDiagram, svgRoot, diagramEditPart);
        if (this.showConnections) {
            this.createSVGConnections(docDiagram, svgRoot, diagramEditPart);
        }
        svgRoot.setAttributeNS(null, "width", String.valueOf(this.maxWidth + 100));
        svgRoot.setAttributeNS(null, "height", String.valueOf(this.maxHeight + 100));
        return docDiagram;
    }

    private Document createDocument(String qualifiedName) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document doc = impl.createDocument("http://www.w3.org/2000/svg", qualifiedName, null);
        return doc;
    }

    private Element createDocumentElement(Document doc) {
        Element svgRoot = doc.getDocumentElement();
        return svgRoot;
    }

    private void createSVGConnections(Document doc, Element svgRootElement, Object parentComponent) {
        for (Object graphicalAssociation : this.graphicalModel.getCompositionAssociations(parentComponent)) {
            List<Point> connectionPoints = this.getLayoutCompositionAssociationPoints(graphicalAssociation);
            Point firstConnectionPoint = connectionPoints.get(0);
            SVGConnection svgConnection = new SVGConnection(doc, "", (int)firstConnectionPoint.getX(), (int)firstConnectionPoint.getY());
            for (Point connectionPoint : connectionPoints) {
                svgConnection.addPoint((int)connectionPoint.getX(), (int)connectionPoint.getY());
                this.computeDiagramBoundaries(connectionPoint.x, connectionPoint.y);
            }
            if (this.showCompositionAssociationLabels) {
                for (Point label : this.graphicalModel.getCompositionAssociationsLabels(graphicalAssociation)) {
                    Point labelPoint = this.getCompositionAssociationLabelPoint(label);
                    String labelText = this.graphicalModel.getCompositionAssociationLabelText(label);
                    SVGLabel svgLabel = new SVGLabel(doc, labelText);
                    svgLabel.setLabelX((int)labelPoint.getX());
                    svgLabel.setLabelY((int)labelPoint.getY());
                    svgLabel.setLabelStyle(this.getCompositionAssociationLabelStyle(graphicalAssociation));
                    svgLabel.setLabelTransform(this.getCompositionAssociationLabelTransform(graphicalAssociation));
                    svgRootElement.appendChild(svgLabel.getLabelElement());
                }
            }
            svgRootElement.appendChild(svgConnection.getElement());
        }
    }

    private String getCompositionAssociationLabelTransform(Object graphicalAssociation) {
        return "";
    }

    private String getCompositionAssociationLabelStyle(Object graphicalAssociation) {
        return "";
    }

    private void createSVGComponents(Document doc, Element svgRootElement, Object diagram) {
        Point diagramPoint = this.graphicalModel.getDiagramPoint(diagram);
        this.xTranslation = -diagramPoint.x;
        this.yTranslation = -diagramPoint.y;
        for (Object component : this.graphicalModel.getGraphicalComponentsOfBDD(diagram)) {
            Point point = this.getComponentPoint(component, false);
            Dimension dimension = this.getComponentDimension(component);
            this.computeDiagramBoundaries(point.x + dimension.width, point.y + dimension.height);
            SVGComponent svgComponent = new SVGComponent(doc, this.graphicalModel.getGraphicalComponentName(component), (int)point.getX(), (int)point.getY(), (int)dimension.getWidth(), (int)dimension.getHeight());
            svgRootElement.appendChild(svgComponent.getElement());
            svgRootElement.appendChild(svgComponent.getLabelElement());
        }
    }

    private void computeDiagramBoundaries(int width, int height) {
        this.maxWidth = Math.max(this.maxWidth, width);
        this.maxHeight = Math.max(this.maxHeight, height);
    }

    private Dimension getComponentDimension(Object component) {
        Dimension currentDimension = this.graphicalModel.getGraphicalComponentDimension(component);
        Dimension dimension = new Dimension(currentDimension);
        dimension.width = (int)(dimension.getWidth() - (double)(2 * this.component_border));
        dimension.height = (int)(dimension.getHeight() - (double)(2 * this.component_border));
        return dimension;
    }

    private Point getCompositionAssociationLabelPoint(Object label) {
        Point labelPoint = this.graphicalModel.getCompositionAssociationLabelPosition(label);
        return this.translatePoint(labelPoint);
    }

    private Point getComponentPoint(Object component, boolean isRootComponent) {
        Point componentPoint = this.graphicalModel.getGraphicalComponentPosition(component);
        Point translatedComponentPoint = this.translateComponentPoint(componentPoint);
        return translatedComponentPoint;
    }

    private List<Point> getLayoutCompositionAssociationPoints(Object graphicalAssociation) {
        ArrayList<Point> translatedConnectionPoints = new ArrayList<Point>();
        for (Point connectionPoint : this.graphicalModel.getLayoutCompositionAssociationPoints(graphicalAssociation)) {
            translatedConnectionPoints.add(this.translatePoint(connectionPoint));
        }
        return translatedConnectionPoints;
    }

    private Point translateComponentPoint(Point componentPoint) {
        Point point = new Point(componentPoint);
        point.x = (int)((double)this.xTranslation + point.getX() + (double)this.component_border);
        point.y = (int)((double)this.yTranslation + point.getY() + (double)this.component_border);
        return point;
    }

    private Point translatePoint(Point point) {
        point.x = (int)((double)this.xTranslation + point.getX());
        point.y = (int)((double)this.yTranslation + point.getY());
        return point;
    }
}

