/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.util;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.GMFObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.infra.viewpoints.style.StylePackage;

public class LegacyOwnerObservable
extends AbstractObservableValue {
    private EditingDomain domain;
    private Diagram diagram;
    private EReference reference;
    private IChangeListener styleListener;
    private IChangeListener valueListener;
    private PapyrusObservableValue styleObservable;
    private PapyrusObservableValue valueObservable;

    public LegacyOwnerObservable(Diagram diagram, EReference feature, EditingDomain domain) {
        super(Realm.getDefault());
        this.domain = domain;
        this.diagram = diagram;
        this.reference = feature;
        this.buildStyleListener();
        this.styleObservable = new GMFObservableValue((EObject)diagram, (EStructuralFeature)NotationPackage.Literals.VIEW__STYLES, domain);
        this.styleObservable.addChangeListener(this.styleListener);
    }

    public boolean isStale() {
        return this.valueListener != null;
    }

    private void buildStyleListener() {
        this.styleListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (LegacyOwnerObservable.this.valueListener != null) {
                    return;
                }
                Style style = LegacyOwnerObservable.this.diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
                if (style != null) {
                    LegacyOwnerObservable.this.buildValueListener(style);
                }
            }
        };
    }

    private void buildValueListener(Style style) {
        this.valueListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                LegacyOwnerObservable.this.fireValueChange(new ValueDiff(){

                    public Object getOldValue() {
                        return null;
                    }

                    public Object getNewValue() {
                        return DiagramUtils.getOwner((Diagram)LegacyOwnerObservable.this.diagram);
                    }
                });
            }
        };
        this.valueObservable = new GMFObservableValue((EObject)style, (EStructuralFeature)this.reference, this.domain);
        this.valueObservable.addChangeListener(this.valueListener);
    }

    public Object getValueType() {
        return EcorePackage.Literals.EOBJECT;
    }

    protected Object doGetValue() {
        return DiagramUtils.getOwner((Diagram)this.diagram);
    }

    protected void doSetValue(Object value) {
        Command emfCommand = this.getCommand((EObject)value);
        this.domain.getCommandStack().execute(emfCommand);
    }

    private Command getCommand(final EObject newValue) {
        final EObject oldValue = DiagramUtils.getOwner((Diagram)this.diagram);
        return new AbstractCommand("Change diagram's owner"){
            private boolean createStyle;
            {
                super($anonymous0);
                this.createStyle = true;
            }

            public void execute() {
                Style style = LegacyOwnerObservable.this.diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
                this.createStyle = style == null;
                DiagramUtils.setOwner((Diagram)LegacyOwnerObservable.this.diagram, (EObject)newValue);
            }

            public void redo() {
                DiagramUtils.setOwner((Diagram)LegacyOwnerObservable.this.diagram, (EObject)newValue);
            }

            public void undo() {
                if (this.createStyle) {
                    Style style = LegacyOwnerObservable.this.diagram.getStyle(StylePackage.Literals.PAPYRUS_VIEW_STYLE);
                    LegacyOwnerObservable.this.diagram.getStyles().remove((Object)style);
                } else {
                    DiagramUtils.setOwner((Diagram)LegacyOwnerObservable.this.diagram, (EObject)oldValue);
                }
            }

            public boolean prepare() {
                return true;
            }
        };
    }
}

