/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.faultTreeViewer.utils;

import eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.FTAModel;
import eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.impl.EmftaFactoryImpl;
import eu.fbk.eclipse.standardtools.faultTreeViewer.xSAP.FaultTreeBuilder;
import eu.fbk.eclipse.standardtools.faultTreeViewer.xSAP.generated.FaultTree;
import eu.fbk.eclipse.standardtools.logger.Console;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.internal.metamodel.spec.DSemanticDiagramSpec;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallbackWithConfimation;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class FaultTreeViewerUtil {
    private static FaultTreeViewerUtil faultTreeTViewerUtil;
    private static final Logger logger;
    private static DirectoryUtil directoryUtil;
    private static DialogUtil dialogUtil;
    private String AIRD_FILE = "representations.aird";
    private String FILE_EXTENSION = "emfta";
    private String VIEWPOINT = "EMFTA";

    static {
        logger = Logger.getLogger(FaultTreeViewerUtil.class);
        directoryUtil = DirectoryUtil.getInstance();
        dialogUtil = DialogUtil.getInstance();
    }

    public static FaultTreeViewerUtil getInstance() {
        if (faultTreeTViewerUtil == null) {
            faultTreeTViewerUtil = new FaultTreeViewerUtil();
        }
        return faultTreeTViewerUtil;
    }

    public void openFTAViewerFromEmftaFile(IStructuredSelection selection, IProgressMonitor monitor) throws Exception {
        IFile file;
        if (selection.getFirstElement() instanceof IFile) {
            file = (IFile)selection.getFirstElement();
            if (file.getFileExtension().compareTo("emfta") != 0) {
                throw new Exception("No .emfta file selected");
            }
        } else {
            throw new Exception("No file selected");
        }
        IProject project = file.getProject();
        Session session = this.createAirdSessionFromCurrentProject(project, monitor);
        session.open(monitor);
        String pathName = file.getFullPath().toOSString();
        URI ftaResourceFileURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        FTAModel ftaModel = this.createFTAModel();
        Resource emftaResource = this.openExistingFTAResourceFile(ftaResourceFileURI, ftaModel);
        this.openFTAViewer(emftaResource, session, ftaModel, true, monitor);
    }

    public void openFTAViewerFromEmftaFile(IFile file, IProgressMonitor monitor) throws Exception {
        if (file.getFileExtension().compareTo("emfta") != 0) {
            throw new Exception("No .emfta file selected");
        }
        IProject project = file.getProject();
        String name = file.getName().replaceAll(".emfta", "");
        Session session = this.createAirdSessionFromCurrentProject(project, monitor, name);
        session.open(monitor);
        String pathName = file.getFullPath().toOSString();
        URI ftaResourceFileURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        FTAModel ftaModel = this.createFTAModel();
        Resource emftaResource = this.openExistingFTAResourceFile(ftaResourceFileURI, ftaModel);
        this.openFTAViewer(emftaResource, session, ftaModel, false, monitor);
    }

    public void openFTAViewerFromSelectedXmlFile(IStructuredSelection selection, IProgressMonitor monitor) throws Exception {
        IFile file;
        if (selection.getFirstElement() instanceof IFile) {
            file = (IFile)selection.getFirstElement();
            if (file.getFileExtension().compareTo("xml") != 0) {
                throw new Exception("No .xml file selected");
            }
        } else {
            throw new Exception("No file selected");
        }
        this.openXmlIFileInFTAViewer(file, monitor);
    }

    public void openXMLIFileInFTAViewerFromDialog(IProgressMonitor monitor) throws Exception {
        IFile xmlIFile = dialogUtil.getIFileFromFileDialog(directoryUtil.getCurrentProjectDir(), "*.xml");
        this.openXmlIFileInFTAViewer(xmlIFile, monitor);
    }

    public void openXmlIFileInFTAViewer(String xmlFilePath, IProgressMonitor monitor) throws Exception {
        logger.debug((Object)("in openXmlIFileInFTAViewer, xmlFilePath: " + xmlFilePath));
        File file = new File(xmlFilePath);
        IFile xmlIFile = dialogUtil.getIFile(file);
        if (xmlIFile == null) {
            throw new Exception("The file " + file.getPath() + " is not inside the workspace.");
        }
        this.openXmlIFileInFTAViewer(xmlIFile, monitor);
    }

    public void openXmlIFileInFTAViewer(IFile xmlIFile, IProgressMonitor monitor) throws Exception {
        if (xmlIFile == null) {
            throw new Exception("The file that contains the fault tree is null.");
        }
        FTAModel ftaModel = this.getFTAModelFromXmlFile(xmlIFile);
        IProject project = xmlIFile.getProject();
        Session aird_session = this.createAirdSessionFromCurrentProject(project, monitor);
        aird_session.open(monitor);
        String pathName = "/" + project.getName() + "/temp/" + xmlIFile.getName() + "." + this.FILE_EXTENSION;
        Console.write((String)("pathName: " + pathName));
        Resource emftaResource = this.createEMFTAResourceFile(pathName, ftaModel);
        logger.debug((Object)("emftaResource.getURI(): " + emftaResource.getURI()));
        Console.write((String)("emftaResource.getURI(): " + emftaResource.getURI()));
        this.openFTAViewer(emftaResource, aird_session, ftaModel, true, monitor);
    }

    public void openFTAViewerFromFTAResource(Resource ftaResource, IProgressMonitor monitor) throws Exception {
        FTAModel ftaModel = (FTAModel)ftaResource.getContents().get(0);
        IProject project = directoryUtil.getCurrentProject();
        Session aird_session = this.createAirdSessionFromCurrentProject(project, monitor);
        aird_session.open(monitor);
        String pathName = "/" + project.getName() + "/temp/" + ftaModel.getName() + "." + this.FILE_EXTENSION;
        Resource emftaResource = this.createEMFTAResourceFile(pathName, ftaModel);
        this.openFTAViewer(emftaResource, aird_session, ftaModel, true, monitor);
    }

    private Resource addEmftaResourceInAirdSession(Resource emftaResource, Session aird_session, IProgressMonitor monitor) {
        URI emftaURI = emftaResource.getURI();
        this.addURIResourceAsSemanticResource(emftaURI, aird_session, monitor);
        Resource emftaSemanticResource = this.getSemanticResource(aird_session, emftaURI);
        return emftaSemanticResource;
    }

    private void openFTAViewer(Resource emftaResource, Session aird_session, FTAModel ftaModel, boolean singleRepresentation, IProgressMonitor monitor) throws Exception {
        Resource emftaSemanticResource = this.addEmftaResourceInAirdSession(emftaResource, aird_session, monitor);
        this.applySelectedViewpoints(aird_session, monitor);
        DRepresentation representation = singleRepresentation ? this.getCreatedRepresentation(aird_session, emftaSemanticResource, monitor) : this.getCreatedRepresentations(aird_session, emftaSemanticResource, monitor);
        this.openTFAViewer(aird_session, representation, monitor);
    }

    private Session createAirdSessionFromCurrentProject(IProject project, IProgressMonitor monitor, String name) throws Exception {
        IFile airdFile = project.getFile("representations-" + name + ".aird");
        return this.getSessionFromAirdFile(project, airdFile, monitor);
    }

    private Session createAirdSessionFromCurrentProject(IProject project, IProgressMonitor monitor) throws Exception {
        IFile airdFile = project.getFile(this.AIRD_FILE);
        return this.getSessionFromAirdFile(project, airdFile, monitor);
    }

    private Session createAird(IProject project, URI representationsURI, IProgressMonitor monitor) throws CoreException {
        Object session;
        Option modelingProject = ModelingProject.asModelingProject((IProject)project);
        if (modelingProject.some()) {
            session = ((ModelingProject)modelingProject.get()).getSession();
        } else {
            Session tempSession = null;
            DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, monitor);
            sessionCreationOperation.execute();
            tempSession = sessionCreationOperation.getCreatedSession();
            session = tempSession != null ? tempSession : null;
        }
        return session;
    }

    private Session getSessionFromAirdFile(IProject project, IFile airdFile, IProgressMonitor monitor) throws Exception {
        URI airdFileURI = URI.createPlatformResourceURI((String)airdFile.getFullPath().toOSString(), (boolean)true);
        if (!airdFile.exists()) {
            Console.write((String)("!airdFile.exists(): " + airdFileURI.path()));
            return this.createAird(project, airdFileURI, monitor);
        }
        Console.write((String)("airdFile.exists(): " + airdFileURI.path()));
        Session session = SessionManager.INSTANCE.getSession(airdFileURI, monitor);
        return session;
    }

    private void addURIResourceAsSemanticResource(URI emftaURI, Session aird_session, IProgressMonitor monitor) {
        AddSemanticResourceCommand addCommandToSession = new AddSemanticResourceCommand(aird_session, emftaURI, monitor);
        aird_session.getTransactionalEditingDomain().getCommandStack().execute((Command)addCommandToSession);
    }

    private FTAModel createFTAModel() {
        FTAModel rootObject = EmftaFactoryImpl.eINSTANCE.createFTAModel();
        rootObject.setName("FTA model root");
        return rootObject;
    }

    private Resource openExistingFTAResourceFile(URI fileURI, FTAModel ftaModel) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)ftaModel);
        return resource;
    }

    private FTAModel getFTAModelFromXmlFile(IFile xmlFile) throws Exception {
        FTAModel ftaModel = null;
        FaultTree xsapFaultTree = FaultTreeBuilder.getInstance().populateFaultTreeClassesFromXml(xmlFile.getRawLocation().makeAbsolute().toFile());
        ftaModel = FaultTreeBuilder.getInstance().convertFaultTreeTypeInFTAModel(xsapFaultTree);
        return ftaModel;
    }

    private Resource createEMFTAResourceFile(String pathName, FTAModel ftaModel) throws Exception {
        URI ftaResourceFileURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        Console.write((String)("ftaResourceFileURI: " + ftaResourceFileURI));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(ftaResourceFileURI);
        resource.getContents().add((Object)ftaModel);
        HashMap options = new HashMap();
        resource.save(options);
        return resource;
    }

    private Resource getSemanticResource(Session session, URI resourceURI) {
        Resource semanticResource = null;
        for (Resource currSemanticResource : session.getSemanticResources()) {
            if (currSemanticResource.getURI() != resourceURI) continue;
            semanticResource = currSemanticResource;
            break;
        }
        return semanticResource;
    }

    private void openTFAViewer(Session session, DRepresentation representation, IProgressMonitor monitor) {
        logger.debug((Object)"openTFAViewer");
        Console.write((String)"openTFAViewer");
        DialectUIManager.INSTANCE.openEditor(session, representation, monitor);
        this.runAutomaticLayout();
        this.saveSession();
    }

    private String getDiagramNameFromURI(URI fileURI) {
        String[] splittedUri = fileURI.toString().split("/");
        return splittedUri[splittedUri.length - 1];
    }

    private void createRepresentations(Session session, String diagramName, EObject rootObject, IProgressMonitor monitor) throws Exception {
        Collection descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(session.getSelectedViewpoints(false), rootObject);
        if (descriptions.isEmpty()) {
            throw new Exception("Could not found representation description for object: " + rootObject);
        }
        for (RepresentationDescription description : descriptions) {
            Console.write((String)"CreateRepresentationCommand");
            CreateRepresentationCommand createViewCommand = new CreateRepresentationCommand(session, description, rootObject, diagramName, monitor);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)createViewCommand);
        }
    }

    private DRepresentation getCreatedRepresentation(Session aird_session, Resource emftaSemanticResource, IProgressMonitor monitor) throws Exception {
        URI resourceURI = emftaSemanticResource.getURI();
        String diagramName = this.getDiagramNameFromURI(resourceURI);
        EObject emftaObject = (EObject)emftaSemanticResource.getContents().get(0);
        this.createRepresentations(aird_session, diagramName, emftaObject, monitor);
        return this.getRepresentation(resourceURI, emftaObject, aird_session);
    }

    private DRepresentation getCreatedRepresentations(Session aird_session, Resource emftaSemanticResource, IProgressMonitor monitor) throws Exception {
        URI resourceURI = emftaSemanticResource.getURI();
        EList emftaObject = emftaSemanticResource.getContents();
        for (EObject obj : emftaObject) {
            String name = "";
            EList attrs = obj.eClass().getEAllAttributes();
            for (EAttribute a : attrs) {
                if (!a.getName().equals("name")) continue;
                name = obj.eGet((EStructuralFeature)a).toString();
                break;
            }
            this.createRepresentations(aird_session, name, obj, monitor);
        }
        return this.getRepresentation(resourceURI, (EObject)emftaObject.get(0), aird_session);
    }

    private DRepresentation getRepresentation(URI resourceURI, EObject rootObject, Session session) {
        DialectManager viewpointDialectManager = DialectManager.INSTANCE;
        Collection representations = viewpointDialectManager.getRepresentations(rootObject, session);
        URI reprURI = null;
        DRepresentation myDiagramRepresentation = null;
        for (DRepresentation currentRep : representations) {
            Console.write((String)("currentRep: " + currentRep));
            boolean isInstanceOfDDsemanticDiagramSpec = currentRep instanceof DSemanticDiagramSpec;
            if (!isInstanceOfDDsemanticDiagramSpec) continue;
            Console.write((String)"isInstanceOfDDsemanticDiagramSpec");
            DSemanticDiagramSpec currDiagram = (DSemanticDiagramSpec)currentRep;
            String diagramName = currDiagram.getDescription().getName();
            reprURI = ((DSemanticDiagram)currentRep).getTarget().eResource().getURI();
            if (!reprURI.equals(resourceURI) || diagramName.compareTo("Tree.diagram") != 0) continue;
            myDiagramRepresentation = currentRep;
        }
        return myDiagramRepresentation;
    }

    private Set<Viewpoint> findInViewpointInRegistry() {
        Set registry = ViewpointRegistry.getInstance().getViewpoints();
        Viewpoint candidateViewpoint = null;
        for (Viewpoint registeredViewpoint : registry) {
            if (!registeredViewpoint.getName().equals(this.VIEWPOINT)) continue;
            candidateViewpoint = registeredViewpoint;
            Console.write((String)("Viewpoint found: " + candidateViewpoint));
            break;
        }
        HashSet<Viewpoint> resultViewpoints = new HashSet<Viewpoint>();
        resultViewpoints.add(candidateViewpoint);
        return resultViewpoints;
    }

    private void applySelectedViewpoints(Session session, IProgressMonitor monitor) {
        Set<Viewpoint> viewpoints = this.findInViewpointInRegistry();
        ViewpointSelectionCallbackWithConfimation callback = new ViewpointSelectionCallbackWithConfimation();
        ChangeViewpointSelectionCommand command = new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)callback, viewpoints, new HashSet(), true, monitor);
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        domain.getCommandStack().execute((Command)command);
    }

    private void runAutomaticLayout() {
        try {
            CommandBuilder layout = CommandBuilder.build((String)"eu.fbk.eclipse.standardtools.faultTreeViewer.commands.RunLayoutCommand");
            layout.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSession() {
        try {
            CommandBuilder layout = CommandBuilder.build((String)"eu.fbk.eclipse.standardtools.faultTreeViewer.commands.SaveDiagramCommand");
            layout.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

