/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.ui;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.ResourceQuery;

public final class RefreshHelper {
    private RefreshHelper() {
    }

    public static boolean isImpactingNotification(Collection<Notification> notifications) {
        boolean isImpactingNotification = false;
        HashSet alreadyDoneNotifiers = Sets.newHashSet();
        for (Notification notification : notifications) {
            EObject eObjectNotifier;
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject) || alreadyDoneNotifiers.contains(eObjectNotifier = (EObject)notifier)) continue;
            alreadyDoneNotifiers.add(eObjectNotifier);
            Resource notifierResource = eObjectNotifier.eResource();
            if (notifierResource == null || new ResourceQuery(notifierResource).isRepresentationsResource()) continue;
            isImpactingNotification = true;
            break;
        }
        return isImpactingNotification;
    }
}

