/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.internal.common.model;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;

public class NotationPageSnippet
implements IModelSnippet {
    private EMFLogicalModel model;
    private TransactionalEditingDomain domain;
    private ResourceSetListener listener;
    private IPageManager pageManager;

    public void start(IModel startingModel) {
        if (startingModel instanceof EMFLogicalModel) {
            this.model = (EMFLogicalModel)startingModel;
            Resource resource = this.model.getResource();
            if (resource != null) {
                ModelSet modelSet = (ModelSet)resource.getResourceSet();
                this.domain = modelSet.getTransactionalEditingDomain();
                if (this.domain != null) {
                    this.listener = this.createNotationDeletionListener();
                    this.domain.addResourceSetListener(this.listener);
                }
            }
        }
    }

    public void dispose(IModel stoppingModel) {
        if (stoppingModel == this.model) {
            try {
                if (this.domain != null && this.listener != null) {
                    this.domain.removeResourceSetListener(this.listener);
                }
            }
            finally {
                this.pageManager = null;
                this.listener = null;
                this.domain = null;
                this.model = null;
            }
        }
    }

    private ResourceSetListener createNotationDeletionListener() {
        return new ResourceAdapter.Transactional(){

            protected void handleRootRemoved(Resource resource, EObject root) {
                if (NotationPageSnippet.this.model.getResources().contains(resource)) {
                    if (NotationPageSnippet.this.pageManager == null) {
                        try {
                            NotationPageSnippet.this.pageManager = ServiceUtilsForResourceSet.getInstance().getIPageManager((Object)NotationPageSnippet.this.domain.getResourceSet());
                        }
                        catch (ServiceException e) {
                            NotationPageSnippet.this.domain.removeResourceSetListener((ResourceSetListener)this);
                            return;
                        }
                    }
                    CoreExecutors.getUIExecutorService().execute(() -> {
                        if (NotationPageSnippet.this.pageManager.isOpen((Object)root)) {
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)NotationPageSnippet.this.domain, () -> NotationPageSnippet.this.pageManager.closeAllOpenedPages((Object)root));
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                }
            }
        };
    }
}

