/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.preferences;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.pluginexplorer.Plugin;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginEntry;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginsContentDialog;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginsContentSelectionValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceFieldEditor
extends StringButtonFieldEditor {
    public static final int MODE_FILE = 0;
    public static final int MODE_WORKSPACE = 1;
    public static final int MODE_PLUGIN = 2;
    protected String[] extensions;
    protected int mode;

    public ResourceFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.extensions = new String[]{"*.configuration"};
        this.mode = 0;
        this.setErrorMessage(JFaceResources.getString((String)"FileFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.createControl(parent);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    protected String changePressed() {
        switch (this.mode) {
            case 0: {
                return this.selectFile();
            }
            case 1: {
                return this.selectInWorkspace();
            }
            case 2: {
                return this.selectInPlugin();
            }
        }
        return this.selectFile();
    }

    private String selectFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setFilterExtensions(this.extensions);
        String value = this.getTextControl().getText();
        if (value != null && !value.isEmpty()) {
            dialog.setFileName(value);
        }
        if ((value = dialog.open()) != null && (value = value.trim()).length() > 0) {
            File f = new File(value);
            return f.getAbsolutePath();
        }
        return null;
    }

    private String selectInWorkspace() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Configuration Selection");
        dialog.setMessage("Select the custom configuration resource:");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0) {
                    return new Status(4, "org.eclipse.papyrus.infra.viewpoints.preferences", "No selected item!");
                }
                if (selection.length > 1) {
                    return new Status(4, "org.eclipse.papyrus.infra.viewpoints.preferences", "Only one item should be selected!");
                }
                if (!(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.papyrus.infra.viewpoints.preferences", "The selected item is not a configuration file!");
                }
                IFile file = (IFile)selection[0];
                if (!file.getName().endsWith(".configuration")) {
                    return new Status(4, "org.eclipse.papyrus.infra.viewpoints.preferences", "The selected item is not a configuration file!");
                }
                return new Status(0, "org.eclipse.papyrus.infra.viewpoints.preferences", "");
            }
        });
        int value = dialog.open();
        if (value != 0) {
            return null;
        }
        IFile file = (IFile)dialog.getFirstResult();
        return "platform:/resource/" + file.getProject().getName() + "/" + file.getProjectRelativePath().toString();
    }

    private String selectInPlugin() {
        PluginsContentDialog dialog = new PluginsContentDialog(this.getShell(), new PluginsContentSelectionValidator(){

            public boolean isValid(Plugin plugin) {
                return false;
            }

            public boolean isValid(PluginEntry entry) {
                return entry.getName().endsWith(".configuration");
            }
        }, "Viewpoints configuration selection", "Select a configuration resource (*.configuration):");
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        PluginEntry entry = (PluginEntry)dialog.getSelection();
        if (entry == null) {
            return null;
        }
        return entry.getLogicalPath();
    }
}

