/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.util.List;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.lifecycle.ShareableLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Container<E>
extends ShareableLifecycle
implements IContainer<E> {
    public Container() {
        this(false);
    }

    public Container(boolean shareable) {
        super(shareable);
    }

    @Override
    public boolean isEmpty() {
        if (!this.isActive()) {
            return true;
        }
        E[] elements = this.getElements();
        return elements == null || elements.length == 0;
    }

    @Override
    public void fireEvent(IEvent event) {
        if (event instanceof IContainerEvent && ((IContainerEvent)event).isEmpty()) {
            return;
        }
        super.fireEvent(event);
    }

    public void fireContainerEvent(E element, IContainerDelta.Kind kind) {
        this.fireEvent(this.newContainerEvent(element, kind));
    }

    public void fireElementAddedEvent(E element) {
        this.fireContainerEvent(element, IContainerDelta.Kind.ADDED);
    }

    public void fireElementRemovedEvent(E element) {
        this.fireContainerEvent(element, IContainerDelta.Kind.REMOVED);
    }

    public void fireContainerEvent(E[] elements, IContainerDelta.Kind kind) {
        ContainerEvent<E> event = new ContainerEvent<E>(this);
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            event.addDelta(element, kind);
            ++n2;
        }
        this.fireEvent(event);
    }

    public void fireElementsAddedEvent(E[] elements) {
        this.fireContainerEvent(elements, IContainerDelta.Kind.ADDED);
    }

    public void fireElementsRemovedEvent(E[] elements) {
        this.fireContainerEvent(elements, IContainerDelta.Kind.REMOVED);
    }

    public void fireContainerEvent(List<IContainerDelta<E>> deltas) {
        this.fireEvent(new ContainerEvent<E>(this, deltas));
    }

    protected SingleDeltaContainerEvent<E> newContainerEvent(E element, IContainerDelta.Kind kind) {
        return new SingleDeltaContainerEvent<E>(this, element, kind);
    }

    protected ContainerEvent<E> newContainerEvent() {
        return new ContainerEvent(this);
    }
}

