/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.tree;

import eu.fbk.tools.adapter.ui.views.tree.TreeObject;
import eu.fbk.tools.adapter.ui.views.tree.TreeRoot;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider,
Observer {
    private TreeObject invisibleRoot = null;
    private final List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();
    private final Hashtable<String, TreeObject> treeObjects = new Hashtable();

    protected TreeObject getInvisibleRoot() {
        return this.invisibleRoot;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.refresh();
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof TreeRoot) {
            if (this.invisibleRoot == null) {
                this.invisibleRoot = new TreeRoot();
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeObject) {
            return ((TreeObject)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof TreeObject) {
            return ((TreeObject)parent).hasChildren();
        }
        return false;
    }

    public TreeObject getElementById(String id) {
        return this.treeObjects.get(id);
    }

    public void addListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void update(Observable o, Object obj) {
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(new PropertyChangeEvent((Object)o, "MODEL_CHANGE", null, obj));
        }
    }

    protected void initialize() {
    }

    public synchronized void refresh() {
        if (this.invisibleRoot == null) {
            return;
        }
        this.invisibleRoot.clear();
        this.initialize();
        this.treeObjects.clear();
        this.loadAllElements(this.invisibleRoot);
    }

    private void loadAllElements(TreeObject treeObject) {
        if (treeObject == null) {
            return;
        }
        if (treeObject.hasChildren()) {
            this.treeObjects.put(treeObject.getId(), treeObject);
            Object[] objects = this.getChildren(treeObject);
            int i = 0;
            while (i < objects.length) {
                this.loadAllElements((TreeObject)objects[i]);
                ++i;
            }
        } else {
            this.treeObjects.put(treeObject.getId(), treeObject);
        }
    }
}

