/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.trace.behaviour;

import eu.fbk.tools.adapter.results.Assignment;
import eu.fbk.tools.adapter.results.Section;
import eu.fbk.tools.adapter.results.State;
import eu.fbk.tools.adapter.results.Trace;
import eu.fbk.tools.adapter.ui.views.trace.BaseTraceViewer;
import eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceTreeViewContentProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Display;

public class BehaviourTraceViewer
extends BaseTraceViewer {
    public static final String ID = "eu.fbk.tools.adapter.ui.views.trace.behaviour.BehaviourTraceViewer";

    public BehaviourTraceViewer() {
        super(new BehaviourTraceTreeViewContentProvider());
    }

    @Override
    protected void createColumns(Trace trace) {
        if (trace.getStates().isEmpty()) {
            return;
        }
        GridColumn columnPorts = new GridColumn(this.tableViewer, 0);
        columnPorts.setText("Ports");
        columnPorts.setWidth(200);
        columnPorts.setAlignment(16384);
        columnPorts.setTree(true);
        Hashtable<String, List> dataPorts = new Hashtable<String, List>();
        Hashtable<String, List> transitionPorts = new Hashtable<String, List>();
        for (State state : trace.getStates()) {
            GridColumnGroup columnGroup = new GridColumnGroup(this.tableViewer, 0);
            columnGroup.setText("Step " + state.getId() + (state.isStartLoop() ? " (Start Loop)" : ""));
            for (Section section : state.getSections()) {
                GridColumn column = new GridColumn(columnGroup, 0);
                column.setAlignment(0x1000000);
                if (section.getName().toLowerCase().trim().startsWith("state")) {
                    column.setText("State");
                    column.setWidth(90);
                    for (Assignment assignement : section.getAssignments()) {
                        if (!dataPorts.containsKey(assignement.getVariable())) {
                            dataPorts.put(assignement.getVariable(), new ArrayList());
                        }
                        List dataPortValues = (List)dataPorts.get(assignement.getVariable());
                        dataPortValues.add(assignement.getValue());
                    }
                    continue;
                }
                if (!section.getName().toLowerCase().trim().startsWith("input")) continue;
                column.setText("Transition");
                column.setWidth(90);
                for (Assignment assignement : section.getAssignments()) {
                    if (!transitionPorts.containsKey(assignement.getVariable())) {
                        transitionPorts.put(assignement.getVariable(), new ArrayList());
                    }
                    List transitionPortValues = (List)transitionPorts.get(assignement.getVariable());
                    transitionPortValues.add(assignement.getValue());
                }
            }
        }
        dataPorts.forEach((K, V) -> {
            if (this.showAllAssignments || !this.areAllValuesIdentical((List<String>)V)) {
                this.populatePortName((String)K);
            }
        });
        transitionPorts.forEach((K, V) -> {
            if (this.showAllAssignments || !this.areAllValuesIdentical((List<String>)V)) {
                this.populatePortName((String)K);
            }
        });
        int stateValueItemIndex = 1;
        int inputValueItemIndex = stateValueItemIndex + 1;
        int step = (dataPorts.size() > 0 ? 1 : 0) + (transitionPorts.size() > 0 ? 1 : 0);
        for (State state : trace.getStates()) {
            for (Section section : state.getSections()) {
                GridItem item;
                if (section.getName().toLowerCase().trim().startsWith("state")) {
                    for (Assignment assignement : section.getAssignments()) {
                        item = (GridItem)this.gridItems.get(assignement.getVariable());
                        if (item == null) continue;
                        item.setText(stateValueItemIndex, assignement.getValue());
                        if (stateValueItemIndex <= step || item.getText(stateValueItemIndex - step).equals(assignement.getValue())) continue;
                        item.setToolTipText(0, "The port value changes along the trace");
                        item.setForeground(0, Display.getCurrent().getSystemColor(4));
                        item.setForeground(stateValueItemIndex, Display.getCurrent().getSystemColor(1));
                        item.setBackground(stateValueItemIndex, Display.getCurrent().getSystemColor(4));
                    }
                    stateValueItemIndex += step;
                    continue;
                }
                if (!section.getName().toLowerCase().trim().startsWith("input")) continue;
                for (Assignment assignement : section.getAssignments()) {
                    item = (GridItem)this.gridItems.get(assignement.getVariable());
                    if (item == null) continue;
                    item.setText(inputValueItemIndex, assignement.getValue());
                    if (inputValueItemIndex > step && !item.getText(inputValueItemIndex - step).equals(assignement.getValue())) {
                        item.setToolTipText(0, "The port value changes along the trace");
                        item.setForeground(0, Display.getCurrent().getSystemColor(4));
                        item.setForeground(inputValueItemIndex, Display.getCurrent().getSystemColor(1));
                        item.setBackground(inputValueItemIndex, Display.getCurrent().getSystemColor(4));
                        continue;
                    }
                    item.setForeground(0, Display.getCurrent().getSystemColor(5));
                }
                inputValueItemIndex += step;
            }
        }
    }
}

