/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.behaviour;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.nuxmv.GenerateVMTModel;
import eu.fbk.tools.adapter.nuxmv.NuxmvFunction;
import eu.fbk.tools.adapter.ui.commands.behaviour.AbstractCheckModelCommand;
import eu.fbk.tools.adapter.ui.dialog.behaviour.VMTModelGenerationParametersDialog;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateVMTModelCommand
extends AbstractCheckModelCommand {
    private static final Logger logger = LoggerFactory.getLogger(GenerateVMTModelCommand.class);
    private GenerateVMTModel function;

    public GenerateVMTModelCommand() {
        super("Generate VMT model");
    }

    @Override
    protected boolean initialize() {
        this.function = new GenerateVMTModel();
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        String checkType = event.getParameter("check_type");
        if (checkType != null) {
            try {
                this.function.setCheckType(NuxmvFunction.CheckType.valueOf((String)checkType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid check type parameter value, can't execute the command.");
                logger.error("Invalid check type parameter value: " + checkType);
                return false;
            }
        }
        this.function.setFormula(event.getParameter("property"));
        String propertyIndex = event.getParameter("property_index");
        if (!StringUtils.isEmpty((CharSequence)propertyIndex)) {
            this.function.setPropertyIndex(Integer.valueOf(propertyIndex));
        }
        if (this.function.getCheckType() == null || this.function.getPropertyIndex() == null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    VMTModelGenerationParametersDialog dialog = new VMTModelGenerationParametersDialog(GenerateVMTModelCommand.this.activeShell, GenerateVMTModelCommand.this.function, GenerateVMTModelCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        GenerateVMTModelCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

