/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.core.utils;

import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.ErrorsDialogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class AnalysisResultUtil {
    private static final String ANALYSIS_CONTEXT_ELEMENT = "CHESS::Dependability::DependableComponent::AnalysisContextElement";
    private static final String ANALYSIS_VIEW = "CHESS::Core::CHESSViews::AnalysisView";
    private static final String DEPENDABILITY_ANALYSIS_VIEW = "CHESS::Core::CHESSViews::DependabilityAnalysisView";
    private static final String RESULTS_FILE_PATH = String.valueOf(File.separator) + "VerificationResults";
    public static final String PROPERTY = "property";
    public static final String CHECK_TYPE = "check_type";
    public static final String SELECTED_PROPERTIES = "selected_properties";
    public static final String SELECTED_COMPONENTS = "selected_components";
    private static AnalysisResultUtil packageUtilInstance;
    private final EntityUtil entityUtil = EntityUtil.getInstance();
    private final ErrorsDialogUtil errorsDialogUtil = ErrorsDialogUtil.getInstance();
    private final DialogUtil dialogUtil = DialogUtil.getInstance();

    public static AnalysisResultUtil getInstance() {
        if (packageUtilInstance == null) {
            packageUtilInstance = new AnalysisResultUtil();
        }
        return packageUtilInstance;
    }

    private <T> Collection<T> iterator2Collection(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            T item = iter.next();
            list.add(item);
        }
        return list;
    }

    public Package getDependabilityView() {
        UmlModel umlModel = UmlUtils.getUmlModel();
        TreeIterator allElements = umlModel.getResource().getAllContents();
        if (allElements != null) {
            Collection packages = EcoreUtil.getObjectsByType(this.iterator2Collection((Iterator)allElements), (EClassifier)UMLPackage.eINSTANCE.getPackage());
            for (Package p : packages) {
                if (p.getAppliedStereotype(DEPENDABILITY_ANALYSIS_VIEW) == null) continue;
                return p;
            }
        }
        this.errorsDialogUtil.showMessage_GenericError("Error: DependabilityAnalysisView not found!");
        return null;
    }

    public Package getDependabilityViewFromPackage(Package pkg) {
        Model model = pkg.getModel();
        EList modelPackages = model.getNestedPackages();
        Package analysisView = null;
        for (Package modelPackage : modelPackages) {
            if (modelPackage.getAppliedStereotype(ANALYSIS_VIEW) == null) continue;
            analysisView = modelPackage;
            break;
        }
        if (analysisView == null) {
            this.errorsDialogUtil.showMessage_GenericError("No <<AnalysisView>> view found. Cannot read or store analyses results.");
            return null;
        }
        modelPackages = analysisView.getNestedPackages();
        for (Package modelPackage : modelPackages) {
            if (modelPackage.getAppliedStereotype(DEPENDABILITY_ANALYSIS_VIEW) == null) continue;
            return modelPackage;
        }
        this.errorsDialogUtil.showMessage_GenericError("No <<DependabilityAnalysisView>> view found. Cannot read or store analyses results.");
        return null;
    }

    private Stereotype applyAnalysisContextElementStereotype(Component element) {
        return UMLUtils.applyStereotype((Element)element, (String)ANALYSIS_CONTEXT_ELEMENT);
    }

    public AnalysisContextElement getAnalysisContextElementFromUmlElement(Element element) {
        Stereotype appliedStereotype = element.getAppliedStereotype(ANALYSIS_CONTEXT_ELEMENT);
        return (AnalysisContextElement)element.getStereotypeApplication(appliedStereotype);
    }

    public String getPackageName(Package pkg) {
        String name = pkg.getQualifiedName();
        name = name.substring(name.indexOf("::") + 2);
        return name.replace("::", "_");
    }

    public boolean createOrUpdateAnalysisContext(final Analysis type, final EList<String> conditions, final String resultFilePath, final boolean storeResultFilePath, final Class rootComponent, final InstantiatedArchitectureConfiguration instantiatedArchitecture, AnalysisContextElement analysisContext) {
        Package activePackage = rootComponent.getNearestPackage();
        final Package dependabilityView = this.getDependabilityViewFromPackage(activePackage);
        if (dependabilityView == null) {
            return false;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dependabilityView);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                String componentPackageName = AnalysisResultUtil.this.getPackageName(rootComponent.getNearestPackage());
                Package dependabilityPackage = dependabilityView.getNestedPackage(componentPackageName, false, UMLPackage.eINSTANCE.getPackage(), true);
                EList packageableElements = dependabilityPackage.getPackagedElements();
                for (PackageableElement packageableElement : packageableElements) {
                    AnalysisContextElement resultElement;
                    if (packageableElement == null || !(packageableElement instanceof Component) || packageableElement.getAppliedStereotype(AnalysisResultUtil.ANALYSIS_CONTEXT_ELEMENT) == null || !(resultElement = AnalysisResultUtil.this.getAnalysisContextElementFromUmlElement((Element)packageableElement)).getType().equals((Object)type) || resultElement.getRoot() != rootComponent || !(AnalysisResultUtil.this.isEquals((EList<String>)resultElement.getConditions(), (EList<String>)conditions) & resultElement.getInstantiatedArchitecture() == instantiatedArchitecture)) continue;
                    resultElement.setDate(new Date().toString());
                    resultElement.setValid(true);
                    if (resultFilePath != null) {
                        if (storeResultFilePath) {
                            resultElement.setResult(resultFilePath);
                        } else {
                            try {
                                resultElement.setResult(new String(Files.readAllBytes(Paths.get(resultFilePath, new String[0]))));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    return;
                }
                int currAnalysisContextElement = AnalysisResultUtil.this.countAnalysisContextElements((EList<PackageableElement>)packageableElements, type) + 1;
                Component umlComponent = (Component)dependabilityPackage.createPackagedElement(String.valueOf(type.getName()) + "_" + currAnalysisContextElement, UMLPackage.eINSTANCE.getComponent());
                Stereotype appliedStereotype = AnalysisResultUtil.this.applyAnalysisContextElementStereotype(umlComponent);
                if (appliedStereotype == null) {
                    AnalysisResultUtil.this.errorsDialogUtil.showMessage_GenericError("Cannot apply the CHESS::Dependability::DependableComponent::AnalysisContextElement stereotype. Is the CHESS model up to date?");
                    return;
                }
                AnalysisContextElement resultElement = (AnalysisContextElement)umlComponent.getStereotypeApplication(appliedStereotype);
                if (resultElement != null) {
                    resultElement.setType(type);
                    resultElement.setDate(new Date().toString());
                    if (conditions != null) {
                        resultElement.getConditions().addAll((Collection)conditions);
                    }
                    if (instantiatedArchitecture != null) {
                        resultElement.setInstantiatedArchitecture(instantiatedArchitecture);
                    }
                    resultElement.setValid(true);
                    if (resultFilePath != null) {
                        if (storeResultFilePath) {
                            resultElement.setResult(resultFilePath);
                        } else {
                            try {
                                resultElement.setResult(new String(Files.readAllBytes(Paths.get(resultFilePath, new String[0]))));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    resultElement.setRoot(rootComponent);
                }
            }
        });
        return true;
    }

    protected int countAnalysisContextElements(EList<PackageableElement> packageableElements, Analysis type) {
        int numElements = 0;
        for (PackageableElement packageableElement : packageableElements) {
            AnalysisContextElement resultElement;
            if (packageableElement == null || !(packageableElement instanceof Component) || packageableElement.getAppliedStereotype(ANALYSIS_CONTEXT_ELEMENT) == null || !(resultElement = this.getAnalysisContextElementFromUmlElement((Element)packageableElement)).getType().equals((Object)type)) continue;
            ++numElements;
        }
        return numElements;
    }

    boolean isEquals(EList<String> eList, EList<String> conditions) {
        if (eList == null && conditions == null) {
            return true;
        }
        if (eList == null || conditions == null) {
            return false;
        }
        if (eList.size() != conditions.size()) {
            return false;
        }
        for (String s : conditions) {
            if (eList.contains((Object)s)) continue;
            return false;
        }
        return true;
    }

    private Package getPackageFromSelectedObject(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        Object selectedUmlElement = SelectionUtil.getInstance().getUmlSelectedObject(selection);
        if (selectedUmlElement instanceof Package) {
            return (Package)selectedUmlElement;
        }
        return null;
    }

    public Class getSystemComponentFromEvent(ExecutionEvent event) throws ExecutionException {
        Package pkg = this.getPackageFromSelectedObject(event);
        if (pkg == null || !this.entityUtil.isSystemViewPackage((Element)pkg)) {
            ExecutionException e = new ExecutionException("Please select a package from <<SystemView>>");
            this.dialogUtil.showMessage_ExceptionError((Exception)e);
            throw e;
        }
        Class systemComponent = EntityUtil.getInstance().getSystemComponent(pkg);
        if (systemComponent == null) {
            ExecutionException e = new ExecutionException("The package does not have a <<System>> block or it has more than one. Please check.");
            this.dialogUtil.showMessage_ExceptionError((Exception)e);
            throw e;
        }
        return systemComponent;
    }

    private String computeResultDir() {
        try {
            return String.valueOf(DirectoryUtil.getInstance().getCurrentProjectDir()) + RESULTS_FILE_PATH;
        }
        catch (Exception e) {
            this.dialogUtil.showMessage_ExceptionError(e);
            e.printStackTrace();
            return null;
        }
    }

    public String getResultDir() {
        String resultDir = this.computeResultDir();
        File directory = new File(resultDir);
        if (!directory.exists()) {
            return this.createResultDir(resultDir);
        }
        return resultDir;
    }

    private String createResultDir(String dirName) {
        block3: {
            try {
                File directory = new File(dirName);
                if (directory.mkdirs()) break block3;
                this.errorsDialogUtil.showMessage_GenericError("Cannot create results directory: " + dirName);
                return null;
            }
            catch (Exception e) {
                this.dialogUtil.showMessage_ExceptionError(e);
                e.printStackTrace();
                return null;
            }
        }
        return dirName;
    }

    public void showResult(String functionName, String fileName) {
        try {
            CommandBuilder computeFaultTree = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.ShowVVResultCommand");
            computeFaultTree.setParameter("function_name", functionName);
            computeFaultTree.setParameter("result_file", fileName);
            computeFaultTree.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<AnalysisContextElement> getAnalysisContexts(Class element, InstantiatedArchitectureConfiguration instantiatedArchitecture, Analysis analysisType, Model model) {
        ArrayList<AnalysisContextElement> result = new ArrayList<AnalysisContextElement>();
        for (Element elem : model.allOwnedElements()) {
            AnalysisContextElement contextAnalysis;
            Stereotype stereo = elem.getAppliedStereotype(ANALYSIS_CONTEXT_ELEMENT);
            if (stereo == null || !(contextAnalysis = (AnalysisContextElement)elem.getStereotypeApplication(stereo)).getType().equals((Object)analysisType) || !contextAnalysis.getRoot().equals(element) || contextAnalysis.getInstantiatedArchitecture() != instantiatedArchitecture) continue;
            result.add(contextAnalysis);
        }
        return result;
    }
}

