/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.AnnotationProcessor;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationCompilationParticipant;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationProblem;
import org.eclipse.pde.ds.internal.annotations.Debug;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.ProjectState;
import org.eclipse.pde.ds.internal.annotations.ValidationErrorLevel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentObject;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

class AnnotationVisitor
extends ASTVisitor {
    private static final String COMPONENT_ANNOTATION = DSAnnotationCompilationParticipant.COMPONENT_ANNOTATION;
    private static final String ACTIVATE_ANNOTATION = Activate.class.getName();
    private static final String MODIFIED_ANNOTATION = Modified.class.getName();
    private static final String DEACTIVATE_ANNOTATION = Deactivate.class.getName();
    private static final String REFERENCE_ANNOTATION = Reference.class.getName();
    private static final Pattern PID_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*");
    private static final String NAMESPACE_1_1 = "http://www.osgi.org/xmlns/scr/v1.1.0";
    private static final String NAMESPACE_1_2 = "http://www.osgi.org/xmlns/scr/v1.2.0";
    private static final String ATTRIBUTE_COMPONENT_CONFIGURATION_PID = "configuration-pid";
    private static final String ATTRIBUTE_REFERENCE_POLICY_OPTION = "policy-option";
    private static final String ATTRIBUTE_REFERENCE_UPDATED = "updated";
    private static final String VALUE_REFERENCE_POLICY_OPTION_RELUCTANT = "reluctant";
    private static final Set<String> PROPERTY_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(null, "String", "Long", "Double", "Float", "Integer", "Byte", "Character", "Boolean", "Short")));
    private static final Comparator<IDSReference> REF_NAME_COMPARATOR = new Comparator<IDSReference>(){

        @Override
        public int compare(IDSReference o1, IDSReference o2) {
            return o1.getReferenceName().compareTo(o2.getReferenceName());
        }
    };
    private static final Debug debug = AnnotationProcessor.debug;
    private final AnnotationProcessor processor;
    private final ProjectState state;
    private final ValidationErrorLevel errorLevel;
    private final ValidationErrorLevel missingUnbindMethodLevel;
    private final Map<String, String> dsKeys;
    private final Set<DSAnnotationProblem> problems;

    public AnnotationVisitor(AnnotationProcessor processor, ProjectState state, Map<String, String> dsKeys, Set<DSAnnotationProblem> problems) {
        this.processor = processor;
        this.state = state;
        this.errorLevel = state.getErrorLevel();
        this.missingUnbindMethodLevel = state.getMissingUnbindMethodLevel();
        this.dsKeys = dsKeys;
        this.problems = problems;
    }

    public boolean visit(TypeDeclaration type) {
        if (!Modifier.isPublic((int)type.getModifiers())) {
            if (this.errorLevel.isIgnore()) {
                return false;
            }
            Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)type);
            if (annotation != null) {
                this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_notPublic, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
            }
            return true;
        }
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)type);
        if (annotation != null) {
            boolean isInterface = false;
            boolean isAbstract = false;
            boolean isNested = false;
            boolean noDefaultConstructor = false;
            isInterface = type.isInterface();
            if (isInterface || (isAbstract = Modifier.isAbstract((int)type.getModifiers())) || (isNested = !type.isPackageMemberTypeDeclaration() && !this.isNestedPublicStatic((AbstractTypeDeclaration)type)) || (noDefaultConstructor = !this.hasDefaultConstructor(type))) {
                if (this.errorLevel != ValidationErrorLevel.ignore) {
                    if (isInterface) {
                        this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_interface, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (isAbstract) {
                        this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_abstract, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (isNested) {
                        this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_notTopLevel, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (noDefaultConstructor) {
                        this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_noDefaultConstructor, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else {
                        this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentImplementationClass, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    }
                }
            } else {
                ITypeBinding typeBinding = type.resolveBinding();
                if (typeBinding == null) {
                    if (debug.isDebugging()) {
                        debug.trace(String.format("Unable to resolve binding for type: %s", type));
                    }
                } else {
                    IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
                    if (annotationBinding == null) {
                        if (debug.isDebugging()) {
                            debug.trace(String.format("Unable to resolve binding for annotation: %s", annotation));
                        }
                    } else {
                        try {
                            this.processComponent(type, typeBinding, annotation, annotationBinding, this.problems);
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)node);
        if (annotation != null) {
            this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_enumeration, (Object)node.getName().getIdentifier()), node.getName().getIdentifier());
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)node);
        if (annotation != null) {
            this.reportProblem(annotation, null, this.problems, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_annotation, (Object)node.getName().getIdentifier()), node.getName().getIdentifier());
        }
        return true;
    }

    private Annotation findComponentAnnotation(AbstractTypeDeclaration type) {
        for (Object item : type.modifiers()) {
            if (!(item instanceof Annotation)) continue;
            Annotation annotation = (Annotation)item;
            IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
            if (annotationBinding == null) {
                if (!debug.isDebugging()) continue;
                debug.trace(String.format("Unable to resolve binding for annotation: %s", annotation));
                continue;
            }
            if (!COMPONENT_ANNOTATION.equals(annotationBinding.getAnnotationType().getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    private boolean isNestedPublicStatic(AbstractTypeDeclaration type) {
        AbstractTypeDeclaration parentType;
        ASTNode parent;
        if (Modifier.isStatic((int)type.getModifiers()) && (parent = type.getParent()) != null && (parent.getNodeType() == 55 || parent.getNodeType() == 81) && Modifier.isPublic((int)(parentType = (AbstractTypeDeclaration)parent).getModifiers())) {
            return parentType.isPackageMemberTypeDeclaration() || this.isNestedPublicStatic(parentType);
        }
        return false;
    }

    private boolean hasDefaultConstructor(TypeDeclaration type) {
        boolean hasConstructor = false;
        MethodDeclaration[] methodDeclarationArray = type.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (method.isConstructor()) {
                hasConstructor = true;
                if (Modifier.isPublic((int)method.getModifiers()) && method.parameters().isEmpty()) {
                    return true;
                }
            }
            ++n2;
        }
        return !hasConstructor;
    }

    private void processComponent(TypeDeclaration type, ITypeBinding typeBinding, Annotation annotation, IAnnotationBinding annotationBinding, Collection<DSAnnotationProblem> problems) throws CoreException {
        block15: {
            IFile oldFile;
            String implClass;
            HashMap<String, Object> params = new HashMap<String, Object>();
            IMemberValuePairBinding[] iMemberValuePairBindingArray = annotationBinding.getDeclaredMemberValuePairs();
            int n = iMemberValuePairBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
                params.put(pair.getName(), pair.getValue());
                ++n2;
            }
            String name = implClass = typeBinding.getBinaryName();
            Object value = params.get("name");
            if (value instanceof String) {
                name = (String)value;
                this.validateComponentName(annotation, name, problems);
            }
            IPath path = new Path(this.state.getPath()).append(name).addFileExtension("xml");
            String dsKey = path.toPortableString();
            this.dsKeys.put(implClass, dsKey);
            IProject project = typeBinding.getJavaElement().getJavaProject().getProject();
            IFile file = PDEProject.getBundleRelativeFile((IProject)project, (IPath)path);
            IPath filePath = file.getFullPath();
            this.processor.verifyOutputLocation(file);
            String oldPath = this.state.getModelFile(implClass);
            if (oldPath != null && !oldPath.equals(dsKey) && !file.exists() && (oldFile = PDEProject.getBundleRelativeFile((IProject)project, (IPath)Path.fromPortableString((String)oldPath))).exists()) {
                try {
                    oldFile.move(file.getFullPath(), true, true, null);
                }
                catch (CoreException e) {
                    Activator.log((IStatus)new Status(2, "org.eclipse.pde.ds.annotations", String.format("Unable to move model file from '%s' to '%s'.", oldPath, file.getFullPath()), (Throwable)e));
                }
            }
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.connect(filePath, LocationKind.IFILE, null);
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer(filePath, LocationKind.IFILE);
            if (buffer.isDirty()) {
                buffer.commit(null, true);
            }
            IDocument document = buffer.getDocument();
            final DSModel dsModel = new DSModel(document, true);
            dsModel.setUnderlyingResource((IResource)file);
            dsModel.setCharset("UTF-8");
            dsModel.load();
            IDocument fDoc = document;
            dsModel.addModelChangedListener((IModelChangedListener)new IModelTextChangeListener(fDoc){
                private final IDocument document;
                private boolean changed;
                {
                    this.document = iDocument;
                }

                public void modelChanged(IModelChangedEvent event) {
                    this.changed = true;
                }

                public TextEdit[] getTextOperations() {
                    if (!this.changed) {
                        return new TextEdit[0];
                    }
                    String text = dsModel.getContents();
                    ReplaceEdit edit = new ReplaceEdit(0, this.document.getLength(), text);
                    return new TextEdit[]{edit};
                }

                public String getReadableName(TextEdit edit) {
                    return null;
                }
            });
            try {
                this.processComponent((IDSModel)dsModel, type, typeBinding, annotation, annotationBinding, params, name, implClass, problems);
                TextEdit[] edits = dsModel.getLastTextChangeListener().getTextOperations();
                if (edits.length <= 0) break block15;
                if (debug.isDebugging()) {
                    debug.trace(String.format("Saving model: %s", file.getFullPath()));
                }
                final MultiTextEdit edit = new MultiTextEdit();
                edit.addChildren(edits);
                if (buffer.isSynchronizationContextRequested()) {
                    CoreException[] ex;
                    block16: {
                        final IDocument doc = document;
                        ex = new CoreException[1];
                        final CountDownLatch latch = new CountDownLatch(1);
                        bufferManager.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AnnotationVisitor.this.performEdit(doc, (TextEdit)edit);
                                }
                                catch (CoreException e) {
                                    ex[0] = e;
                                }
                                latch.countDown();
                            }
                        });
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            if (!debug.isDebugging()) break block16;
                            debug.trace("Interrupted while waiting for edits to complete on display thread.", e);
                        }
                    }
                    if (ex[0] != null) {
                        throw ex[0];
                    }
                } else {
                    this.performEdit(document, (TextEdit)edit);
                }
                buffer.commit(null, true);
            }
            finally {
                dsModel.dispose();
                bufferManager.disconnect(buffer.getLocation(), LocationKind.IFILE, null);
            }
        }
    }

    private void performEdit(IDocument document, TextEdit edit) throws CoreException {
        DocumentRewriteSession session = null;
        try {
            try {
                if (document instanceof IDocumentExtension4) {
                    session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                }
                LinkedModeModel.closeAllModels((IDocument)document);
                edit.apply(document);
            }
            catch (MalformedTreeException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Error applying changes to component model.", (Throwable)e));
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Error applying changes to component model.", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
            throw throwable;
        }
        if (session != null) {
            ((IDocumentExtension4)document).stopRewriteSession(session);
        }
    }

    private void processComponent(IDSModel model, TypeDeclaration type, ITypeBinding typeBinding, Annotation annotation, IAnnotationBinding annotationBinding, Map<String, ?> params, String name, String implClass, Collection<DSAnnotationProblem> problems) {
        IDSProperties propertiesElement;
        int firstPos;
        Object newPropertyType2;
        IDSProperty property22;
        IVariableBinding configPolicyBinding;
        ConfigurationPolicy configPolicyLiteral;
        String[] propertyFiles;
        String[] properties;
        AbstractCollection services;
        Object value = params.get("service");
        if (value instanceof Object[]) {
            Object[] elements = (Object[])value;
            services = new LinkedHashSet(elements.length);
            HashMap<String, Integer> serviceDuplicates = this.errorLevel.isIgnore() ? null : new HashMap<String, Integer>();
            int i = 0;
            while (i < elements.length) {
                ITypeBinding serviceType = (ITypeBinding)elements[i];
                String serviceName = serviceType.getBinaryName();
                if (!this.errorLevel.isIgnore()) {
                    if (serviceDuplicates.containsKey(serviceName)) {
                        this.reportProblem(annotation, "service", i, problems, Messages.AnnotationProcessor_duplicateServiceDeclaration, serviceName);
                        Integer pos = serviceDuplicates.put(serviceName, null);
                        if (pos != null) {
                            this.reportProblem(annotation, "service", (int)pos, problems, Messages.AnnotationProcessor_duplicateServiceDeclaration, serviceName);
                        }
                    } else {
                        serviceDuplicates.put(serviceName, i);
                    }
                }
                services.add(serviceName);
                this.validateComponentService(annotation, typeBinding, serviceType, i, problems);
                ++i;
            }
        } else {
            ITypeBinding[] serviceTypes = typeBinding.getInterfaces();
            services = new ArrayList(serviceTypes.length);
            int i = 0;
            while (i < serviceTypes.length) {
                services.add(serviceTypes[i].getBinaryName());
                ++i;
            }
        }
        String factory = null;
        value = params.get("factory");
        if (value instanceof String) {
            factory = (String)value;
            this.validateComponentFactory(annotation, factory, problems);
        }
        Boolean serviceFactory = null;
        value = params.get("servicefactory");
        if (value instanceof Boolean) {
            serviceFactory = (Boolean)value;
        }
        Boolean enabled = null;
        value = params.get("enabled");
        if (value instanceof Boolean) {
            enabled = (Boolean)value;
        }
        Boolean immediate = null;
        value = params.get("immediate");
        if (value instanceof Boolean) {
            immediate = (Boolean)value;
        }
        if ((value = params.get("property")) instanceof Object[]) {
            Object[] elements = (Object[])value;
            ArrayList<String> list = new ArrayList<String>(elements.length);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof String) {
                    list.add((String)elements[i]);
                }
                ++i;
            }
            properties = list.toArray(new String[list.size()]);
        } else {
            properties = new String[]{};
        }
        value = params.get("properties");
        if (value instanceof Object[]) {
            Object[] elements = (Object[])value;
            ArrayList<String> list = new ArrayList<String>(elements.length);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof String) {
                    list.add((String)elements[i]);
                }
                ++i;
            }
            propertyFiles = list.toArray(new String[list.size()]);
            this.validateComponentPropertyFiles(annotation, ((IType)typeBinding.getJavaElement()).getJavaProject().getProject(), propertyFiles, problems);
        } else {
            propertyFiles = new String[]{};
        }
        String configPolicy = null;
        value = params.get("configurationPolicy");
        if (value instanceof IVariableBinding && (configPolicyLiteral = ConfigurationPolicy.valueOf((String)(configPolicyBinding = (IVariableBinding)value).getName())) != null) {
            configPolicy = configPolicyLiteral.toString();
        }
        String configPid = null;
        value = params.get("configurationPid");
        if (value instanceof String) {
            configPid = (String)value;
            this.validateComponentConfigPID(annotation, configPid, problems);
        }
        IDSComponent component = model.getDSComponent();
        if (enabled == null) {
            this.removeAttribute((IDSObject)component, "enabled", "true");
        } else {
            component.setEnabled(enabled.booleanValue());
        }
        if (name == null) {
            this.removeAttribute((IDSObject)component, "name", null);
        } else {
            component.setAttributeName(name);
        }
        if (factory == null) {
            this.removeAttribute((IDSObject)component, "factory", null);
        } else {
            component.setFactory(factory);
        }
        if (immediate == null) {
            this.removeAttribute((IDSObject)component, "immediate", null);
        } else {
            component.setImmediate(immediate.booleanValue());
        }
        if (configPolicy == null) {
            this.removeAttribute((IDSObject)component, "configuration-policy", "optional");
        } else {
            component.setConfigurationPolicy(configPolicy);
        }
        IDSDocumentFactory dsFactory = model.getFactory();
        IDSProperty[] propElements = component.getPropertyElements();
        if (properties.length == 0) {
            this.removeChildren((IDSObject)component, Arrays.asList(propElements));
        } else {
            Object propertyName;
            int colon;
            LinkedHashMap<IDSProperty[], IDSProperty> map = new LinkedHashMap<IDSProperty[], IDSProperty>(properties.length);
            int i = 0;
            while (i < properties.length) {
                String propertyType;
                String propertyStr = properties[i];
                String[] pair = propertyStr.split("=", 2);
                colon = pair[0].indexOf(58);
                if (colon == -1) {
                    propertyName = pair[0];
                    propertyType = null;
                } else {
                    propertyName = pair[0].substring(0, colon);
                    propertyType = pair[0].substring(colon + 1);
                }
                String propertyValue = pair.length > 1 ? pair[1].trim() : null;
                IDSProperty property = (IDSProperty)map.get(propertyName);
                if (property == null) {
                    property = dsFactory.createProperty();
                    map.put((IDSProperty[])propertyName, property);
                    property.setPropertyName((String)propertyName);
                    if (propertyType == null) {
                        this.removeAttribute((IDSObject)property, "type", null);
                    } else {
                        property.setPropertyType(propertyType);
                    }
                    property.setPropertyValue(propertyValue);
                    this.validateComponentProperty(annotation, (String)propertyName, propertyType, propertyValue, i, problems);
                } else {
                    String content = property.getPropertyElemBody();
                    if (content == null) {
                        content = property.getPropertyValue();
                        property.setPropertyElemBody(content);
                        property.setPropertyValue(null);
                    }
                    if (!this.errorLevel.isIgnore()) {
                        String actual;
                        String expected = property.getPropertyType() == null || property.getPropertyType().length() == 0 || "String".equals(property.getPropertyType()) ? Messages.AnnotationProcessor_stringOrEmpty : property.getPropertyType();
                        String string = actual = propertyType == null || "String".equals(propertyType) ? Messages.AnnotationProcessor_stringOrEmpty : propertyType;
                        if (!actual.equals(expected)) {
                            this.reportProblem(annotation, "property", i, problems, NLS.bind((String)Messages.AnnotationProcessor_inconsistentComponentPropertyType, (Object)actual, (Object)expected), actual);
                        } else {
                            this.validateComponentProperty(annotation, (String)propertyName, propertyType, propertyValue, i, problems);
                        }
                    }
                    if (propertyValue != null) {
                        property.setPropertyElemBody(String.valueOf(content) + "\n" + pair[1]);
                    }
                }
                ++i;
            }
            HashMap<String, IDSProperty> propMap = new HashMap<String, IDSProperty>(propElements.length);
            propertyName = propElements;
            colon = propElements.length;
            int pair = 0;
            while (pair < colon) {
                IDSProperty propElement = propertyName[pair];
                propMap.put(propElement.getPropertyName(), propElement);
                ++pair;
            }
            ArrayList propList = new ArrayList(map.values());
            ListIterator i2 = propList.listIterator();
            while (i2.hasNext()) {
                String newContent;
                IDSProperty newProperty = (IDSProperty)i2.next();
                property22 = (IDSProperty)propMap.remove(newProperty.getPropertyName());
                if (property22 == null) continue;
                i2.set(property22);
                newPropertyType2 = newProperty.getPropertyType();
                if (newPropertyType2 != null || !"String".equals(property22.getPropertyType())) {
                    property22.setPropertyType((String)newPropertyType2);
                }
                if ((newContent = newProperty.getPropertyElemBody()) == null) {
                    property22.setPropertyValue(newProperty.getPropertyValue());
                    IDocumentTextNode textNode = property22.getTextNode();
                    if (textNode == null) continue;
                    property22.removeTextNode();
                    if (!property22.isInTheModel() || !property22.isEditable()) continue;
                    model.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)model, 2, new Object[]{textNode}, null));
                    continue;
                }
                this.removeAttribute((IDSObject)property22, "value", null);
                String content = property22.getPropertyElemBody();
                if (content != null && newContent.equals(this.normalizePropertyElemBody(content))) continue;
                property22.setPropertyElemBody(newContent);
            }
            firstPos = propElements.length == 0 ? 0 : component.indexOf((IDocumentElementNode)propElements[0]);
            this.removeChildren((IDSObject)component, propMap.values());
            this.addOrMoveChildren((IDSObject)component, propList, firstPos);
        }
        IDSProperty propFileElements = component.getPropertiesElements();
        if (propertyFiles.length == 0) {
            this.removeChildren((IDSObject)component, Arrays.asList(propFileElements));
        } else {
            HashMap<String, IDSProperties> propFileMap = new HashMap<String, IDSProperties>(((IDSProperties[])propFileElements).length);
            property22 = propFileElements;
            int newProperty = ((IDSProperties[])property22).length;
            firstPos = 0;
            while (firstPos < newProperty) {
                IDSProperties propFileElement = property22[firstPos];
                propFileMap.put(propFileElement.getEntry(), propFileElement);
                ++firstPos;
            }
            ArrayList<IDSProperties> propFileList = new ArrayList<IDSProperties>(propertyFiles.length);
            newPropertyType2 = propertyFiles;
            int property22 = propertyFiles.length;
            newProperty = 0;
            while (newProperty < property22) {
                String propertyFile = newPropertyType2[newProperty];
                propertiesElement = (IDSProperties)propFileMap.remove(propertyFile);
                if (propertiesElement == null) {
                    propertiesElement = dsFactory.createProperties();
                    propertiesElement.setInTheModel(false);
                    propertiesElement.setEntry(propertyFile);
                }
                propFileList.add(propertiesElement);
                ++newProperty;
            }
            firstPos = ((IDSProperties[])propFileElements).length == 0 ? ((propElements = component.getPropertyElements()).length == 0 ? 0 : component.indexOf((IDocumentElementNode)propElements[propElements.length - 1]) + 1) : component.indexOf((IDocumentElementNode)propFileElements[0]);
            this.removeChildren((IDSObject)component, propFileMap.values());
            this.addOrMoveChildren((IDSObject)component, propFileList, firstPos);
        }
        IDSService service = component.getService();
        if (services.isEmpty()) {
            if (service != null) {
                component.removeService(service);
            }
        } else {
            if (service == null) {
                service = dsFactory.createService();
                int firstPos2 = Math.max(0, this.indexOfLastPropertyOrProperties(component));
                component.addChildNode((IDocumentElementNode)service, firstPos2, true);
            }
            IDSProperties provides = service.getProvidedServices();
            HashMap<String, IDSProvide> provideMap = new HashMap<String, IDSProvide>(((IDSProvide[])provides).length);
            propertiesElement = provides;
            int newPropertyType2 = ((IDSProvide[])propertiesElement).length;
            int property22 = 0;
            while (property22 < newPropertyType2) {
                IDSProvide provide = propertiesElement[property22];
                provideMap.put(provide.getInterface(), provide);
                ++property22;
            }
            ArrayList<IDSProvide> provideList = new ArrayList<IDSProvide>(services.size());
            for (String serviceName : services) {
                IDSProvide provide = (IDSProvide)provideMap.remove(serviceName);
                if (provide == null) {
                    provide = dsFactory.createProvide();
                    provide.setInterface(serviceName);
                }
                provideList.add(provide);
            }
            int firstPos3 = ((IDSProperties)provides).length == 0 ? -1 : service.indexOf((IDocumentElementNode)provides[0]);
            this.removeChildren((IDSObject)service, provideMap.values());
            this.addOrMoveChildren((IDSObject)service, provideList, firstPos3);
            if (serviceFactory == null) {
                this.removeAttribute((IDSObject)service, "servicefactory", "false");
            } else {
                service.setServiceFactory(serviceFactory.booleanValue());
            }
        }
        boolean requiresV12 = false;
        String activate = null;
        Annotation activateAnnotation = null;
        String deactivate = null;
        Annotation deactivateAnnotation = null;
        String modified = null;
        Annotation modifiedAnnotation = null;
        ArrayList<IDSReference> references = new ArrayList<IDSReference>();
        HashMap<String, Annotation> referenceNames = new HashMap<String, Annotation>();
        IDSReference[] refElements = component.getReferences();
        HashMap<String, IDSReference> refMap = new HashMap<String, IDSReference>(refElements.length);
        IDSReference[] iDSReferenceArray = refElements;
        int n = refElements.length;
        int n2 = 0;
        while (n2 < n) {
            IDSReference refElement = iDSReferenceArray[n2];
            refMap.put(refElement.getReferenceBind(), refElement);
            ++n2;
        }
        iDSReferenceArray = type.getMethods();
        n = iDSReferenceArray.length;
        n2 = 0;
        while (n2 < n) {
            IDSReference method = iDSReferenceArray[n2];
            for (Object modifier : method.modifiers()) {
                if (!(modifier instanceof Annotation)) continue;
                Annotation methodAnnotation = (Annotation)modifier;
                IAnnotationBinding methodAnnotationBinding = methodAnnotation.resolveAnnotationBinding();
                if (methodAnnotationBinding == null) {
                    if (!debug.isDebugging()) continue;
                    debug.trace(String.format("Unable to resolve binding for annotation: %s", methodAnnotation));
                    continue;
                }
                String annotationName = methodAnnotationBinding.getAnnotationType().getQualifiedName();
                if (ACTIVATE_ANNOTATION.equals(annotationName)) {
                    if (activate == null) {
                        activate = method.getName().getIdentifier();
                        activateAnnotation = methodAnnotation;
                        this.validateLifeCycleMethod(methodAnnotation, "activate", (MethodDeclaration)method, problems);
                        continue;
                    }
                    if (this.errorLevel.isIgnore()) continue;
                    this.reportProblem(methodAnnotation, null, problems, Messages.AnnotationProcessor_duplicateActivateMethod, method.getName().getIdentifier());
                    if (activateAnnotation == null) continue;
                    this.reportProblem(activateAnnotation, null, problems, Messages.AnnotationProcessor_duplicateActivateMethod, activate);
                    activateAnnotation = null;
                    continue;
                }
                if (DEACTIVATE_ANNOTATION.equals(annotationName)) {
                    if (deactivate == null) {
                        deactivate = method.getName().getIdentifier();
                        deactivateAnnotation = methodAnnotation;
                        this.validateLifeCycleMethod(methodAnnotation, "deactivate", (MethodDeclaration)method, problems);
                        continue;
                    }
                    if (this.errorLevel.isIgnore()) continue;
                    this.reportProblem(methodAnnotation, null, problems, Messages.AnnotationProcessor_duplicateDeactivateMethod, method.getName().getIdentifier());
                    if (deactivateAnnotation == null) continue;
                    this.reportProblem(deactivateAnnotation, null, problems, Messages.AnnotationProcessor_duplicateDeactivateMethod, deactivate);
                    deactivateAnnotation = null;
                    continue;
                }
                if (MODIFIED_ANNOTATION.equals(annotationName)) {
                    if (modified == null) {
                        modified = method.getName().getIdentifier();
                        modifiedAnnotation = methodAnnotation;
                        this.validateLifeCycleMethod(methodAnnotation, "modified", (MethodDeclaration)method, problems);
                        continue;
                    }
                    if (this.errorLevel.isIgnore()) continue;
                    this.reportProblem(methodAnnotation, null, problems, Messages.AnnotationProcessor_duplicateModifiedMethod, method.getName().getIdentifier());
                    if (modifiedAnnotation == null) continue;
                    this.reportProblem(modifiedAnnotation, null, problems, Messages.AnnotationProcessor_duplicateModifiedMethod, modified);
                    modifiedAnnotation = null;
                    continue;
                }
                if (!REFERENCE_ANNOTATION.equals(annotationName)) continue;
                IMethodBinding methodBinding = method.resolveBinding();
                if (methodBinding == null) {
                    if (!debug.isDebugging()) continue;
                    debug.trace(String.format("Unable to resolve binding for method: %s", method));
                    continue;
                }
                requiresV12 |= this.processReference((MethodDeclaration)method, methodBinding, methodAnnotation, methodAnnotationBinding, refMap, dsFactory, references, referenceNames, problems);
            }
            ++n2;
        }
        if (activate == null) {
            if (!"activate".equals(component.getActivateMethod()) || !this.hasLifeCycleMethod(typeBinding, "activate")) {
                this.removeAttribute((IDSObject)component, "activate", null);
            }
        } else {
            component.setActivateMethod(activate);
        }
        if (deactivate == null) {
            if (!"deactivate".equals(component.getDeactivateMethod()) || !this.hasLifeCycleMethod(typeBinding, "deactivate")) {
                this.removeAttribute((IDSObject)component, "deactivate", null);
            }
        } else {
            component.setDeactivateMethod(deactivate);
        }
        if (modified == null) {
            this.removeAttribute((IDSObject)component, "modified", null);
        } else {
            component.setModifiedeMethod(modified);
        }
        if (configPid == null) {
            this.removeAttribute((IDSObject)component, ATTRIBUTE_COMPONENT_CONFIGURATION_PID, null);
        } else {
            component.setXMLAttribute(ATTRIBUTE_COMPONENT_CONFIGURATION_PID, configPid);
            requiresV12 = true;
        }
        if (references.isEmpty()) {
            this.removeChildren((IDSObject)component, Arrays.asList(refElements));
        } else {
            Collections.sort(references, REF_NAME_COMPARATOR);
            int firstPos4 = refElements.length == 0 ? ((service = component.getService()) == null ? Math.max(0, this.indexOfLastPropertyOrProperties(component)) : component.indexOf((IDocumentElementNode)service) + 1) : component.indexOf((IDocumentElementNode)refElements[0]);
            this.removeChildren((IDSObject)component, refMap.values());
            this.addOrMoveChildren((IDSObject)component, references, firstPos4);
        }
        IDSImplementation impl = component.getImplementation();
        if (impl == null) {
            impl = dsFactory.createImplementation();
            component.setImplementation(impl);
        }
        impl.setClassName(implClass);
        String xmlns = NAMESPACE_1_1;
        value = params.get("xmlns");
        if (value instanceof String) {
            xmlns = (String)value;
            this.validateComponentXMLNS(annotation, xmlns, requiresV12, problems);
        } else if (requiresV12) {
            xmlns = NAMESPACE_1_2;
        }
        component.setNamespace(xmlns);
    }

    private void removeChildren(IDSObject parent, Collection<? extends IDocumentElementNode> children) {
        for (IDocumentElementNode iDocumentElementNode : children) {
            parent.removeChildNode(iDocumentElementNode, true);
        }
    }

    private void removeAttribute(IDSObject obj, String name, String defaultValue) {
        IDocumentAttributeNode attrNode = obj.getDocumentAttribute(name);
        if (attrNode != null) {
            String value = attrNode.getAttributeValue();
            if (value != null && value.equals(defaultValue)) {
                return;
            }
            obj.removeDocumentAttribute(attrNode);
            if (obj.isInTheModel() && obj.isEditable()) {
                obj.getModel().fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)obj.getModel(), 2, new Object[]{attrNode}, null));
            }
        }
    }

    private void addOrMoveChildren(IDSObject parent, List<? extends IDSObject> children, int firstPos) {
        int i = 0;
        int n = children.size();
        while (i < n) {
            IDSObject child = children.get(i);
            if (child.isInTheModel()) {
                int pos = parent.indexOf((IDocumentElementNode)child);
                if (i == 0) {
                    if (firstPos < pos) {
                        this.moveChildNode((IDocumentObject)parent, (IDocumentElementNode)child, firstPos - pos, true);
                    }
                } else {
                    int prevPos = parent.indexOf((IDocumentElementNode)children.get(i - 1));
                    if (prevPos > pos) {
                        this.moveChildNode((IDocumentObject)parent, (IDocumentElementNode)child, prevPos - pos, true);
                    }
                }
            } else if (i == 0) {
                if (firstPos == -1) {
                    parent.addChildNode((IDocumentElementNode)child, true);
                } else {
                    parent.addChildNode((IDocumentElementNode)child, firstPos, true);
                }
            } else {
                parent.addChildNode((IDocumentElementNode)child, parent.indexOf((IDocumentElementNode)children.get(i - 1)) + 1, true);
            }
            ++i;
        }
    }

    private void moveChildNode(IDocumentObject obj, IDocumentElementNode node, int newRelativeIndex, boolean fireEvent) {
        if (newRelativeIndex == 1 || newRelativeIndex == -1) {
            obj.moveChildNode(node, newRelativeIndex, fireEvent);
            return;
        }
        int currentIndex = obj.indexOf(node);
        if (currentIndex == -1) {
            return;
        }
        int newIndex = newRelativeIndex + currentIndex;
        if (newIndex < 0 || newIndex >= obj.getChildCount()) {
            return;
        }
        obj.removeChildNode(node, fireEvent);
        IDocumentElementNode clone = this.clone(obj, node);
        obj.addChildNode(clone, newIndex, fireEvent);
    }

    private IDocumentElementNode clone(IDocumentObject obj, IDocumentElementNode node) {
        IDocumentElementNode clone;
        block4: {
            clone = null;
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(node);
                out.flush();
                out.close();
                byte[] bytes = bout.toByteArray();
                ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
                ObjectInputStream in = new ObjectInputStream(bin);
                clone = (IDocumentElementNode)in.readObject();
                in.close();
                clone.reconnect((IDocumentElementNode)obj, obj.getSharedModel());
            }
            catch (IOException e) {
                if (debug.isDebugging()) {
                    debug.trace("Error cloning element.", e);
                }
            }
            catch (ClassNotFoundException e) {
                if (!debug.isDebugging()) break block4;
                debug.trace("Error cloning element.", e);
            }
        }
        return clone;
    }

    private int indexOfLastPropertyOrProperties(IDSComponent component) {
        int lastPos;
        int pos = -1;
        IDSProperty[] propElements = component.getPropertyElements();
        IDSProperties[] propFileElements = component.getPropertiesElements();
        if (propElements.length > 0) {
            pos = component.indexOf((IDocumentElementNode)propElements[propElements.length - 1]) + 1;
        }
        if (propFileElements.length > 0 && (lastPos = component.indexOf((IDocumentElementNode)propFileElements[propFileElements.length - 1]) + 1) > pos) {
            pos = lastPos;
        }
        return pos;
    }

    private String normalizePropertyElemBody(String content) {
        StringBuilder buf;
        block14: {
            buf = new StringBuilder(content.length());
            BufferedReader reader = new BufferedReader(new StringReader(content));
            try {
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String trimmed = line.trim();
                        if (trimmed.length() == 0) continue;
                        if (buf.length() > 0) {
                            buf.append('\n');
                        }
                        buf.append(trimmed);
                    }
                }
                catch (IOException e) {
                    if (debug.isDebugging()) {
                        debug.trace("Error reading property element body.", e);
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return buf.toString();
    }

    private void validateComponentName(Annotation annotation, String name, Collection<DSAnnotationProblem> problems) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(name).matches()) {
            this.reportProblem(annotation, "name", problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentName, (Object)name), name);
        }
    }

    private void validateComponentService(Annotation annotation, ITypeBinding componentType, ITypeBinding serviceType, int index, Collection<DSAnnotationProblem> problems) {
        if (!this.errorLevel.isIgnore() && !componentType.isAssignmentCompatible(serviceType)) {
            this.reportProblem(annotation, "service", problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentService, (Object)serviceType.getName()), serviceType.getName());
        }
    }

    private void validateComponentFactory(Annotation annotation, String factory, Collection<DSAnnotationProblem> problems) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(factory).matches()) {
            this.reportProblem(annotation, "factory", problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentFactoryName, (Object)factory), factory);
        }
    }

    private void validateComponentProperty(Annotation annotation, String name, String type, String value, int index, Collection<DSAnnotationProblem> problems) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        if (PROPERTY_TYPES.contains(type)) {
            if (name == null || name.trim().length() == 0) {
                this.reportProblem(annotation, "property", index, problems, Messages.AnnotationProcessor_invalidComponentProperty_nameRequired, name);
            }
            if (value == null) {
                this.reportProblem(annotation, "property", index, problems, Messages.AnnotationProcessor_invalidComponentProperty_valueRequired, name);
            } else {
                try {
                    if ("Long".equals(type)) {
                        Long.valueOf(value);
                    } else if ("Double".equals(type)) {
                        Double.valueOf(value);
                    } else if ("Float".equals(type)) {
                        Float.valueOf(value);
                    } else if ("Integer".equals(type) || "Character".equals(type)) {
                        Integer.valueOf(value);
                    } else if ("Byte".equals(type)) {
                        Byte.valueOf(value);
                    } else if ("Short".equals(type)) {
                        Short.valueOf(value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.reportProblem(annotation, "property", index, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyValue, (Object)type, (Object)value), String.valueOf(value));
                }
            }
        } else {
            this.reportProblem(annotation, "property", index, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyType, (Object)type), String.valueOf(type));
        }
    }

    private void validateComponentPropertyFiles(Annotation annotation, IProject project, String[] files, Collection<DSAnnotationProblem> problems) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            IFile wsFile = PDEProject.getBundleRelativeFile((IProject)project, (IPath)new Path(file));
            if (!wsFile.exists()) {
                this.reportProblem(annotation, "properties", i, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyFile, (Object)file), file);
            }
            ++i;
        }
    }

    private void validateComponentXMLNS(Annotation annotation, String xmlns, boolean requiresV12, Collection<DSAnnotationProblem> problems) {
        if (!(this.errorLevel.isIgnore() || !requiresV12 && NAMESPACE_1_1.equals(xmlns) || NAMESPACE_1_2.equals(xmlns))) {
            this.reportProblem(annotation, "xmlns", problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentDescriptorNamespace, (Object)xmlns), xmlns);
        }
    }

    private void validateComponentConfigPID(Annotation annotation, String configPid, Collection<DSAnnotationProblem> problems) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(configPid).matches()) {
            this.reportProblem(annotation, "configurationPid", problems, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentConfigurationPid, (Object)configPid), configPid);
        }
    }

    private void validateLifeCycleMethod(Annotation annotation, String methodName, MethodDeclaration method, Collection<DSAnnotationProblem> problems) {
        ITypeBinding[] paramTypeBindings;
        if (this.errorLevel.isIgnore()) {
            return;
        }
        IMethodBinding methodBinding = method.resolveBinding();
        if (methodBinding == null) {
            if (debug.isDebugging()) {
                debug.trace(String.format("Unable to resolve binding for method: %s", method));
            }
            return;
        }
        String returnTypeName = methodBinding.getReturnType().getName();
        if (!Void.TYPE.getName().equals(returnTypeName)) {
            this.reportProblem(annotation, methodName, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidLifeCycleMethodReturnType, (Object)methodName, (Object)returnTypeName), returnTypeName);
        }
        if ((paramTypeBindings = methodBinding.getParameterTypes()).length == 0) {
            return;
        }
        boolean hasMap = false;
        boolean hasCompCtx = false;
        boolean hasBundleCtx = false;
        boolean hasInt = false;
        ITypeBinding[] iTypeBindingArray = paramTypeBindings;
        int n = paramTypeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding paramTypeBinding = iTypeBindingArray[n2];
            String paramTypeName = paramTypeBinding.getErasure().getQualifiedName();
            boolean isDuplicate = false;
            if (Map.class.getName().equals(paramTypeName)) {
                if (hasMap) {
                    isDuplicate = true;
                } else {
                    hasMap = true;
                }
            } else if (ComponentContext.class.getName().equals(paramTypeName)) {
                if (hasCompCtx) {
                    isDuplicate = true;
                } else {
                    hasCompCtx = true;
                }
            } else if (BundleContext.class.getName().equals(paramTypeName)) {
                if (hasBundleCtx) {
                    isDuplicate = true;
                } else {
                    hasBundleCtx = true;
                }
            } else if ("deactivate".equals(methodName) && (Integer.class.getName().equals(paramTypeName) || Integer.TYPE.getName().equals(paramTypeName))) {
                if (hasInt) {
                    isDuplicate = true;
                } else {
                    hasInt = true;
                }
            } else {
                this.reportProblem(annotation, methodName, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidLifeCycleMethodParameterType, (Object)methodName, (Object)paramTypeName), paramTypeName);
            }
            if (isDuplicate) {
                this.reportProblem(annotation, methodName, problems, NLS.bind((String)Messages.AnnotationProcessor_duplicateLifeCycleMethodParameterType, (Object)methodName, (Object)paramTypeName), paramTypeName);
            }
            ++n2;
        }
    }

    private boolean hasLifeCycleMethod(ITypeBinding componentClass, String methodName) {
        IMethodBinding[] iMethodBindingArray = componentClass.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            if (methodName.equals(methodBinding.getName()) && Void.TYPE.getName().equals(methodBinding.getReturnType().getName())) {
                ITypeBinding[] paramTypeBindings = methodBinding.getParameterTypes();
                boolean hasMap = false;
                boolean hasCompCtx = false;
                boolean hasBundleCtx = false;
                boolean hasInt = false;
                boolean isInvalid = false;
                ITypeBinding[] iTypeBindingArray = paramTypeBindings;
                int n3 = paramTypeBindings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding paramTypeBinding = iTypeBindingArray[n4];
                    String paramTypeName = paramTypeBinding.getErasure().getQualifiedName();
                    if (Map.class.getName().equals(paramTypeName)) {
                        if (hasMap) {
                            isInvalid = true;
                        } else {
                            hasMap = true;
                        }
                    } else if (ComponentContext.class.getName().equals(paramTypeName)) {
                        if (hasCompCtx) {
                            isInvalid = true;
                        } else {
                            hasCompCtx = true;
                        }
                    } else if (BundleContext.class.getName().equals(paramTypeName)) {
                        if (hasBundleCtx) {
                            isInvalid = true;
                        } else {
                            hasBundleCtx = true;
                        }
                    } else if ("deactivate".equals(methodName) && (Integer.class.getName().equals(paramTypeName) || Integer.TYPE.getName().equals(paramTypeName))) {
                        if (hasInt) {
                            isInvalid = true;
                        } else {
                            hasInt = true;
                        }
                    } else {
                        isInvalid = true;
                    }
                    if (isInvalid) break;
                    ++n4;
                }
                if (!isInvalid) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean processReference(MethodDeclaration method, IMethodBinding methodBinding, Annotation annotation, IAnnotationBinding annotationBinding, Map<String, IDSReference> refMap, IDSDocumentFactory factory, Collection<IDSReference> collector, Map<String, Annotation> names, Collection<DSAnnotationProblem> problems) {
        String updated;
        IVariableBinding policyOptionBinding;
        ReferencePolicyOption policyOptionLiteral;
        IMethodBinding unbindMethod;
        String unbind;
        IVariableBinding policyBinding;
        ReferencePolicy policyLiteral;
        IVariableBinding cardinalityBinding;
        ReferenceCardinality cardinalityLiteral;
        ITypeBinding[] typeArgs;
        Object serviceType;
        HashMap<String, Object> params = new HashMap<String, Object>();
        IMemberValuePairBinding[] iMemberValuePairBindingArray = annotationBinding.getDeclaredMemberValuePairs();
        int n = iMemberValuePairBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
            params.put(pair.getName(), pair.getValue());
            ++n2;
        }
        ITypeBinding[] argTypes = methodBinding.getParameterTypes();
        Object value = params.get("service");
        if (value instanceof ITypeBinding) {
            serviceType = (ITypeBinding)value;
            if (!(this.errorLevel.isIgnore() || argTypes.length <= 0 || ServiceReference.class.getName().equals(argTypes[0].getErasure().getQualifiedName()) && ((typeArgs = argTypes[0].getTypeArguments()).length == 0 || serviceType.isAssignmentCompatible(typeArgs[0])) || serviceType.isAssignmentCompatible(argTypes[0]))) {
                this.reportProblem(annotation, "service", problems, NLS.bind((String)Messages.AnnotationProcessor_invalidReferenceService, (Object)argTypes[0].getName(), (Object)serviceType.getName()), serviceType.getName());
            }
        } else {
            serviceType = argTypes.length > 0 ? (ServiceReference.class.getName().equals(argTypes[0].getErasure().getQualifiedName()) ? ((typeArgs = argTypes[0].getTypeArguments()).length > 0 ? typeArgs[0] : null) : (argTypes[0].isPrimitive() ? this.getObjectType(method.getAST(), argTypes[0]) : argTypes[0])) : null;
        }
        if (serviceType == null) {
            this.reportProblem(annotation, null, problems, Messages.AnnotationProcessor_invalidReferenceServiceUnknown, new String[0]);
            serviceType = method.getAST().resolveWellKnownType(Object.class.getName());
        }
        this.validateReferenceBindMethod(annotation, (ITypeBinding)serviceType, methodBinding, problems);
        String service = serviceType == null ? null : serviceType.getBinaryName();
        String methodName = methodBinding.getName();
        value = params.get("name");
        String name = value instanceof String ? (String)value : (methodName.startsWith("bind") ? methodName.substring("bind".length()) : (methodName.startsWith("set") ? methodName.substring("set".length()) : (methodName.startsWith("add") ? methodName.substring("add".length()) : methodName)));
        if (!this.errorLevel.isIgnore()) {
            if (names.containsKey(name)) {
                this.reportProblem(annotation, "name", problems, NLS.bind((String)Messages.AnnotationProcessor_duplicateReferenceName, (Object)name), name);
                Annotation duplicate = names.put(name, null);
                if (duplicate != null) {
                    this.reportProblem(duplicate, "name", problems, NLS.bind((String)Messages.AnnotationProcessor_duplicateReferenceName, (Object)name), name);
                }
            } else {
                names.put(name, annotation);
            }
        }
        String cardinality = null;
        value = params.get("cardinality");
        if (value instanceof IVariableBinding && (cardinalityLiteral = ReferenceCardinality.valueOf((String)(cardinalityBinding = (IVariableBinding)value).getName())) != null) {
            cardinality = cardinalityLiteral.toString();
        }
        String policy = null;
        value = params.get("policy");
        if (value instanceof IVariableBinding && (policyLiteral = ReferencePolicy.valueOf((String)(policyBinding = (IVariableBinding)value).getName())) != null) {
            policy = policyLiteral.toString();
        }
        String target = null;
        value = params.get("target");
        if (value instanceof String) {
            target = (String)value;
            this.validateReferenceTarget(annotation, target, problems);
        }
        if ((value = params.get("unbind")) instanceof String) {
            String unbindValue = (String)value;
            if ("-".equals(unbindValue)) {
                unbind = null;
            } else {
                unbind = unbindValue;
                if (!this.errorLevel.isIgnore() && (unbindMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, unbind, true)) == null) {
                    this.reportProblem(annotation, "unbind", problems, NLS.bind((String)Messages.AnnotationProcessor_invalidReferenceUnbind, (Object)unbind), unbind);
                }
            }
        } else {
            String unbindCandidate = methodName.startsWith("add") ? "remove" + methodName.substring("add".length()) : "un" + methodName;
            unbindMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, unbindCandidate, false);
            if (unbindMethod == null) {
                unbind = null;
                this.reportProblem(annotation, null, this.missingUnbindMethodLevel, problems, NLS.bind((String)Messages.AnnotationProcessor_noImplicitReferenceUnbind, (Object)unbindCandidate), unbindCandidate);
            } else {
                unbind = unbindMethod.getName();
            }
        }
        String policyOption = null;
        value = params.get("policyOption");
        if (value instanceof IVariableBinding && (policyOptionLiteral = ReferencePolicyOption.valueOf((String)(policyOptionBinding = (IVariableBinding)value).getName())) != null) {
            policyOption = policyOptionLiteral.toString();
        }
        if ((value = params.get(ATTRIBUTE_REFERENCE_UPDATED)) instanceof String) {
            String updatedValue = (String)value;
            if ("-".equals(updatedValue)) {
                updated = null;
            } else {
                IMethodBinding updatedMethod;
                updated = updatedValue;
                if (!this.errorLevel.isIgnore() && (updatedMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, updated, true)) == null) {
                    this.reportProblem(annotation, ATTRIBUTE_REFERENCE_UPDATED, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidReferenceUpdated, (Object)updated), updated);
                }
            }
        } else {
            String updatedCandidate = methodName.startsWith("bind") ? ATTRIBUTE_REFERENCE_UPDATED + methodName.substring("bind".length()) : (methodName.startsWith("set") ? ATTRIBUTE_REFERENCE_UPDATED + methodName.substring("set".length()) : (methodName.startsWith("add") ? ATTRIBUTE_REFERENCE_UPDATED + methodName.substring("add".length()) : ATTRIBUTE_REFERENCE_UPDATED + methodName));
            IMethodBinding updatedMethod = this.findReferenceMethod(methodBinding.getDeclaringClass(), (ITypeBinding)serviceType, updatedCandidate, false);
            updated = updatedMethod == null ? null : updatedMethod.getName();
        }
        IDSReference reference = refMap.remove(methodName);
        if (reference == null) {
            reference = factory.createReference();
        }
        collector.add(reference);
        reference.setReferenceBind(methodName);
        if (name == null) {
            this.removeAttribute((IDSObject)reference, "name", null);
        } else {
            reference.setReferenceName(name);
        }
        if (service == null) {
            this.removeAttribute((IDSObject)reference, "interface", null);
        } else {
            reference.setReferenceInterface(service);
        }
        if (cardinality == null) {
            this.removeAttribute((IDSObject)reference, "cardinality", "1..1");
        } else {
            reference.setReferenceCardinality(cardinality);
        }
        if (policy == null) {
            this.removeAttribute((IDSObject)reference, "policy", "static");
        } else {
            reference.setReferencePolicy(policy);
        }
        if (target == null) {
            this.removeAttribute((IDSObject)reference, "target", null);
        } else {
            reference.setReferenceTarget(target);
        }
        if (unbind == null) {
            this.removeAttribute((IDSObject)reference, "unbind", null);
        } else {
            reference.setReferenceUnbind(unbind);
        }
        if (policyOption == null) {
            this.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_POLICY_OPTION, VALUE_REFERENCE_POLICY_OPTION_RELUCTANT);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_POLICY_OPTION, policyOption);
        }
        if (updated == null) {
            this.removeAttribute((IDSObject)reference, ATTRIBUTE_REFERENCE_UPDATED, null);
        } else {
            reference.setXMLAttribute(ATTRIBUTE_REFERENCE_UPDATED, updated);
        }
        return reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_POLICY_OPTION) != null || reference.getDocumentAttribute(ATTRIBUTE_REFERENCE_UPDATED) != null;
    }

    private ITypeBinding getObjectType(AST ast, ITypeBinding primitive) {
        if (Boolean.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Boolean.class.getName());
        }
        if (Byte.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Byte.class.getName());
        }
        if (Character.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Character.class.getName());
        }
        if (Double.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Double.class.getName());
        }
        if (Float.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Float.class.getName());
        }
        if (Integer.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Integer.class.getName());
        }
        if (Long.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Long.class.getName());
        }
        if (Short.TYPE.getName().equals(primitive.getName())) {
            return ast.resolveWellKnownType(Short.class.getName());
        }
        return null;
    }

    private void validateReferenceBindMethod(Annotation annotation, ITypeBinding serviceType, IMethodBinding methodBinding, Collection<DSAnnotationProblem> problems) {
        ITypeBinding[] paramTypeBindings;
        if (this.errorLevel.isIgnore()) {
            return;
        }
        String returnTypeName = methodBinding.getReturnType().getName();
        if (!Void.TYPE.getName().equals(returnTypeName)) {
            this.reportProblem(annotation, null, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidBindMethodReturnType, (Object)returnTypeName), returnTypeName);
        }
        if (!((paramTypeBindings = methodBinding.getParameterTypes()).length == 1 && (ServiceReference.class.getName().equals(paramTypeBindings[0].getErasure().getQualifiedName()) || serviceType == null || serviceType.isAssignmentCompatible(paramTypeBindings[0])) || paramTypeBindings.length == 2 && (serviceType == null || serviceType.isAssignmentCompatible(paramTypeBindings[0])) && Map.class.getName().equals(paramTypeBindings[1].getErasure().getQualifiedName()))) {
            String[] params = new String[paramTypeBindings.length];
            StringBuilder buf = new StringBuilder(64);
            buf.append('(');
            int i = 0;
            while (i < params.length) {
                params[i] = paramTypeBindings[i].getName();
                if (buf.length() > 1) {
                    buf.append(", ");
                }
                buf.append(params[i]);
                ++i;
            }
            buf.append(')');
            this.reportProblem(annotation, null, problems, NLS.bind((String)Messages.AnnotationProcessor_invalidBindMethodParameters, (Object)buf, (Object)(serviceType == null ? Messages.AnnotationProcessor_unknownServiceTypeLabel : serviceType.getName())), params);
        }
    }

    private void validateReferenceTarget(Annotation annotation, String target, Collection<DSAnnotationProblem> problems) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        try {
            FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException e) {
            String msg = e.getMessage();
            String suffix = ": " + e.getFilter();
            if (msg.endsWith(suffix)) {
                msg = msg.substring(0, msg.length() - suffix.length());
            }
            this.reportProblem(annotation, "target", problems, msg, target);
        }
    }

    private IMethodBinding findReferenceMethod(ITypeBinding componentClass, ITypeBinding serviceType, String name, boolean recurse) {
        ITypeBinding testedClass = componentClass;
        IMethodBinding candidate = null;
        int priority = 0;
        do {
            IMethodBinding[] iMethodBindingArray = testedClass.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    IMethodBinding declaredMethod;
                    block14: {
                        ITypeBinding[] paramTypes;
                        block13: {
                            block10: {
                                block12: {
                                    block11: {
                                        declaredMethod = iMethodBindingArray[n2];
                                        if (!name.equals(declaredMethod.getName()) || !Void.TYPE.getName().equals(declaredMethod.getReturnType().getName()) || testedClass != componentClass && !Modifier.isPublic((int)declaredMethod.getModifiers()) && !Modifier.isProtected((int)declaredMethod.getModifiers()) && (Modifier.isPrivate((int)declaredMethod.getModifiers()) || !testedClass.getPackage().isEqualTo((IBinding)componentClass.getPackage()))) break block9;
                                        paramTypes = declaredMethod.getParameterTypes();
                                        if (paramTypes.length != 1) break block10;
                                        if (ServiceReference.class.getName().equals(paramTypes[0].getErasure().getQualifiedName())) {
                                            return declaredMethod;
                                        }
                                        if (priority >= 3 || serviceType == null || !serviceType.isEqualTo((IBinding)paramTypes[0])) break block11;
                                        priority = 3;
                                        break block12;
                                    }
                                    if (priority >= 2 || serviceType == null || !serviceType.isAssignmentCompatible(paramTypes[0])) break block9;
                                    priority = 2;
                                }
                                candidate = declaredMethod;
                                break block9;
                            }
                            if (paramTypes.length != 2) break block9;
                            if (priority >= true || serviceType == null || !serviceType.isEqualTo((IBinding)paramTypes[0]) || !Map.class.getName().equals(paramTypes[1].getErasure().getQualifiedName())) break block13;
                            priority = 1;
                            break block14;
                        }
                        if (candidate != null || serviceType == null || !serviceType.isAssignmentCompatible(paramTypes[0]) || !Map.class.getName().equals(paramTypes[1].getErasure().getQualifiedName())) break block9;
                    }
                    candidate = declaredMethod;
                }
                ++n2;
            }
        } while (recurse && (testedClass = testedClass.getSuperclass()) != null);
        return candidate;
    }

    private void reportProblem(Annotation annotation, String member, Collection<DSAnnotationProblem> problems, String message, String ... args) {
        this.reportProblem(annotation, member, -1, problems, message, args);
    }

    private void reportProblem(Annotation annotation, String member, ValidationErrorLevel errorLevel, Collection<DSAnnotationProblem> problems, String message, String ... args) {
        this.reportProblem(annotation, member, -1, errorLevel, problems, message, args);
    }

    private void reportProblem(Annotation annotation, String member, int valueIndex, Collection<DSAnnotationProblem> problems, String message, String ... args) {
        this.reportProblem(annotation, member, valueIndex, this.errorLevel, problems, message, args);
    }

    private void reportProblem(Annotation annotation, String member, int valueIndex, ValidationErrorLevel errorLevel, Collection<DSAnnotationProblem> problems, String message, String ... args) {
        ArrayInitializer ai;
        if (errorLevel.isIgnore()) {
            return;
        }
        Annotation memberValue = annotation;
        if (annotation.isNormalAnnotation() && member != null) {
            NormalAnnotation na = (NormalAnnotation)annotation;
            for (Object value : na.values()) {
                MemberValuePair pair = (MemberValuePair)value;
                if (!member.equals(pair.getName().getIdentifier())) continue;
                memberValue = pair.getValue();
                break;
            }
        } else if (annotation.isSingleMemberAnnotation()) {
            SingleMemberAnnotation sma = (SingleMemberAnnotation)annotation;
            memberValue = sma.getValue();
        }
        int start = memberValue.getStartPosition();
        int length = memberValue.getLength();
        if (valueIndex >= 0 && memberValue instanceof ArrayInitializer && valueIndex < (ai = (ArrayInitializer)memberValue).expressions().size()) {
            Expression element = (Expression)ai.expressions().get(valueIndex);
            start = element.getStartPosition();
            length = element.getLength();
        }
        if (start >= 0) {
            DSAnnotationProblem problem = new DSAnnotationProblem(errorLevel.isError(), message, args);
            problem.setSourceStart(start);
            problem.setSourceEnd(start + length - 1);
            problems.add(problem);
        }
    }
}

