/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.internal.db.IObjectTypeMapper;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractObjectTypeMapper;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class DelegatingObjectTypeMapper
extends AbstractObjectTypeMapper {
    private IObjectTypeMapper delegate;

    public IObjectTypeMapper getDelegate() {
        return this.delegate;
    }

    public void setDelegate(IObjectTypeMapper delegate) {
        this.delegate = delegate;
    }

    public CDOClassifierRef getObjectType(IDBStoreAccessor accessor, CDOID id) {
        CDOID type = this.doGetObjectType(accessor, id);
        if (type != null) {
            EClass eClass = (EClass)this.getMetaDataManager().getMetaInstance(type);
            return new CDOClassifierRef((EClassifier)eClass);
        }
        return this.delegate.getObjectType(accessor, id);
    }

    public boolean putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        CDOID classID = this.getMetaDataManager().getMetaID((EModelElement)type, timeStamp);
        if (!this.doPutObjectType(accessor, id, classID)) {
            return false;
        }
        return this.delegate.putObjectType(accessor, timeStamp, id, type);
    }

    public boolean removeObjectType(IDBStoreAccessor accessor, CDOID id) {
        this.doRemoveObjectType(accessor, id);
        return this.delegate.removeObjectType(accessor, id);
    }

    public CDOID getMaxID(Connection connection, IIDHandler idHandler) {
        CDOID maxID = this.doGetMaxID(connection, idHandler);
        if (maxID != null) {
            return maxID;
        }
        return this.delegate.getMaxID(connection, idHandler);
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        this.delegate.rawExport(connection, out, fromCommitTime, toCommitTime);
    }

    public void rawImport(Connection connection, CDODataInput in, OMMonitor monitor) throws IOException {
        this.delegate.rawImport(connection, in, monitor);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.delegate, "delegate");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.delegate);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.delegate);
        super.doDeactivate();
    }

    protected abstract CDOID doGetMaxID(Connection var1, IIDHandler var2);

    protected abstract CDOID doGetObjectType(IDBStoreAccessor var1, CDOID var2);

    protected abstract boolean doPutObjectType(IDBStoreAccessor var1, CDOID var2, CDOID var3);

    protected abstract boolean doRemoveObjectType(IDBStoreAccessor var1, CDOID var2);
}

