/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.checkouts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.AbstractCDOViewProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.ref.ReferenceMonitor;

public class CDOCheckoutViewProvider
extends AbstractCDOViewProvider {
    public static final String SCHEME = "cdo.checkout";
    private static final ReferenceMonitor<ResourceSet> MONITOR = new ReferenceMonitor<ResourceSet>(){

        protected void work(ResourceSet resourceSet) {
            CDOCheckoutViewProvider.disposeResourceSet(resourceSet);
        }
    };

    public CDOCheckoutViewProvider() {
        this(500);
    }

    public CDOCheckoutViewProvider(int priority) {
        super("cdo\\.checkout://.*", priority);
    }

    public CDOView getView(URI uri, ResourceSet resourceSet) {
        CDOCheckout checkout = CDOCheckoutViewProvider.getCheckout(uri);
        if (checkout != null) {
            CheckoutViewProviderAdapter adapter = CheckoutViewProviderAdapter.get(resourceSet);
            if (adapter == null) {
                adapter = CheckoutViewProviderAdapter.create(resourceSet);
                MONITOR.activate();
                MONITOR.monitor((Object)resourceSet);
            }
            return adapter.getView(checkout);
        }
        return null;
    }

    public URI getResourceURI(CDOView view, String path) {
        CDOCheckout checkout = CDOExplorerUtil.getCheckout(view);
        if (checkout != null) {
            return checkout.createResourceURI(path);
        }
        return super.getResourceURI(view, path);
    }

    public static void disposeResourceSet(ResourceSet resourceSet) {
        CheckoutViewProviderAdapter adapter = CheckoutViewProviderAdapter.get(resourceSet);
        if (adapter != null) {
            adapter.dispose();
        }
    }

    public static CDOCheckout getCheckout(URI uri) {
        if (SCHEME.equals(uri.scheme())) {
            String checkoutID = uri.authority();
            return CDOExplorerUtil.getCheckoutManager().getCheckout(checkoutID);
        }
        return null;
    }

    private static final class CheckoutViewProviderAdapter
    extends AdapterImpl {
        private final Map<CDOCheckout, CDOView> views = new HashMap<CDOCheckout, CDOView>();

        private CheckoutViewProviderAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOView getView(final CDOCheckout checkout) {
            Map<CDOCheckout, CDOView> map = this.views;
            synchronized (map) {
                CDOView view = this.views.get(checkout);
                if (view == null) {
                    ResourceSet resourceSet = this.getTarget();
                    CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
                    if (viewSet != null) {
                        CDOView[] cDOViewArray = viewSet.getViews();
                        int n = cDOViewArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CDOView viewSetView = cDOViewArray[n2];
                            if (checkout == CDOExplorerUtil.getCheckout(viewSetView)) {
                                view = viewSetView;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (view == null) {
                        view = checkout.openView(resourceSet);
                    }
                    if (view != null) {
                        this.views.put(checkout, view);
                        view.addListener((IListener)new LifecycleEventAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected void onDeactivated(ILifecycle lifecycle) {
                                Map map = CheckoutViewProviderAdapter.this.views;
                                synchronized (map) {
                                    CheckoutViewProviderAdapter.this.views.remove(checkout);
                                }
                            }
                        });
                    }
                }
                return view;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == CheckoutViewProviderAdapter.class;
        }

        public ResourceSet getTarget() {
            return (ResourceSet)super.getTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            CDOView[] array;
            Map<CDOCheckout, CDOView> map = this.views;
            synchronized (map) {
                array = this.views.values().toArray(new CDOView[this.views.size()]);
                this.views.clear();
            }
            CDOView[] cDOViewArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                CDOView view = cDOViewArray[n2];
                view.close();
                ++n2;
            }
            ResourceSet resourceSet = this.getTarget();
            resourceSet.eAdapters().remove((Object)this);
        }

        public static CheckoutViewProviderAdapter get(ResourceSet resourceSet) {
            EList adapters = resourceSet.eAdapters();
            CheckoutViewProviderAdapter adapter = (CheckoutViewProviderAdapter)EcoreUtil.getAdapter((List)adapters, CheckoutViewProviderAdapter.class);
            if (adapter != null && adapter.getTarget() != resourceSet) {
                adapters.remove((Object)adapter);
                adapter = null;
            }
            return adapter;
        }

        public static CheckoutViewProviderAdapter create(ResourceSet resourceSet) {
            CheckoutViewProviderAdapter adapter = new CheckoutViewProviderAdapter();
            resourceSet.eAdapters().add((Object)adapter);
            return adapter;
        }
    }
}

