/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.marker;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusMarkerNavigationProvider;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SiriusMarkerNavigationProviderSpec
extends SiriusMarkerNavigationProvider {
    @Override
    protected void doGotoMarker(IMarker marker) {
        SiriusDiagramEditor targetEditor;
        String diagramURI = marker.getAttribute("DIAGRAM_URI", null);
        String elementId = marker.getAttribute("elementId", null);
        if (diagramURI == null || elementId == null || !(this.getEditor() instanceof SiriusDiagramEditor)) {
            return;
        }
        SiriusDiagramEditor defaultEditor = (SiriusDiagramEditor)this.getEditor();
        URI markedResource = URI.createPlatformResourceURI((String)marker.getResource().getFullPath().toString(), (boolean)true);
        URI markedDiagramURI = URI.createURI((String)diagramURI);
        Diagram markedDiagram = (Diagram)defaultEditor.getDiagram().eResource().getEObject(markedDiagramURI.fragment());
        if (markedDiagram == null) {
            markedDiagram = (Diagram)defaultEditor.getEditingDomain().getResourceSet().getEObject(markedDiagramURI, true);
        }
        if (markedDiagram != null && (targetEditor = this.switchToTargetEditor(defaultEditor, markedResource, markedDiagramURI, markedDiagram)) != null) {
            Map editPartRegistry = targetEditor.getDiagramGraphicalViewer().getEditPartRegistry();
            EObject targetView = targetEditor.getDiagram().eResource().getEObject(elementId);
            if (targetView == null) {
                return;
            }
            EditPart targetEditPart = (EditPart)editPartRegistry.get(targetView);
            if (targetEditPart != null) {
                SiriusDiagramEditorUtil.selectElementsInDiagram((IDiagramWorkbenchPart)targetEditor, Arrays.asList(targetEditPart));
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)targetEditor);
        }
    }

    private SiriusDiagramEditor switchToTargetEditor(SiriusDiagramEditor defaultEditor, URI sessionResourceUri, URI markerDiagramURI, Diagram markerDiagram) {
        SiriusDiagramEditor targetEditor;
        if (defaultEditor.getDiagram().equals(markerDiagram)) {
            targetEditor = defaultEditor;
        } else {
            Object editorInput = null;
            String editorName = SiriusMarkerNavigationProviderSpec.resolveSemanticElement(markerDiagram).getName();
            Session session = new EObjectQuery((EObject)markerDiagram).getSession();
            editorInput = session != null ? new SessionEditorInput(markerDiagramURI, editorName, session) : new URIEditorInput(markerDiagramURI, editorName);
            SiriusDiagramEditor searchEditor = this.searchEditor((URIEditorInput)editorInput);
            if (searchEditor != null) {
                targetEditor = searchEditor;
            } else {
                session = this.getOrOpenTargetSession(sessionResourceUri);
                SiriusDiagramEditor openedEditor = null;
                if (session != null) {
                    Diagram diagramToOpen = markerDiagram;
                    if (session.getTransactionalEditingDomain() != null && session.getTransactionalEditingDomain().getResourceSet() != defaultEditor.getEditingDomain().getResourceSet()) {
                        diagramToOpen = (Diagram)session.getTransactionalEditingDomain().getResourceSet().getEObject(markerDiagramURI, true);
                    }
                    if (diagramToOpen != null) {
                        openedEditor = (SiriusDiagramEditor)DialectUIManager.INSTANCE.openEditor(session, (DRepresentation)((DDiagram)diagramToOpen.getElement()), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                if (openedEditor != null) {
                    targetEditor = openedEditor;
                    if (defaultEditor instanceof DialectEditor && ((DialectEditor)defaultEditor).getRepresentation() == null) {
                        defaultEditor.close(false);
                    }
                } else {
                    targetEditor = defaultEditor;
                    targetEditor.setInput((IEditorInput)editorInput);
                }
            }
        }
        return targetEditor;
    }

    private Session getOrOpenTargetSession(URI sessionResourceUri) {
        Session session = SessionManager.INSTANCE.getExistingSession(sessionResourceUri);
        if (session == null) {
            ModelingProjectManager.INSTANCE.loadAndOpenRepresentationsFile(sessionResourceUri, true);
            try {
                Job.getJobManager().join((Object)"org.eclipse.sirius.representationsFile", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException interruptedException) {}
            session = SessionManager.INSTANCE.getExistingSession(sessionResourceUri);
        }
        return session;
    }

    private SiriusDiagramEditor searchEditor(URIEditorInput editorInput) {
        SiriusDiagramEditor result = null;
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length && result == null) {
            try {
                URIEditorInput currentEditorInput;
                if (editorReferences[i].getEditor(false) instanceof SiriusDiagramEditor && editorReferences[i].getEditorInput() instanceof URIEditorInput && (currentEditorInput = (URIEditorInput)editorReferences[i].getEditorInput()).equals((Object)editorInput)) {
                    result = (SiriusDiagramEditor)editorReferences[i].getEditor(false);
                }
            }
            catch (PartInitException partInitException) {}
            ++i;
        }
        return result;
    }

    public static IMarker addMarker(IFile file, String elementId, String diagramURI, String semanticURI, String location, String message, int statusSeverity) {
        IMarker marker = SiriusMarkerNavigationProvider.addMarker(file, elementId, location, message, statusSeverity);
        try {
            marker.setAttribute("DIAGRAM_URI", (Object)diagramURI);
            marker.setAttribute("SEMANTIC_URI", (Object)semanticURI);
            marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        }
        catch (CoreException e) {
            DiagramPlugin.getDefault().logError(Messages.SiriusMarkerNavigationProvider_validationMarkerCreationError, (Throwable)e);
        }
        return marker;
    }

    public static IMarker addValidationRuleMarker(ValidationRule validationRule, IFile file, String elementId, String diagramURI, String semanticURI, String location, String message, int statusSeverity) {
        IMarker marker = SiriusMarkerNavigationProvider.addValidationRuleMarker(validationRule, file, elementId, location, message, statusSeverity);
        try {
            marker.setAttribute("DIAGRAM_URI", (Object)diagramURI);
            marker.setAttribute("SEMANTIC_URI", (Object)semanticURI);
            marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        }
        catch (CoreException e) {
            DiagramPlugin.getDefault().logError(Messages.SiriusMarkerNavigationProvider_validationMarkerCreationError, (Throwable)e);
        }
        return marker;
    }

    public static EObject resolveTargetSemanticElement(Diagram diagram) {
        EObject semanticDiagram = diagram.getElement();
        if (semanticDiagram instanceof DSemanticDiagram) {
            return ((DSemanticDiagram)semanticDiagram).getTarget();
        }
        return null;
    }

    public static DSemanticDiagram resolveSemanticElement(Diagram diagram) {
        EObject semanticDiagram = diagram.getElement();
        if (semanticDiagram instanceof DSemanticDiagram) {
            return (DSemanticDiagram)semanticDiagram;
        }
        return null;
    }
}

