/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.ecore.composite;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringComposite<T>
extends AbstractCellEditorComposite<T> {
    private Text textField = null;
    private final Composite parentControl;
    private IConverter<T> converter;
    protected static final Color RED = new Color((Device)Display.getCurrent(), 255, 192, 192);
    protected static final Color WHITE = Display.getCurrent().getSystemColor(25);

    public StringComposite(Composite parent, int style) {
        super(parent);
        this.setLayout((Layout)new FillLayout());
        this.parentControl = parent;
        this.textField = new Text((Composite)this, style);
        this.textField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    if (StringComposite.this.getTextField().getEditable()) {
                        StringComposite.this.commit();
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    StringComposite.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!StringComposite.this.validate(StringComposite.this.getTextField().getText()).isOK()) {
                    StringComposite.this.getTextField().setBackground(RED);
                } else {
                    StringComposite.this.getTextField().setBackground(WHITE);
                }
                super.keyReleased(e);
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == StringComposite.this.getParentControl().getShell() && event.widget != StringComposite.this.getTextField()) {
                    StringComposite.this.commit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringComposite.this.fireChanged();
            }
        });
        this.textField.forceFocus();
    }

    public StringComposite(Composite parent) {
        this(parent, 0);
    }

    protected void commit() {
        if (this.getValidator().validate(this.getValue()).isOK()) {
            this.fireCommit();
        }
    }

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public boolean getEditable() {
        return this.textField.getEditable();
    }

    public void setValue(T value) {
        if (value == null) {
            this.textField.setText("");
        } else {
            String strValue = this.getConverter().toString(value);
            this.textField.setText(strValue);
            this.textField.setSelection(0, strValue.length());
        }
    }

    public String getText() {
        return this.textField.getText();
    }

    protected Text getTextField() {
        return this.textField;
    }

    protected Composite getParentControl() {
        return this.parentControl;
    }

    public T getValue() {
        return this.getConverter().toObject(this.getText());
    }

    private IConverter<T> getConverter() {
        if (this.converter == null) {
            this.converter = this.initConverter();
        }
        return this.converter;
    }

    public abstract IConverter<T> initConverter();

    public abstract IStatus validate(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IConverter<T> {
        public T toObject(String var1);

        public String toString(T var1);
    }
}

