/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.util.connection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.dawn.internal.util.bundle.OM;
import org.eclipse.emf.cdo.dawn.util.exceptions.DawnInvalidIdException;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOConnectionUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOConnectionUtil.class);
    public static CDOConnectionUtil instance = new CDOConnectionUtil();
    private CDOSession currentSession;
    private String repositoryName;
    private String protocol;
    private String host;
    private Map<String, CDOTransaction> transactions;
    private IConnector connector;

    static {
        if (!OMPlatform.INSTANCE.isOSGiRunning()) {
            Net4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
            TCPUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
            CDONet4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        }
    }

    public void init(String repositoryName, String protocol, String host) {
        this.repositoryName = repositoryName;
        this.protocol = protocol;
        this.host = host;
        this.setConnector(Net4jUtil.getConnector((IManagedContainer)IPluginContainer.INSTANCE, (String)protocol, (String)host));
    }

    public void registerPackages(List<EPackage> packages) {
        if (packages == null) {
            return;
        }
        for (EPackage pack : packages) {
            pack.eClass();
        }
    }

    public CDOSession openSession() {
        this.currentSession = (CDOSession)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.sessions", "cdo", String.valueOf(this.protocol) + "://" + this.host + "?repositoryName=" + this.repositoryName);
        return this.currentSession;
    }

    public void closeCurrentSession() {
        this.getCurrentSession().close();
    }

    public CDOTransaction openCurrentTransaction(ResourceSet resourceSet, String id) {
        if (id == null) {
            throw new DawnInvalidIdException("The identifier '" + id + "' is invalid for openeing a transaction");
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Opening transaction for {0} on {1}", new Object[]{id, resourceSet});
        }
        id = this.convert(id);
        CDOTransaction transaction = this.getCurrentSession().openTransaction(resourceSet);
        this.getTransactions().put(id, transaction);
        return transaction;
    }

    public void setChangeSubscribtionPolicyForCurrentTransaction(CDOAdapterPolicy policy, String id) {
        id = this.convert(id);
        this.getTransactions().get(id).options().addChangeSubscriptionPolicy(policy);
    }

    public CDOTransaction getCurrentTransaction(String id) {
        id = this.convert(id);
        return this.getTransactions().get(id);
    }

    private String convert(String id) {
        return id.replace("dawn", "cdo");
    }

    public CDOSession getCurrentSession() {
        if (this.currentSession == null) {
            this.currentSession = this.openSession();
        }
        return this.currentSession;
    }

    public Map<String, CDOTransaction> getTransactions() {
        if (this.transactions == null) {
            this.transactions = new HashMap<String, CDOTransaction>();
        }
        return this.transactions;
    }

    public CDOView openView(CDOSession session) {
        return session.openView();
    }

    public CDOTransaction openTransaction(CDOSession session) {
        return session.openTransaction();
    }

    @Deprecated
    public static void closeSession(CDOSession session) {
        session.close();
    }

    public CDOTransaction getOrOpenCurrentTransaction(String id, ResourceSet resourceSet, String repositoryName) {
        CDOTransaction transaction = this.getCurrentTransaction(id);
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
        if (viewSet != null) {
            return ((InternalCDOView)viewSet.resolveView(repositoryName)).toTransaction();
        }
        if (transaction == null) {
            transaction = this.openCurrentTransaction(resourceSet, id);
        }
        return transaction;
    }

    public void setConnector(IConnector connector) {
        this.connector = connector;
    }

    public IConnector getConnector() {
        return this.connector;
    }
}

