/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.preference;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.preference.EclipsePreferencesElement;
import org.eclipse.e4.ui.css.swt.helpers.EclipsePreferencesHelper;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class EclipsePreferencesHandler
implements ICSSPropertyHandler {
    public static final String PREFERENCES_PROP = "preferences";
    private static final Pattern PROPERTY_NAME_AND_VALUE_PATTERN = Pattern.compile("(.+)\\s*=\\s*(.*)");

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!property.equals(PREFERENCES_PROP) || !(element instanceof EclipsePreferencesElement)) {
            return false;
        }
        IEclipsePreferences preferences = (IEclipsePreferences)((EclipsePreferencesElement)((Object)element)).getNativeWidget();
        if (value.getCssValueType() == 2) {
            CSSValueList list = (CSSValueList)value;
            int i = 0;
            while (i < list.getLength()) {
                this.overrideProperty(preferences, list.item(i));
                ++i;
            }
        } else {
            this.overrideProperty(preferences, value);
        }
        return true;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    protected void overrideProperty(IEclipsePreferences preferences, CSSValue value) {
        Matcher matcher = PROPERTY_NAME_AND_VALUE_PATTERN.matcher(value.getCssText());
        if (matcher.find()) {
            this.overrideProperty(preferences, matcher.group(1).trim(), matcher.group(2).trim());
        }
    }

    protected void overrideProperty(IEclipsePreferences preferences, String name, String value) {
        if (preferences.get(name, null) == null || EclipsePreferencesHelper.isThemeChanged()) {
            preferences.put(name, value);
            EclipsePreferencesHelper.appendOverriddenPropertyName(preferences, name);
        }
    }
}

