/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.DelegatingUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public class BundleUnitResolver
extends DelegatingUnitResolver {
    private List<URL> fBaseURLs;

    public BundleUnitResolver(List<URL> baseURL) {
        if (baseURL == null || baseURL.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.fBaseURLs = new ArrayList<URL>(baseURL);
    }

    protected UnitProxy doResolveUnit(String qualifiedName) {
        for (URL baseURL : this.fBaseURLs) {
            UnitProxy unit = this.doResolveUnit(baseURL, qualifiedName);
            if (unit == null) continue;
            return unit;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private UnitProxy doResolveUnit(URL baseURL, String qualifiedName) {
        BundleUnit bundleUnit;
        InputStream is;
        block14: {
            URL url;
            String pathStr = qualifiedName.replace('.', '/');
            IPath path = new Path(pathStr).addFileExtension("qvto");
            try {
                url = new URL(baseURL, path.toString());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            is = null;
            is = url.openStream();
            String name = path.lastSegment();
            String namespace = null;
            if (path.segmentCount() > 1) {
                IPath nameSpacePath = path.removeLastSegments(1);
                namespace = ResolverUtils.getNamespace((IPath)nameSpacePath);
            }
            bundleUnit = new BundleUnit(namespace, name, url);
            if (is == null) break block14;
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return bundleUnit;
        catch (IOException iOException) {
            block15: {
                try {
                    if (is == null) break block15;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    private static URI createUnitURI(URL url) {
        return URI.createURI((String)url.toString());
    }

    public static UnitResolver createResolver(List<URL> bundleBaseURLs, boolean includeBlackboxUnits) {
        BundleUnitResolver bundleUnitResolver = new BundleUnitResolver(bundleBaseURLs);
        if (includeBlackboxUnits) {
            bundleUnitResolver.setParent((UnitResolver)BlackboxUnitResolver.DEFAULT);
        }
        return bundleUnitResolver;
    }

    private final class BundleUnit
    extends UnitProxy {
        private final URL url;

        private BundleUnit(String namespace, String unitName, URL unitURL) {
            super(namespace, unitName, BundleUnitResolver.createUnitURI(unitURL));
            this.url = unitURL;
        }

        public int getContentType() {
            return 0;
        }

        public UnitContents getContents() throws IOException {
            return new UnitContents.CSTContents(){

                public Reader getContents() throws IOException {
                    URLConnection connection = BundleUnit.this.url.openConnection();
                    String charset = connection.getContentEncoding();
                    if (charset == null) {
                        charset = "UTF-8";
                    }
                    return new InputStreamReader(connection.getInputStream(), charset);
                }
            };
        }

        public UnitResolver getResolver() {
            return BundleUnitResolver.this;
        }
    }
}

