/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.ocl.DeclaredParameter;

public class XpandDefinitionWrap {
    private final XpandDefinition def;
    private final ExecutionContext ctx;

    public XpandDefinitionWrap(XpandDefinition def, ExecutionContext ctx) {
        this.def = def;
        this.ctx = ctx;
    }

    public String getName() {
        return this.def.getName();
    }

    public List<EClassifier> getParamTypes() {
        DeclaredParameter[] p = this.def.getParams();
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        DeclaredParameter[] declaredParameterArray = p;
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            DeclaredParameter element = declaredParameterArray[n2];
            result.add(element.getTypeForName(this.ctx));
            ++n2;
        }
        return result;
    }

    public List<String> getParamNames() {
        DeclaredParameter[] p = this.def.getParams();
        ArrayList<String> result = new ArrayList<String>();
        DeclaredParameter[] declaredParameterArray = p;
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            DeclaredParameter element = declaredParameterArray[n2];
            result.add(element.getVarName());
            ++n2;
        }
        return result;
    }

    public void proceed() {
        this.def.evaluate(this.ctx);
    }

    public void proceed(Object target, List<?> list) {
        ExecutionContext context = this.ctx;
        if (target != null) {
            context = context.cloneWithVariable(new Variable("this", null, target));
        }
        if (list != null) {
            List<String> n = this.getParamNames();
            int i = 0;
            int x = list.size();
            while (i < x) {
                Object o = list.get(i);
                if (o == null || n.size() < i) continue;
                context = context.cloneWithVariable(new Variable(n.get(i), null, o));
            }
        }
        this.def.evaluate(context);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.def.toString() + ']';
    }
}

