/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorActionBarContributor;

public class StatusLineUtil {
    private StatusLineUtil() {
    }

    public static void outputErrorMessage(IWorkbenchPart part, final String errorMessage) {
        Display workbenchDisplay;
        final IStatusLineManager statusLineManager = StatusLineUtil.getStatusLineManager(part);
        if (statusLineManager == null) {
            return;
        }
        Display display = workbenchDisplay = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getDisplay() : Display.getDefault();
        if (workbenchDisplay.getThread() == Thread.currentThread()) {
            statusLineManager.setErrorMessage(errorMessage);
        } else {
            workbenchDisplay.asyncExec(new Runnable(){

                public void run() {
                    statusLineManager.setErrorMessage(errorMessage);
                }
            });
        }
    }

    private static IStatusLineManager getStatusLineManager(IWorkbenchPart part) {
        IEditorPart editorPart;
        IEditorActionBarContributor contributor;
        IStatusLineManager result = null;
        if (part instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)part;
            result = viewPart.getViewSite().getActionBars().getStatusLineManager();
        } else if (part instanceof IEditorPart && (contributor = (editorPart = (IEditorPart)part).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            result = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return result;
    }
}

