/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPapyrusQuery
implements ISearchQuery {
    protected SubMonitor progressMonitor;

    public abstract String getSearchQueryText();

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isRegularExpression() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<View> getViews(Element element) {
        IPageManager pageManager;
        if (element == null) {
            return null;
        }
        try {
            pageManager = (IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)element);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        LinkedList<View> viewsToSelect = new LinkedList<View>();
        try {
            for (Object page : pageManager.allPages()) {
                try {
                    if (!(page instanceof View)) continue;
                    View view = (View)page;
                    TreeIterator allViews = view.eAllContents();
                    while (allViews.hasNext()) {
                        EObject next = (EObject)allViews.next();
                        if (!(next instanceof View)) {
                            allViews.prune();
                            continue;
                        }
                        View nextView = (View)next;
                        if (!element.equals(nextView.getElement())) continue;
                        viewsToSelect.add(nextView);
                        allViews.prune();
                    }
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
            }
            return viewsToSelect;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public static final class Empty
    extends AbstractPapyrusQuery {
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
            return Status.OK_STATUS;
        }

        public String getLabel() {
            return "Empty Papyrus Search";
        }

        public boolean canRerun() {
            return true;
        }

        public boolean canRunInBackground() {
            return true;
        }

        public PapyrusSearchResult getSearchResult() {
            return new PapyrusSearchResult(this);
        }

        public String getSearchQueryText() {
            return "";
        }
    }
}

