/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.resource;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.papyrus.cdo.core.resource.CDOUndoContext;
import org.eclipse.papyrus.commands.NestingNotifyingWorkspaceCommandStack;

public class CDOAwareCommandStack
extends NestingNotifyingWorkspaceCommandStack {
    public CDOAwareCommandStack(IOperationHistory history) {
        super(history);
    }

    protected CDOAwareCommandStack(boolean nested, IOperationHistory history) {
        super(nested, history);
    }

    public void dispose() {
        IOperationHistory history = this.getOperationHistory();
        if (history != null) {
            CDOUndoContext.flushAll(history);
        }
        super.dispose();
    }

    protected NestingNotifyingWorkspaceCommandStack createNestedCommandStack(IOperationHistory history) {
        return new CDOAwareCommandStack(true, history);
    }

    protected void hookUndoContexts(IUndoableOperation operation, ResourceSetChangeEvent event) {
        super.hookUndoContexts(operation, event);
        HashSet affectedObjects = Sets.newHashSet();
        for (Notification next : event.getNotifications()) {
            Object notifier = next.getNotifier();
            if (!(notifier instanceof EObject)) continue;
            EObject object = (EObject)notifier;
            if (object.eClass() != EresourcePackage.Literals.CDO_RESOURCE) {
                affectedObjects.add(object);
                continue;
            }
            if (next.getFeature() != EresourcePackage.Literals.CDO_RESOURCE__CONTENTS) continue;
            affectedObjects.add(object);
        }
        if (!affectedObjects.isEmpty()) {
            operation.addContext((IUndoContext)new CDOUndoContext(affectedObjects));
        }
    }
}

