/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.gmf.tooling.runtime.linklf.AbsoluteBendpointsConvention;

public class SetAbsoluteBendpointsCommand
extends SetConnectionBendpointsCommand {
    public SetAbsoluteBendpointsCommand(TransactionalEditingDomain editingDomain) {
        super(editingDomain);
    }

    public void setEdge(ConnectionEditPart editPart) {
        View edge = editPart.getNotationView();
        this.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
    }

    public void setNewPointList(PointList newPointList) {
        super.setNewPointList(newPointList, new Point(), new Point());
    }

    public void setEdgeAdapter(IAdaptable edgeAdapter) {
        super.setEdgeAdapter(edgeAdapter);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)this.getNewPointList());
        Assert.isNotNull((Object)this.getSourceRefPoint());
        Assert.isNotNull((Object)this.getTargetRefPoint());
        Edge edge = (Edge)this.getEdgeAdaptor().getAdapter(Edge.class);
        Assert.isNotNull((Object)edge);
        SetAbsoluteBendpointsCommand.setAbsoluteBendpoints(edge, this.getNewPointList());
        return CommandResult.newOKCommandResult();
    }

    public static void setAbsoluteBendpoints(Edge edge, PointList newPointList) {
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        int numOfPoints = newPointList.size();
        int i = 0;
        while (i < numOfPoints) {
            newBendpoints.add(AbsoluteBendpointsConvention.getInstance().createAbsoluteBendpointStoredAsRelative(newPointList.getPoint(i)));
            i = (short)(i + 1);
        }
        RelativeBendpoints points = (RelativeBendpoints)edge.getBendpoints();
        points.setPoints(newBendpoints);
    }

    protected static void dumpModelBendpoints(List<RelativeBendpoint> bendpoints) {
        StringBuffer toString = new StringBuffer();
        boolean atLeastOne = false;
        for (RelativeBendpoint next : bendpoints) {
            if (atLeastOne) {
                toString.append(" - ");
            }
            toString.append(next.convertToString());
            atLeastOne = true;
        }
        System.err.println("SetAbsBendpoints: " + toString);
    }

    public String toString() {
        return "SAbsBC[$" + System.identityHashCode((Object)this) + "]";
    }
}

