/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToCleanC.core.utils;

import eu.fbk.eclipse.standardtools.utils.core.utils.Pair;
import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class RfiConfiguration {
    private static final Logger logger = Logger.getLogger(RfiConfiguration.class);
    private EMap<String, Integer> classNameToNumInstances = new BasicEMap();
    private EMap<String, EList<String>> classNameToInstancesNames = new BasicEMap();
    private EMap<String, MapOfInstanceNameToClassName> classNameToRefClassInfo = new BasicEMap();
    private EMap<String, MapOfParamNameToParamType> classNameToParamTypeInfo = new BasicEMap();
    private EMap<ClassInstanceId, MapOfInstanceNameToIndexes> instanceIdToRefIndexesInfo = new BasicEMap();
    private EMap<ClassInstanceId, MapOfParamNameToParamValue> instanceIdToParamValueInfo = new BasicEMap();

    public void addClassNameToNumInstances(String className, Integer numInstances) {
        assert (numInstances >= 0);
        assert (!this.classNameToNumInstances.containsKey((Object)className));
        this.classNameToNumInstances.put((Object)className, (Object)numInstances);
    }

    public void addClassNameToInstancesNames(String className, String[] instancesNames) {
        assert (instancesNames.length >= 0);
        assert (!this.classNameToNumInstances.containsKey((Object)className));
        this.classNameToNumInstances.put((Object)className, (Object)instancesNames.length);
        assert (!this.classNameToInstancesNames.containsKey((Object)className));
        this.classNameToInstancesNames.put((Object)className, (Object)new BasicEList(Arrays.asList(instancesNames)));
        for (String instanceName : this.getInstancesNames(className)) {
            logger.debug((Object)("addClassNameToInstancesNames " + className + ": " + instanceName));
        }
    }

    public Integer getNumInstances(String className) {
        return (Integer)this.classNameToNumInstances.get((Object)className);
    }

    public EList<String> getInstancesNames(String className) {
        return (EList)this.classNameToInstancesNames.get((Object)className);
    }

    public String getInstanceName(String className, int index) {
        return (String)((EList)this.classNameToInstancesNames.get((Object)className)).get(index);
    }

    public void addInstanceRefList(String className, String instanceName, String refInstName, String refClassName, String[] refInstanceNamesList) {
        int instanceIndex = this.getInstanceIndex(className, instanceName);
        Integer[] refInstanceIndexes = this.getInstanceIndexes(refClassName, refInstanceNamesList);
        this.addInstanceRefList(className, instanceIndex, refInstName, refClassName, refInstanceIndexes);
    }

    private Integer[] getInstanceIndexes(String className, String[] instanceNamesList) {
        Integer[] indexes = new Integer[instanceNamesList.length];
        int i = 0;
        while (i < instanceNamesList.length) {
            indexes[i] = this.getInstanceIndex(className, instanceNamesList[i]);
            ++i;
        }
        return indexes;
    }

    private int getInstanceIndex(String className, String instanceName) {
        return ((EList)this.classNameToInstancesNames.get((Object)className)).indexOf((Object)instanceName);
    }

    public void addInstanceRefList(String className, Integer instanceIndex, String refInstName, String refClassName, Integer[] refIndexesList) {
        MapOfInstanceNameToIndexes refIndexesInfo;
        ClassInstanceId instanceId = new ClassInstanceId(className, instanceIndex);
        if (this.instanceIdToRefIndexesInfo.containsKey((Object)instanceId)) {
            refIndexesInfo = (MapOfInstanceNameToIndexes)((Object)this.instanceIdToRefIndexesInfo.get((Object)instanceId));
        } else {
            refIndexesInfo = new MapOfInstanceNameToIndexes();
            this.instanceIdToRefIndexesInfo.put((Object)instanceId, (Object)refIndexesInfo);
        }
        assert (!refIndexesInfo.contains(refInstName));
        refIndexesInfo.put(refInstName, new BasicEList(Arrays.asList(refIndexesList)));
        if (this.classNameToRefClassInfo.containsKey((Object)className)) {
            MapOfInstanceNameToClassName refClassInfo = (MapOfInstanceNameToClassName)((Object)this.classNameToRefClassInfo.get((Object)className));
            refClassInfo.put(refInstName, refClassName);
        } else {
            MapOfInstanceNameToClassName refClassInfo = new MapOfInstanceNameToClassName();
            refClassInfo.put(refInstName, refClassName);
            this.classNameToRefClassInfo.put((Object)className, (Object)refClassInfo);
        }
    }

    public final EList<Integer> getRefIndexes(String className, Integer instanceIndex, String refInstanceName) {
        ClassInstanceId classNameInstanceIndexPair = new ClassInstanceId(className, instanceIndex);
        if (this.instanceIdToRefIndexesInfo.containsKey((Object)classNameInstanceIndexPair)) {
            MapOfInstanceNameToIndexes refInstNameToIndLists = (MapOfInstanceNameToIndexes)((Object)this.instanceIdToRefIndexesInfo.get((Object)classNameInstanceIndexPair));
            EList indexesList = (EList)refInstNameToIndLists.get(refInstanceName);
            return indexesList;
        }
        return null;
    }

    public final EList<Integer> getRefIndexes(String className, String instanceName, String refInstanceName) {
        int instanceIndex = this.getInstanceIndex(className, instanceName);
        return this.getRefIndexes(className, instanceIndex, refInstanceName);
    }

    public final String getParamValue(String className, Integer instanceIndex, String paramName) {
        ClassInstanceId instanceId = new ClassInstanceId(className, instanceIndex);
        if (this.instanceIdToParamValueInfo.containsKey((Object)instanceId)) {
            MapOfParamNameToParamValue paramValueInfo = (MapOfParamNameToParamValue)((Object)this.instanceIdToParamValueInfo.get((Object)instanceId));
            String paramValue = (String)paramValueInfo.get(paramName);
            return paramValue;
        }
        return null;
    }

    public final String getParamValue(String className, String instanceName, String paramName) {
        ClassInstanceId instanceId = new ClassInstanceId(className, this.getInstanceIndex(className, instanceName));
        if (this.instanceIdToParamValueInfo.containsKey((Object)instanceId)) {
            MapOfParamNameToParamValue paramValueInfo = (MapOfParamNameToParamValue)((Object)this.instanceIdToParamValueInfo.get((Object)instanceId));
            String paramValue = (String)paramValueInfo.get(paramName);
            return paramValue;
        }
        return null;
    }

    public final EMap<String, String> getRefClassInfo(String className) {
        return (EMap)this.classNameToRefClassInfo.get((Object)className);
    }

    public final EMap<String, ParameterType> getParamInfo(String className) {
        return (EMap)this.classNameToParamTypeInfo.get((Object)className);
    }

    public Set<String> getClassNames() {
        return this.classNameToNumInstances.keySet();
    }

    public void addParameter(String className, int instanceIndex, String paramName, ParameterType paramType, String paramValue) {
        MapOfParamNameToParamValue paramNameToParamValue;
        ClassInstanceId instanceId = new ClassInstanceId(className, instanceIndex);
        if (this.instanceIdToParamValueInfo.containsKey((Object)instanceId)) {
            paramNameToParamValue = (MapOfParamNameToParamValue)((Object)this.instanceIdToParamValueInfo.get((Object)instanceId));
        } else {
            paramNameToParamValue = new MapOfParamNameToParamValue();
            this.instanceIdToParamValueInfo.put((Object)instanceId, (Object)paramNameToParamValue);
        }
        assert (!paramNameToParamValue.contains(paramName));
        paramNameToParamValue.put(paramName, paramValue);
        if (this.classNameToParamTypeInfo.containsKey((Object)className)) {
            MapOfParamNameToParamType paramInfo = (MapOfParamNameToParamType)((Object)this.classNameToParamTypeInfo.get((Object)className));
            paramInfo.put(paramName, (Object)paramType);
        } else {
            MapOfParamNameToParamType paramInfo = new MapOfParamNameToParamType();
            paramInfo.put(paramName, (Object)paramType);
            this.classNameToParamTypeInfo.put((Object)className, (Object)paramInfo);
        }
    }

    public void addParameter(String className, String instanceName, String paramName, ParameterType paramType, String paramValue) {
        int instanceIndex = this.getInstanceIndex(className, instanceName);
        this.addParameter(className, instanceIndex, paramName, paramType, paramValue);
    }

    private class ClassInstanceId
    extends Pair<String, Integer> {
        public ClassInstanceId(String left, Integer right) {
            super((Object)left, (Object)right);
        }
    }

    private class MapOfInstanceNameToClassName
    extends BasicEMap<String, String> {
        private static final long serialVersionUID = 1L;

        private MapOfInstanceNameToClassName() {
        }
    }

    private class MapOfInstanceNameToIndexes
    extends BasicEMap<String, EList<Integer>> {
        private static final long serialVersionUID = 1L;

        private MapOfInstanceNameToIndexes() {
        }
    }

    private class MapOfParamNameToParamType
    extends BasicEMap<String, ParameterType> {
        private static final long serialVersionUID = 1L;

        private MapOfParamNameToParamType() {
        }
    }

    private class MapOfParamNameToParamValue
    extends BasicEMap<String, String> {
        private static final long serialVersionUID = 1L;

        private MapOfParamNameToParamValue() {
        }
    }

    public static enum ParameterType {
        Boolean,
        String,
        Integer;

    }
}

