/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.CleanCTranslatorToPython.core.utils;

import java.util.ArrayList;
import java.util.List;

public class PythonUtil {
    private static boolean addSpace = true;
    public static final String NewLine = "\n";
    public static final String Ind = "    ";
    private static final String IS_TRIGGERED = "is_triggered";
    private static final String LEN = "len";
    public static final String For = "for";
    public static final String If = "if";
    public static final String Else = "else";
    private static final String in = "in";
    public static final String Return = "return";
    public static final String Pass = "pass";
    public static final String Self = "self";
    public static final String Equal = "=";
    public static final String LeftParen = "(";
    public static final String RightParen = ")";
    public static final String LeftBracket = "[";
    public static final String RightBracket = "]";
    public static final String Dot = ".";
    public static final String Comma = ",";
    public static final String Colon = ":";
    public static final String LogicalOrOperator = "or";
    public static final String LogicalAndOperator = "and";
    public static final String UnaryNotOperator = "not";
    public static final String All = "all";
    public static final String AllNotEmpty = "all_notempty";
    public static final String Any = "any";
    public static final String GreatThanOperator = ">";
    public static final String LessThanOperator = "<";
    public static final String GreatEqThanOperator = ">=";
    public static final String LessEqThanOperator = "<=";
    public static final String EqualOperator = "==";
    public static final String TrueKeyword = "True";
    public static final String FalseKeyword = "False";
    private static final String ListName = "Lista";
    @Deprecated
    public final String New3Lines = "\n\n\n";
    @Deprecated
    public final String Def = "def";
    @Deprecated
    public final String ElIf = "elif ";
    @Deprecated
    public final String LeftBrace = "{";
    @Deprecated
    public final String RightBrace = "}";
    @Deprecated
    public final String AndOperator = "&";
    @Deprecated
    public final String existsOperationName = "exists";
    @Deprecated
    public final String existsCall = "exists()";
    @Deprecated
    public final String getCommandArgMethodName = "get_command_arg";
    @Deprecated
    public final String getCurrCommandArgMethodName = "get_current_command_arg";
    @Deprecated
    public final String ImpliesOp = "=>";
    @Deprecated
    public final String ExOrOperator = "^";
    @Deprecated
    public final String BreakKeyword = "break";
    @Deprecated
    public final String Assert = "assert";

    public String getIndentationAsStr(int num_indentation) throws Exception {
        String indentation = "";
        int i = 0;
        while (i < num_indentation) {
            indentation = indentation.concat(Ind);
            ++i;
        }
        return indentation;
    }

    public String createIsTriggeredOperationCommand(String operationName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("'" + operationName + "'");
        return this.createSelfMethodCall(IS_TRIGGERED, args);
    }

    public String createSelfMethodCall(String methodName, List<String> args) {
        return "self." + this.createMethodCall(methodName, args);
    }

    public String createReturnStmt(String ind, String returnExprStr) {
        return String.valueOf(ind) + Return + " " + returnExprStr;
    }

    public String createReturnStmt(String returnExprStr) {
        return "return " + returnExprStr;
    }

    private String addSpace() {
        if (addSpace) {
            return " ";
        }
        return "";
    }

    public String createBinaryProposition(String leftProp, String op, String rightProp) {
        return String.valueOf(leftProp) + this.addSpace() + op + this.addSpace() + rightProp;
    }

    public String createDotExpr(String leftExpr, String rightExpr) {
        if (leftExpr.equals("")) {
            return rightExpr;
        }
        return String.valueOf(leftExpr) + Dot + rightExpr;
    }

    public String createOperationCall(String leftExpr, String rightExpr) {
        return String.valueOf(this.createDotExpr(leftExpr, rightExpr)) + LeftParen + RightParen;
    }

    public String createExistsPredicate(String list) {
        return "(len(" + list + RightParen + GreatThanOperator + "0" + RightParen;
    }

    public String createImpliesStatement(String cond, String stmt) {
        return "not " + cond + " " + LogicalOrOperator + " " + stmt;
    }

    public String createStatementListWithNl(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            res = res.concat(pyStmtList.get(i));
            if (i != pyStmtList.size() - 1) {
                res = String.valueOf(res) + NewLine;
            }
            ++i;
        }
        return res;
    }

    public String createAllExpression(String condition, String itId, String listId) {
        return "all(" + condition + " " + For + " " + itId + " " + in + " " + listId + RightParen;
    }

    public String createListUnionAssignment(String listUnionName, String value, String unionList, String it, String filterCondition) {
        String res = this.createListUnionAssignment(listUnionName, value, unionList, it);
        if (filterCondition != null) {
            res = String.valueOf(res) + " " + If + " " + filterCondition;
        }
        res = String.valueOf(res) + RightBracket;
        return res;
    }

    private String createListUnionAssignment(String listUnionName, String value, String unionList, String it) {
        return String.valueOf(listUnionName) + " " + Equal + " " + LeftBracket + value + " " + For + " " + ListName + " " + in + " " + unionList + " " + For + " " + it + " " + in + " " + ListName;
    }

    public String createUniqueValueFromList(String listUnionName, String value, String elseValue, String unionList, String it) {
        String res = String.valueOf(listUnionName) + LeftBracket + "0" + RightBracket + " " + If + " " + LEN + LeftParen + listUnionName + ") == 1 " + Else + " " + elseValue;
        return res;
    }

    public String createExistentialValueFromList(String listUnionName, String value, String elseValue, String unionList, String it) {
        String res = String.valueOf(listUnionName) + LeftBracket + "0" + RightBracket + " " + If + " " + LEN + LeftParen + listUnionName + ") >= 1 " + Else + " " + elseValue;
        return res;
    }

    public String createEveryValueFromList(String listUnionName, String value, String elseValue, String unionList, String it) {
        String res = String.valueOf(listUnionName) + LeftBracket + "0" + RightBracket + " " + If + " " + "(len(" + listUnionName + ") > 0 and all(v == " + listUnionName + "[0] for v in " + listUnionName + ")) " + Else + " " + elseValue;
        return res;
    }

    public String createAllExpression(String condition, String itId, String listId, String filterCondition) {
        return "all(" + condition + " " + For + " " + itId + " " + in + " " + listId + " " + If + " " + filterCondition + RightParen;
    }

    public String createAllExpressionNotEmpty(String expr, String itId, String listId) {
        return "all_notempty(" + expr + " " + For + " " + itId + " " + in + " " + listId + RightParen;
    }

    public String createAllExpressionNotEmpty(String expr, String itId, String listId, String filterCondition) {
        return "all_notempty(" + expr + " " + For + " " + itId + " " + in + " " + listId + " " + If + " " + filterCondition + RightParen;
    }

    public String createExprInParens(String expr) {
        if (expr == null) {
            return "()";
        }
        return LeftParen + expr + RightParen;
    }

    public String createNotProposition(String expr) {
        return UnaryNotOperator + this.addSpace() + expr;
    }

    public String createInclOrProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, LogicalOrOperator, rightProp);
    }

    public String createLogicAndProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, LogicalAndOperator, rightProp);
    }

    public String createMethodCall(String methodName, List<String> args) {
        String argsStr = null;
        if (args != null) {
            argsStr = this.createStatementListWithCommas(args);
        }
        String argsStrInParens = this.createExprInParens(argsStr);
        return String.valueOf(methodName) + argsStrInParens;
    }

    public String createStatementListWithCommas(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            if (i != 0) {
                res = res.concat(Comma);
            }
            res = res.concat(pyStmtList.get(i));
            ++i;
        }
        return res;
    }

    public String createIfThenElseStatement(String cond, String thenStmt, String elseStmt) {
        String ifCond = this.createIfThenStatement(cond, thenStmt);
        String elseCond = "else:\n" + elseStmt;
        return String.valueOf(ifCond) + NewLine + elseCond;
    }

    public String createAssignmentExpr(String left, String op, String right) {
        return String.valueOf(left) + this.addSpace() + op + this.addSpace() + right;
    }

    public String createAllStatement(String expr, String itId, String listId) {
        return "for " + itId + " " + in + " " + listId + Colon + NewLine + expr;
    }

    public String createIfThenStatement(String cond, String stmt) {
        return "if " + cond + Colon + NewLine + stmt;
    }

    public String createAnyExpression(String expr, String itId, String listId) {
        return "any(" + expr + " " + For + " " + itId + " " + in + " " + listId + RightParen;
    }

    public String createAnyExpression(String condition, String filter, String itId, String listId) {
        return "any(" + condition + " " + For + " " + itId + " " + in + " " + listId + " " + If + " " + filter + RightParen;
    }

    public String createUniqueExpression(String expr, String itId, String listId) {
        return String.valueOf(this.createAnyExpression(expr, itId, listId)) + " " + LogicalAndOperator + " " + LEN + LeftParen + listId + ") == 1 ";
    }

    public String createUniqueExpression(String condition, String filter, String itId, String listId) {
        return String.valueOf(this.createAnyExpression(condition, filter, itId, listId)) + " " + LogicalAndOperator + " " + LEN + LeftParen + listId + ") == 1 ";
    }

    @Deprecated
    public String createForStmt(String addIndentation, String iterId, String listId, String stmt) {
        return String.valueOf(addIndentation) + For + " " + iterId + " in " + listId + Colon + NewLine + stmt;
    }

    @Deprecated
    public String createElseStatement(String ind, String stmt) {
        return String.valueOf(ind) + Else + Colon + NewLine + stmt;
    }

    @Deprecated
    public boolean isExistsCall(String pyId) {
        return pyId.equals("exists()");
    }

    @Deprecated
    public String createGetCurrCommandArgStr(String argName) throws Exception {
        return String.valueOf(argName) + " = self" + Dot + "get_current_command_arg" + "('" + argName + "')";
    }

    @Deprecated
    public String getCommandArgMethodName(String operationName, String argAsStr) {
        return "self.get_command_arg('" + operationName + "'" + Comma + "'" + argAsStr + "')";
    }

    @Deprecated
    public String createFunctionDeclaration(String indentation, String funcDecl, String funcStmt) {
        return String.valueOf(indentation) + "def" + " " + funcDecl + Colon + NewLine + funcStmt;
    }

    @Deprecated
    public String createPyAssert(String addIndentation, String pyExpr) {
        return String.valueOf(addIndentation) + "assert" + " " + pyExpr;
    }

    @Deprecated
    public String createPassStmt(String ind) {
        return String.valueOf(ind) + Pass;
    }

    @Deprecated
    public String createStmt(String ind, String expr) {
        return String.valueOf(ind) + expr;
    }

    @Deprecated
    public String createDeclarator(String ind, String declName, String initValue) {
        return String.valueOf(ind) + declName + " " + Equal + " " + initValue;
    }

    @Deprecated
    public String createBooleanId(boolean booleanValue) {
        return booleanValue ? TrueKeyword : FalseKeyword;
    }

    @Deprecated
    public String createSelfDotExpr(String idName) {
        return "self." + idName;
    }

    @Deprecated
    public String createExprInBrackets(String expr) {
        return LeftBracket + expr + RightBracket;
    }

    @Deprecated
    public String createUnaryProposition(String op, String expr) {
        return String.valueOf(op) + expr;
    }

    @Deprecated
    public String createAndProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, "&", rightProp);
    }

    @Deprecated
    public String createExclOrProposition(String leftProp, String rightProp) {
        return this.createBinaryProposition(leftProp, "^", rightProp);
    }

    @Deprecated
    public String createLogicOrProposition(String leftProp, String rightProp) {
        if (leftProp.equals("")) {
            return rightProp;
        }
        return this.createBinaryProposition(leftProp, LogicalOrOperator, rightProp);
    }

    @Deprecated
    public String createExprInBraces(String expr) {
        return "{" + expr + "}";
    }

    @Deprecated
    public String createBreakStmt(String ind) {
        return String.valueOf(ind) + "break";
    }

    @Deprecated
    public String createStatementList(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            res = res.concat(pyStmtList.get(i));
            ++i;
        }
        return res;
    }

    @Deprecated
    public String createStatementListWithSpacesAndCommas(List<String> pyStmtList) {
        String res = "";
        int i = 0;
        while (i < pyStmtList.size()) {
            if (i != 0) {
                res = res.concat(this.addSpace());
            }
            res = res.concat(pyStmtList.get(i));
            if (i != pyStmtList.size() - 1) {
                res = res.concat(Comma);
            }
            ++i;
        }
        return res;
    }

    @Deprecated
    public String createAllStatement(String exprInd, String expr, String itId, String listId) {
        return "for " + itId + " " + in + " " + listId + Colon + NewLine + this.addIndentation(expr, exprInd);
    }

    @Deprecated
    public String createIfThenStatement(String cond, String indStmt, String stmt) {
        return "if " + cond + Colon + NewLine + this.addIndentation(stmt, indStmt);
    }

    @Deprecated
    public String addIndentation(String str, String ind) {
        return String.valueOf(ind) + str;
    }
}

