/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.dialogs;

import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.utils.ui.widgets.StyledText;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.AnalysisContextElement;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.service.core.utils.AnalysisResultUtil;

public class SelectFTAFMEAAnalysisCtxDialog
extends Dialog {
    private CCombo chooseAnalysisCtxField;
    private StyledText rootSystemText;
    private StyledText ftaConditionText;
    private Model model;
    private Class selectedComponent;
    private String system;
    private String ftaCondition;
    private SelectionListener modAnalysisCtxListener;
    private AnalysisContextElement analysisContext;
    private List<AnalysisContextElement> contextList;
    private Analysis analysis;
    private InstantiatedArchitectureConfiguration instantiatedArchitecture;

    public SelectFTAFMEAAnalysisCtxDialog(Shell shell, Class selectedComponent, InstantiatedArchitectureConfiguration instantiatedArchitecture, Model model, Analysis analysis) {
        super(shell);
        this.model = model;
        this.selectedComponent = selectedComponent;
        this.instantiatedArchitecture = instantiatedArchitecture;
        this.analysis = analysis;
        this.modAnalysisCtxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = SelectFTAFMEAAnalysisCtxDialog.this.chooseAnalysisCtxField.getSelectionIndex();
                if (selIndex != -1) {
                    AnalysisContextElement selAnalysisContext = (AnalysisContextElement)SelectFTAFMEAAnalysisCtxDialog.this.contextList.get(selIndex);
                    SelectFTAFMEAAnalysisCtxDialog.this.ftaConditionText.setText(StringArrayUtil.getConditionValue((EList)selAnalysisContext.getConditions(), (String)"property"));
                    SelectFTAFMEAAnalysisCtxDialog.this.setAnalysisContext(selAnalysisContext);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        new Label(parent, 0).setText("Analysis contexts found in model:");
        GridData gridData = new GridData(768);
        this.chooseAnalysisCtxField = new CCombo(parent, 2060);
        this.chooseAnalysisCtxField.setBackground(Display.getDefault().getSystemColor(1));
        this.contextList = AnalysisResultUtil.getInstance().getAnalysisContexts(this.selectedComponent, this.instantiatedArchitecture, this.analysis, this.model);
        BasicEList configs = new BasicEList();
        for (AnalysisContextElement ctx : this.contextList) {
            if (ctx.getRoot() == null) continue;
            configs.add((Object)ctx.getBase_Component().getQualifiedName());
        }
        this.chooseAnalysisCtxField.setItems((String[])configs.toArray((Object[])new String[0]));
        this.chooseAnalysisCtxField.addSelectionListener(this.modAnalysisCtxListener);
        this.chooseAnalysisCtxField.setLayoutData((Object)gridData);
        new Label(parent, 0).setText("Root element:");
        gridData = new GridData(768);
        this.rootSystemText = new StyledText(parent, 2060);
        this.rootSystemText.setText(this.selectedComponent.getQualifiedName());
        this.rootSystemText.setLayoutData((Object)gridData);
        String labelText = "";
        switch (this.analysis) {
            case FTA_ANALYSIS: {
                labelText = "FTA condition:";
                break;
            }
            case FMEA_ANALYSIS: {
                labelText = "FMEA conditions: (use ',' as delimiter)";
                break;
            }
        }
        new Label(parent, 0).setText(labelText);
        gridData = new GridData(768);
        this.ftaConditionText = new StyledText(parent, 2052);
        this.ftaConditionText.setText("");
        this.ftaConditionText.setLayoutData((Object)gridData);
        new Label(parent, 0).setText("");
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String shellText = "";
        switch (this.analysis) {
            case FTA_ANALYSIS: {
                shellText = "Select Analysis Context for FTA analysis";
                break;
            }
            case FMEA_ANALYSIS: {
                shellText = "Select Analysis Context for FMEA analysis";
                break;
            }
        }
        shell.setText(shellText);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setSystem(this.rootSystemText.getText());
        this.setFtaCondition(this.ftaConditionText.getText());
        super.okPressed();
    }

    public String getSystem() {
        return this.system;
    }

    private void setSystem(String system) {
        this.system = system;
    }

    public String getFtaCondition() {
        return this.ftaCondition;
    }

    private void setFtaCondition(String ftaCondition) {
        this.ftaCondition = ftaCondition;
    }

    public AnalysisContextElement getAnalysisContext() {
        return this.analysisContext;
    }

    public void setAnalysisContext(AnalysisContextElement analysisContext) {
        this.analysisContext = analysisContext;
    }
}

