/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.CompleteModelImpl;
import org.eclipse.ocl.pivot.internal.ModelImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.ModelListeners;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class PartialModels
extends EObjectResolvingEList<Model>
implements ModelListeners.IModelListener {
    public static final @NonNull TracingOption PARTIAL_MODELS = new TracingOption("org.eclipse.ocl.pivot", "partialModels");
    private static final long serialVersionUID = 1L;
    private static final @NonNull Model2RootOwnedPackages model2RootOwnedPackages = new Model2RootOwnedPackages();

    public PartialModels(@NonNull CompleteModelImpl owner) {
        super(Model.class, (InternalEObject)owner, 8);
    }

    public void addUnique(Model partialModel) {
        assert (partialModel != null);
        super.addUnique((Object)partialModel);
        this.didAdd(partialModel);
    }

    public void addUnique(int index, Model partialModel) {
        assert (partialModel != null);
        super.addUnique(index, (Object)partialModel);
        this.didAdd(partialModel);
    }

    protected void didAdd(@NonNull Model partialModel) {
        if (PARTIAL_MODELS.isActive()) {
            PARTIAL_MODELS.println("Do-didAdd Model" + this + " " + partialModel);
        }
        CompleteModelInternal completeModel = this.getCompleteModel();
        completeModel.didAddPartialModel(partialModel);
        for (Package pivotPackage : partialModel.getOwnedPackages()) {
            if (pivotPackage == null) continue;
            completeModel.didAddNestedPackage(pivotPackage);
        }
        ((ModelImpl)partialModel).addRootListener(this);
    }

    @Override
    public void didAddPackage(@NonNull Package partialPackage) {
        this.getCompleteModel().didAddNestedPackage(partialPackage);
    }

    protected void didRemove(int index, Model partialModel) {
        assert (partialModel != null);
        if (PARTIAL_MODELS.isActive()) {
            PARTIAL_MODELS.println("Do-didRemove Model " + this + " " + partialModel);
        }
        this.didRemove(partialModel);
    }

    protected void didRemove(@NonNull Model partialModel) {
        ((ModelImpl)partialModel).removeRootListener(this);
        CompleteModelInternal completeModel = this.getCompleteModel();
        for (Package pivotPackage : partialModel.getOwnedPackages()) {
            if (pivotPackage == null) continue;
            completeModel.didRemoveNestedPackage(pivotPackage);
        }
        completeModel.didRemovePartialModel(partialModel);
    }

    @Override
    public void didRemovePackage(@NonNull Package partialPackage) {
        this.getCompleteModel().didRemoveNestedPackage(partialPackage);
    }

    protected @NonNull CompleteModelInternal getCompleteModel() {
        return (CompleteModelInternal)this.owner;
    }

    protected @NonNull Iterable<Package> getNestedPartialPackages() {
        PartialModels partialModels = this.getCompleteModel().getPartialModels();
        Iterable roots_packages = Iterables.transform((Iterable)((Object)partialModels), (Function)model2RootOwnedPackages);
        @NonNull Iterable allPackages = Iterables.concat((Iterable)roots_packages);
        return allPackages;
    }

    private static class Model2RootOwnedPackages
    implements Function<Model, Iterable<Package>> {
        private Model2RootOwnedPackages() {
        }

        public Iterable<Package> apply(Model partialModel) {
            return partialModel.getOwnedPackages();
        }
    }
}

