/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.net4j;

import java.io.IOException;
import java.util.Timer;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositorySynchronizer;
import org.eclipse.emf.cdo.server.ISynchronizableRepository;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.spi.server.InternalFailoverParticipant;
import org.eclipse.emf.cdo.spi.server.InternalRepositorySynchronizer;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.signal.heartbeat.HeartBeatProtocol;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public abstract class FailoverAgent
extends Lifecycle
implements CDOSessionConfigurationFactory {
    private IConnector monitorConnector;
    private Timer timer;
    private long rate;
    private long timeout;
    private String group;
    private String connectorDescription;
    private InternalFailoverParticipant repository;
    private long repositoryActivationTimeout = 10000L;
    private Protocol protocol;
    private String masterConnectorDescription;
    private String masterRepositoryName;
    private InternalRepositorySynchronizer synchronizer;

    public IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    public IConnector getMonitorConnector() {
        return this.monitorConnector;
    }

    public void setMonitorConnector(IConnector connector) {
        this.checkInactive();
        this.monitorConnector = connector;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.checkInactive();
        this.timer = timer;
    }

    public long getRate() {
        return this.rate;
    }

    public void setRate(long rate) {
        this.checkInactive();
        this.rate = rate;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.checkInactive();
        this.timeout = timeout;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.checkInactive();
        this.group = group;
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public void setConnectorDescription(String connectorDescription) {
        this.checkInactive();
        this.connectorDescription = connectorDescription;
    }

    public ISynchronizableRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ISynchronizableRepository repository) {
        this.checkInactive();
        if (!(repository instanceof InternalFailoverParticipant)) {
            throw new IllegalArgumentException("Not a failover participant: " + repository);
        }
        if (repository.getSynchronizer() != null) {
            throw new IllegalArgumentException("Synchronizer must be null: " + repository);
        }
        this.repository = (InternalFailoverParticipant)repository;
    }

    public long getRepositoryActivationTimeout() {
        return this.repositoryActivationTimeout;
    }

    public void setRepositoryActivationTimeout(long repositoryActivationTimeout) {
        this.checkInactive();
        this.repositoryActivationTimeout = repositoryActivationTimeout;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public CDOSessionConfiguration createSessionConfiguration() {
        return this.createSessionConfiguration(this.masterConnectorDescription, this.masterRepositoryName);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.monitorConnector, "monitorConnector");
        this.checkState(this.group, "group");
        this.checkState(this.connectorDescription, "connectorDescription");
        this.checkState(this.repository, "repository");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IManagedContainer container = this.getContainer();
        if (this.timer == null) {
            this.timer = (Timer)container.getElement("org.eclipse.net4j.util.timers", "daemon", null);
        }
        this.synchronizer = (InternalRepositorySynchronizer)this.createRepositorySynchronizer();
        this.repository.setSynchronizer(this.synchronizer);
        this.protocol = new Protocol(this);
        this.protocol.start(this.rate, this.timeout);
        if (!LifecycleUtil.waitForActive((Object)this.repository, (long)this.repositoryActivationTimeout)) {
            LifecycleUtil.checkActive((Object)this.repository);
        }
    }

    protected void doDeactivate() throws Exception {
        this.protocol.close();
        this.protocol = null;
        this.timer = null;
        this.monitorConnector = null;
        super.doDeactivate();
    }

    protected void setMaster() {
        this.repository.setType(CDOCommonRepository.Type.MASTER);
        this.masterConnectorDescription = null;
        this.masterRepositoryName = null;
    }

    protected void setBackup(String connectorDescription, String repositoryName) {
        this.masterConnectorDescription = connectorDescription;
        this.masterRepositoryName = repositoryName;
        this.repository.setType(CDOCommonRepository.Type.BACKUP);
    }

    protected IRepositorySynchronizer createRepositorySynchronizer() {
        return CDOServerUtil.createRepositorySynchronizer((CDOSessionConfigurationFactory)this);
    }

    protected abstract CDOSessionConfiguration createSessionConfiguration(String var1, String var2);

    public static class Protocol
    extends HeartBeatProtocol {
        private FailoverAgent agent;

        public Protocol(FailoverAgent agent) {
            super("failover", agent.getMonitorConnector(), agent.getTimer());
            this.agent = agent;
        }

        public FailoverAgent getAgent() {
            return this.agent;
        }

        protected void requestingStart(ExtendedDataOutputStream out, long rate) throws IOException {
            out.writeString(this.agent.getGroup());
            out.writeString(this.agent.getConnectorDescription());
            out.writeString(this.agent.getRepository().getName());
            super.requestingStart(out, rate);
        }

        protected SignalReactor createSignalReactor(short signalID) {
            switch (signalID) {
                case 3: {
                    return new Indication((SignalProtocol)this, 3){

                        protected void indicating(ExtendedDataInputStream in) throws Exception {
                            boolean master = in.readBoolean();
                            if (master) {
                                Protocol.this.agent.setMaster();
                            } else {
                                String connectorDescription = in.readString();
                                String repositoryName = in.readString();
                                Protocol.this.agent.setBackup(connectorDescription, repositoryName);
                            }
                            ISynchronizableRepository repository = Protocol.this.agent.getRepository();
                            if (!repository.isActive()) {
                                IManagedContainer container = Protocol.this.agent.getContainer();
                                CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)repository);
                            }
                        }
                    };
                }
            }
            return super.createSignalReactor(signalID);
        }
    }
}

