/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.server.IPermissionManager;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;

public class LoadPermissionsIndication
extends CDOServerReadIndication {
    private CDOID[] ids;
    private CDOPermission[] oldPermissions;
    private int referenceChunk;

    public LoadPermissionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)55);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int length = in.readInt();
        this.ids = new CDOID[length];
        this.oldPermissions = new CDOPermission[length];
        int i = 0;
        while (i < length) {
            this.ids[i] = in.readCDOID();
            this.oldPermissions[i] = CDOPermission.get((int)in.readByte());
            ++i;
        }
        this.referenceChunk = in.readInt();
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalSession session = this.getSession();
        InternalRepository repository = this.getRepository();
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        IPermissionManager permissionManager = repository.getSessionManager().getPermissionManager();
        CDOBranchPoint head = repository.getBranchManager().getMainBranch().getHead();
        int length = this.ids.length;
        int i = 0;
        while (i < length) {
            CDOID id = this.ids[i];
            CDOPermission oldPermission = this.oldPermissions[i];
            InternalCDORevision revision = revisionManager.getRevision(id, head, 0, 0, true);
            if (revision == null) {
                out.writeByte(-1);
            }
            CDOPermission newPermission = permissionManager.getPermission((CDORevision)revision, head, (ISession)session);
            out.writeByte((int)newPermission.getBits());
            if (oldPermission == CDOPermission.NONE && newPermission != CDOPermission.NONE) {
                revision.writeValues(out, this.referenceChunk);
            }
            ++i;
        }
    }
}

