/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.tabprovider;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.eef.EEFGroupStyle;
import org.eclipse.eef.EEF_TITLE_BAR_STYLE;
import org.eclipse.eef.EEF_TOGGLE_STYLE;
import org.eclipse.eef.EefFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.properties.GroupStyle;
import org.eclipse.sirius.ui.properties.api.AbstractDescriptionConverter;
import org.eclipse.sirius.ui.properties.api.DescriptionCache;
import org.eclipse.sirius.ui.properties.internal.Messages;
import org.eclipse.sirius.viewpoint.description.ColorDescription;

public class GroupStyleDescriptionConverter
extends AbstractDescriptionConverter {
    @Override
    public boolean canHandle(EObject description) {
        return description instanceof GroupStyle;
    }

    @Override
    public EObject convert(EObject description, Map<String, Object> parameters, DescriptionCache cache) {
        if (description instanceof GroupStyle) {
            String foregroundColorExpression;
            ColorDescription foregroundColorDescription;
            String backgroundColorExpression;
            GroupStyle groupStyle = (GroupStyle)description;
            EEFGroupStyle eefGroupStyle = EefFactory.eINSTANCE.createEEFGroupStyle();
            ColorDescription backgroundColorDescription = groupStyle.getBackgroundColor();
            if (backgroundColorDescription != null && (backgroundColorExpression = this.getColorExpression(backgroundColorDescription, parameters)) != null) {
                eefGroupStyle.setBackgroundColorExpression(backgroundColorExpression);
            }
            if ((foregroundColorDescription = groupStyle.getForegroundColor()) != null && (foregroundColorExpression = this.getColorExpression(foregroundColorDescription, parameters)) != null) {
                eefGroupStyle.setForegroundColorExpression(foregroundColorExpression);
            }
            eefGroupStyle.setFontNameExpression(groupStyle.getFontNameExpression());
            eefGroupStyle.setFontSizeExpression(groupStyle.getFontSizeExpression());
            eefGroupStyle.setBarStyle(EEF_TITLE_BAR_STYLE.get((int)groupStyle.getBarStyle().getValue()));
            eefGroupStyle.setToggleStyle(EEF_TOGGLE_STYLE.get((int)groupStyle.getToggleStyle().getValue()));
            eefGroupStyle.setExpandedByDefault(groupStyle.isExpandedByDefault());
            cache.put(description, eefGroupStyle);
            return eefGroupStyle;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.IDescriptionConverter_InvalidDescriptionType, description.getClass().getName(), GroupStyle.class.getName()));
    }
}

