/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.tabprovider;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFGroupConditionalStyle;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFGroupStyle;
import org.eclipse.eef.EEFPropertyValidationRuleDescription;
import org.eclipse.eef.EEFSemanticValidationRuleDescription;
import org.eclipse.eef.EefFactory;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.GroupValidationSetDescription;
import org.eclipse.sirius.ui.properties.api.AbstractDescriptionConverter;
import org.eclipse.sirius.ui.properties.api.DescriptionCache;
import org.eclipse.sirius.ui.properties.internal.Messages;

public class GroupDescriptionConverter
extends AbstractDescriptionConverter {
    @Override
    public boolean canHandle(EObject description) {
        return description instanceof GroupDescription;
    }

    @Override
    public EObject convert(EObject description, Map<String, Object> parameters, DescriptionCache cache) {
        if (description instanceof GroupDescription) {
            GroupDescription groupDescription = (GroupDescription)description;
            EEFGroupDescription eefGroup = EefFactory.eINSTANCE.createEEFGroupDescription();
            eefGroup.setIdentifier(groupDescription.getIdentifier());
            if (Util.isBlank((String)eefGroup.getIdentifier())) {
                eefGroup.setIdentifier(EcoreUtil.getURI((EObject)groupDescription).toString());
            }
            eefGroup.setLabelExpression(groupDescription.getLabelExpression());
            eefGroup.setDomainClass(groupDescription.getDomainClass());
            eefGroup.setSemanticCandidateExpression(groupDescription.getSemanticCandidateExpression());
            eefGroup.setPreconditionExpression(groupDescription.getPreconditionExpression());
            cache.put(description, eefGroup);
            eefGroup.setStyle(this.convertEObject((EObject)groupDescription.getStyle(), parameters, cache, EEFGroupStyle.class));
            eefGroup.getConditionalStyles().addAll(this.convertCollection((Collection<?>)groupDescription.getConditionalStyles(), parameters, cache, EEFGroupConditionalStyle.class));
            eefGroup.getControls().addAll(this.convertCollection((Collection<?>)groupDescription.getControls(), parameters, cache, EEFControlDescription.class));
            if (groupDescription.getValidationSet() != null) {
                GroupValidationSetDescription validationSet = groupDescription.getValidationSet();
                eefGroup.getSemanticValidationRules().addAll(this.convertCollection((Collection<?>)validationSet.getSemanticValidationRules(), parameters, cache, EEFSemanticValidationRuleDescription.class));
                eefGroup.getPropertyValidationRules().addAll(this.convertCollection((Collection<?>)validationSet.getPropertyValidationRules(), parameters, cache, EEFPropertyValidationRuleDescription.class));
            }
            return eefGroup;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.IDescriptionConverter_InvalidDescriptionType, description.getClass().getName(), GroupDescription.class.getName()));
    }
}

