/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.expressions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.dialect.description.ToolInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.properties.DynamicMappingFor;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.tools.api.interpreter.context.SiriusInterpreterContextFactory;
import org.eclipse.sirius.ui.properties.internal.SiriusInputDescriptor;
import org.eclipse.sirius.ui.properties.internal.SiriusToolServices;
import org.eclipse.sirius.ui.properties.internal.expressions.DomainClassSwitch;
import org.eclipse.sirius.ui.properties.internal.expressions.VSMNavigation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Extension;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;

public final class PropertiesInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    private Collection<EPackage> packagesToImport;

    public PropertiesInterpretedExpressionQuery(EObject target, EStructuralFeature expressionAttribute) {
        super(target, expressionAttribute);
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new PropertiesExpressionsGlobalTargetSwitch(this.feature);
    }

    public Collection<EPackage> getPackagesToImport() {
        if (this.packagesToImport == null) {
            this.packagesToImport = PropertiesInterpretedExpressionQuery.getEPackagesInScope(this.target);
        }
        return this.packagesToImport;
    }

    public Collection<String> getDependencies() {
        if (this.dependencies == null) {
            ArrayList result = Lists.newArrayList(VSMNavigation.getJavaExtensionsInVSM(this.target));
            result.add(SiriusToolServices.class.getName());
            this.dependencies = result;
        }
        return this.dependencies;
    }

    private static Collection<EPackage> getEPackagesInScope(EObject target) {
        Option viewDescriptionOpt;
        LinkedHashSet result = Sets.newLinkedHashSet();
        boolean needsGlobalPackages = false;
        for (RepresentationDescription desc : VSMNavigation.getRepresentationDescriptionsInVSM(target)) {
            EList configured = desc.getMetamodel();
            result.addAll(configured);
            if (!configured.isEmpty()) continue;
            needsGlobalPackages = true;
        }
        if (needsGlobalPackages) {
            result.addAll(PropertiesInterpretedExpressionQuery.getAllRegisteredEPackages(EPackage.Registry.INSTANCE));
        }
        if ((viewDescriptionOpt = new EObjectQuery(target).getFirstAncestorOfType(PropertiesPackage.Literals.VIEW_EXTENSION_DESCRIPTION)).some()) {
            ViewExtensionDescription ved = (ViewExtensionDescription)viewDescriptionOpt.get();
            result.addAll(ved.getMetamodels());
        }
        result.add(EcorePackage.eINSTANCE);
        result.add(ViewpointPackage.eINSTANCE);
        result.add(DescriptionPackage.eINSTANCE);
        result.add(ToolPackage.eINSTANCE);
        result.add(ValidationPackage.eINSTANCE);
        result.add(PropertiesPackage.eINSTANCE);
        return result;
    }

    private static Collection<EPackage> getAllRegisteredEPackages(EPackage.Registry source) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (String nsURI : Sets.newLinkedHashSet((Iterable)source.keySet())) {
            try {
                result.add(source.getEPackage(nsURI));
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public Map<String, VariableType> getAvailableVariables() {
        boolean isPropertiesElement;
        if (this.availableVariables == null) {
            this.availableVariables = Maps.newLinkedHashMap();
        }
        boolean bl = isPropertiesElement = this.target.eClass().getEPackage() == PropertiesPackage.eINSTANCE;
        if (isPropertiesElement) {
            DynamicMappingFor forDefinition;
            String iteratorName;
            this.availableVariables.put("input", VariableType.fromString((String)SiriusInputDescriptor.class.getName()));
            if (this.feature == PropertiesPackage.Literals.SELECT_DESCRIPTION__CANDIDATE_DISPLAY_EXPRESSION) {
                VariableType candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.SELECT_DESCRIPTION__CANDIDATES_EXPRESSION);
                this.availableVariables.put("candidate", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.RADIO_DESCRIPTION__CANDIDATE_DISPLAY_EXPRESSION) {
                VariableType candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.RADIO_DESCRIPTION__CANDIDATES_EXPRESSION);
                this.availableVariables.put("candidate", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.LABEL_DESCRIPTION__DISPLAY_EXPRESSION) {
                VariableType candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.LABEL_DESCRIPTION__VALUE_EXPRESSION);
                this.availableVariables.put("value", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.LIST_DESCRIPTION__DISPLAY_EXPRESSION) {
                VariableType candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.LIST_DESCRIPTION__VALUE_EXPRESSION);
                this.availableVariables.put("value", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.HYPERLINK_DESCRIPTION__DISPLAY_EXPRESSION) {
                VariableType candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.HYPERLINK_DESCRIPTION__VALUE_EXPRESSION);
                this.availableVariables.put("value", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.DYNAMIC_MAPPING_IF__PREDICATE_EXPRESSION && this.target.eContainer() instanceof DynamicMappingFor && !Util.isBlank((String)(iteratorName = (forDefinition = (DynamicMappingFor)this.target.eContainer()).getIterator()))) {
                VariableType iteratorType = this.getResultType((EObject)forDefinition, PropertiesPackage.Literals.DYNAMIC_MAPPING_FOR__ITERABLE_EXPRESSION);
                this.availableVariables.put(iteratorName, iteratorType);
            }
            return this.availableVariables;
        }
        return super.getAvailableVariables();
    }

    protected Option<EObject> getToolContext() {
        Option result = super.getToolContext();
        if (!result.some()) {
            result = this.target instanceof PageDescription || this.target instanceof GroupDescription ? Options.newSome((Object)this.target) : new EObjectQuery(this.target).getFirstAncestorOfType(ToolPackage.Literals.INITIAL_OPERATION);
        }
        return result;
    }

    protected void addVariablesFromToolContext(EObject toolContext) {
        super.addVariablesFromToolContext(toolContext);
        this.availableVariables.put("input", VariableType.fromString((String)SiriusInputDescriptor.class.getName()));
        if (toolContext instanceof InitialOperation) {
            EReference callbackFeature = toolContext.eContainmentFeature();
            VariableType stringType = VariableType.fromString((String)"java.lang.String");
            VariableType booleanType = VariableType.fromString((String)"java.lang.Boolean");
            VariableType unkownType = VariableType.fromString((String)TypeName.EOBJECT_TYPENAME.getCompleteName());
            if (callbackFeature == PropertiesPackage.Literals.TEXT_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", stringType);
            } else if (callbackFeature == PropertiesPackage.Literals.CHECKBOX_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", booleanType);
            } else if (callbackFeature == PropertiesPackage.Literals.HYPERLINK_DESCRIPTION__INITIAL_OPERATION) {
                Option<Collection<String>> domainClass = VSMNavigation.getDomainClassFromContainingGroup(toolContext);
                if (domainClass.some()) {
                    this.availableVariables.put("selection", VariableType.fromStrings((Collection)((Collection)domainClass.get())));
                } else {
                    this.availableVariables.put("selection", unkownType);
                }
            } else if (callbackFeature == PropertiesPackage.Literals.RADIO_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", stringType);
            } else if (callbackFeature == PropertiesPackage.Literals.WIDGET_ACTION__INITIAL_OPERATION) {
                Option<Collection<String>> domainClass = VSMNavigation.getDomainClassFromContainingGroup(toolContext);
                if (!domainClass.some()) {
                    this.availableVariables.put("selection", VariableType.fromStrings((Collection)((Collection)domainClass.get())));
                } else {
                    this.availableVariables.put("selection", unkownType);
                }
            } else if (callbackFeature == PropertiesPackage.Literals.SELECT_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", stringType);
            }
        }
    }

    private VariableType getResultType(EObject owner, EAttribute attr) {
        IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext((EObject)owner, (EStructuralFeature)attr);
        ValidationResult res = MultiLanguagesValidator.getInstance().validateExpression(context, (String)owner.eGet((EStructuralFeature)attr));
        return res.getReturnTypes();
    }

    private static class PropertiesExpressionsGlobalTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private final DomainClassSwitch propertiesSwitch;
        private final ToolInterpretedExpressionTargetSwitch delegateSwitch;

        public PropertiesExpressionsGlobalTargetSwitch(EStructuralFeature feature) {
            this.propertiesSwitch = new DomainClassSwitch(feature);
            this.delegateSwitch = new CustomToolInterpretedExpressionTargetSwitch(feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = Sets.newLinkedHashSet();
            Option expressionTarget = Options.newSome((Object)targetTypes);
            if (target != null) {
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.propertiesSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.propertiesSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.delegateSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.delegateSwitch.doSwitch(target);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            if (obj != null) {
                EObject container = obj.eContainer();
                while (container != null && !this.isRelevant(container)) {
                    container = container.eContainer();
                }
                return container;
            }
            return null;
        }

        private boolean isRelevant(EObject container) {
            return container instanceof PageDescription || container instanceof GroupDescription;
        }

        private static class CustomToolInterpretedExpressionTargetSwitch
        extends ToolInterpretedExpressionTargetSwitch {
            public CustomToolInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultSwitch) {
                super(feature, defaultSwitch);
            }

            protected EObject getFirstContextChangingContainer(EObject element) {
                EObject defaultResult = super.getFirstContextChangingContainer(element);
                if (defaultResult instanceof Extension) {
                    return VSMNavigation.findClosestGroupDescription(element);
                }
                return defaultResult;
            }
        }
    }
}

