/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.views;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.Domain;
import org.polarsys.chess.core.internal.views.permissions.EntryId;
import org.polarsys.chess.core.internal.views.permissions.PermissionList;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.core.views.ViewUtils;

public class InternalViewUtils {
    public static String getViewName(Package pkg) {
        Stereotype s = InternalViewUtils.getViewStereotypeApplied(pkg);
        return s != null ? s.getName() : null;
    }

    public static Stereotype getViewStereotypeApplied(Package pkg) {
        if (pkg == null) {
            return null;
        }
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!ViewUtils.isViewStereotype(stereotype)) continue;
            return stereotype;
        }
        return null;
    }

    public static Package getViewWithThrows(EObject ob) throws Exception {
        if (ob == null) {
            throw new Exception("containing object is null");
        }
        Package pkg = null;
        if (ob instanceof Package && InternalViewUtils.hasViewStereotypeApplied(pkg = (Package)ob)) {
            return pkg;
        }
        return InternalViewUtils.getViewWithThrows(ob.eContainer());
    }

    public static boolean hasViewStereotypeApplied(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!ViewUtils.isViewStereotype(stereotype)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isElementWritable(Element element, DiagramStatus.DesignView currentView) {
        Package view = null;
        view = ViewUtils.getView(element.eContainer());
        if (view != null && currentView != null) {
            String viewName = InternalViewUtils.getViewName(view);
            return currentView.isEnabled(viewName);
        }
        return true;
    }

    public static boolean isView(EObject notifier) {
        if (notifier instanceof Package && InternalViewUtils.hasViewStereotypeApplied((Package)notifier)) {
            return true;
        }
        return CHESSProfileManager.CHESS_VIEWS_LIST.contains(notifier.eClass().getName());
    }

    public static Package getCHESSRequirementPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isRequirementView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSSystemPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isSystemView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSComponentPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isComponentView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static boolean checkPermission(DiagramStatus.DesignView designView, EntryId entryId, byte permission, Domain theDomain) {
        if (entryId.isANY()) {
            return true;
        }
        PermissionList l = designView.getEnabledPermissions(theDomain);
        return l == null || l.checkPermission(entryId, permission);
    }

    public static boolean checkPermission(String viewName, EntryId entryId, byte permission, DiagramStatus.DesignView currentView, Domain theDomain) {
        if (entryId.isANY()) {
            return true;
        }
        PermissionList l = currentView.getEnabledPermissions(viewName, theDomain);
        return l == null || l.checkPermission(entryId, permission);
    }
}

